/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.GetLengthHelperNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;

@ImportStatic(value={JSInteropUtil.class})
abstract class GetLengthHelperNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private JSToUInt32Node toUInt32Node;
    @Node.Child
    private JSToLengthNode toLengthNode;
    private final boolean toLength;

    GetLengthHelperNode(JSContext context) {
        this.context = context;
        this.toLength = context.getEcmaScriptVersion() >= 6;
    }

    public static GetLengthHelperNode create(JSContext context) {
        return GetLengthHelperNodeGen.create(context);
    }

    public abstract Object execute(Object var1, boolean var2);

    public final long executeLong(Object value, boolean isArray) {
        return this.toLengthLong(this.execute(value, isArray));
    }

    @Specialization(guards={"isArray"}, rewriteOn={UnexpectedResultException.class})
    public int getArrayLengthInt(DynamicObject target, boolean isArray, @Cached(value="create()") ArrayLengthNode.ArrayLengthReadNode arrayLengthReadNode) throws UnexpectedResultException {
        return arrayLengthReadNode.executeInt(target);
    }

    @Specialization(guards={"isArray"})
    public double getArrayLength(DynamicObject target, boolean isArray, @Cached(value="create()") ArrayLengthNode.ArrayLengthReadNode arrayLengthReadNode) {
        return arrayLengthReadNode.executeDouble(target);
    }

    @Specialization(guards={"!isArray"})
    public double getLengthDynamicObject(DynamicObject target, boolean isArray, @Cached(value="createLengthProperty()") PropertyNode getLengthPropertyNode) {
        return this.toLengthDouble(getLengthPropertyNode.executeWithTarget(target));
    }

    @Specialization(guards={"!isDynamicObject(target)"}, limit="3")
    public double getLengthForeign(Object target, boolean isArray, @CachedLibrary(value="target") InteropLibrary interop, @Cached(value="create()") ImportValueNode importValueNode) {
        if (interop.hasArrayElements(target)) {
            return JSInteropUtil.getArraySize(target, interop, this);
        }
        return this.toLengthDouble(JSInteropUtil.readMemberOrDefault(target, "length", 0, interop, importValueNode, this));
    }

    protected PropertyNode createLengthProperty() {
        return PropertyNode.createProperty(this.context, null, "length");
    }

    private double toUInt32Double(Object target) {
        return JSRuntime.doubleValue((Number)this.getUInt32Node().execute(target));
    }

    private long toUInt32Long(Object target) {
        return JSRuntime.longValue((Number)this.getUInt32Node().execute(target));
    }

    private double toLengthDouble(Object target) {
        if (this.toLength) {
            return this.getToLengthNode().executeLong(target);
        }
        return this.toUInt32Double(target);
    }

    private long toLengthLong(Object target) {
        if (this.toLength) {
            return this.getToLengthNode().executeLong(target);
        }
        return this.toUInt32Long(target);
    }

    private JSToLengthNode getToLengthNode() {
        if (this.toLengthNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toLengthNode = (JSToLengthNode)this.insert(JSToLengthNode.create());
        }
        return this.toLengthNode;
    }

    private JSToUInt32Node getUInt32Node() {
        if (this.toUInt32Node == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toUInt32Node = (JSToUInt32Node)this.insert(JSToUInt32Node.create());
        }
        return this.toUInt32Node;
    }
}

