/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.onsave;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.batch.Scopes;
import org.netbeans.spi.editor.document.OnSaveTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RemoveUnusedAfterSave
implements OnSaveTask {
    public static final String KEY_SETTINGS_PREFIX = "on-save.";
    private final OnSaveTask.Context c;
    private final JavaSource javaSource;
    private final Set<String> toRun;
    private final AtomicBoolean cancel = new AtomicBoolean();
    private static final Map<String, Boolean> id2DefaultState = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> id2SavedState = new HashMap<String, Boolean>();

    public RemoveUnusedAfterSave(OnSaveTask.Context c, JavaSource javaSource, Set<String> toRun) {
        this.c = c;
        this.javaSource = javaSource;
        this.toRun = toRun;
    }

    public void performTask() {
        try {
            ArrayList hints = new ArrayList();
            for (Map.Entry e : RulesManager.getInstance().readHints(null, null, this.cancel).entrySet()) {
                if (!this.toRun.contains(((HintMetadata)e.getKey()).id)) continue;
                hints.addAll((Collection)e.getValue());
            }
            FileObject file = (FileObject)this.javaSource.getFileObjects().iterator().next();
            BatchSearch.BatchResult batchResult = BatchSearch.findOccurrences(hints, (BatchSearch.Scope)Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert((FileObject[])new FileObject[]{file})));
            for (ModificationResult mr : BatchUtilities.applyFixes((BatchSearch.BatchResult)batchResult, (ProgressHandleWrapper)new ProgressHandleWrapper(new int[]{1}), (AtomicBoolean)this.cancel, new ArrayList(), null, (boolean)true, new ArrayList())) {
                mr.commit();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void runLocked(final Runnable run) {
        try {
            this.javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    run.run();
                }
            }, true);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean cancel() {
        return false;
    }

    static boolean getValue(Preferences settings, String id) {
        String saved = settings.get(KEY_SETTINGS_PREFIX + id, null);
        if (saved == null) {
            id2SavedState.put(KEY_SETTINGS_PREFIX + id, id2DefaultState.get(id));
            return id2DefaultState.get(id);
        }
        id2SavedState.put(KEY_SETTINGS_PREFIX + id, Boolean.parseBoolean(saved));
        return Boolean.parseBoolean(saved);
    }

    static boolean getSavedValue(String id) {
        return id2SavedState.get(id);
    }

    static {
        id2DefaultState.put("Imports_UNUSED", false);
        id2DefaultState.put("org.netbeans.modules.java.hints.OrganizeImports", false);
    }

    public static class TaskFactory
    implements OnSaveTask.Factory {
        public OnSaveTask createTask(OnSaveTask.Context context) {
            JavaSource javaSource = JavaSource.forDocument((Document)context.getDocument());
            if (javaSource == null) {
                return null;
            }
            HashSet<String> toRun = new HashSet<String>();
            Preferences settings = (Preferences)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(Preferences.class);
            for (Map.Entry e : id2DefaultState.entrySet()) {
                if (!settings.getBoolean(RemoveUnusedAfterSave.KEY_SETTINGS_PREFIX + (String)e.getKey(), (Boolean)e.getValue())) continue;
                toRun.add((String)e.getKey());
            }
            if (toRun.isEmpty()) {
                return null;
            }
            return new RemoveUnusedAfterSave(context, javaSource, toRun);
        }
    }
}

