/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.VmClusterUpdateSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListVmClusterUpdatesRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private UpdateType updateType;
    private VmClusterUpdateSummary.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"vmClusterId", "updateType", "lifecycleState", "limit", "page", "opcRequestId"})
    ListVmClusterUpdatesRequest(String vmClusterId, UpdateType updateType, VmClusterUpdateSummary.LifecycleState lifecycleState, Integer limit, String page, String opcRequestId) {
        this.vmClusterId = vmClusterId;
        this.updateType = updateType;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().vmClusterId(this.vmClusterId).updateType(this.updateType).lifecycleState(this.lifecycleState).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListVmClusterUpdatesRequest(super=" + super.toString() + ", vmClusterId=" + this.getVmClusterId() + ", updateType=" + (Object)((Object)this.getUpdateType()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListVmClusterUpdatesRequest)) {
            return false;
        }
        ListVmClusterUpdatesRequest other = (ListVmClusterUpdatesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$vmClusterId = this.getVmClusterId();
        String other$vmClusterId = other.getVmClusterId();
        if (this$vmClusterId == null ? other$vmClusterId != null : !this$vmClusterId.equals(other$vmClusterId)) {
            return false;
        }
        UpdateType this$updateType = this.getUpdateType();
        UpdateType other$updateType = other.getUpdateType();
        if (this$updateType == null ? other$updateType != null : !((Object)((Object)this$updateType)).equals((Object)other$updateType)) {
            return false;
        }
        VmClusterUpdateSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        VmClusterUpdateSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListVmClusterUpdatesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $vmClusterId = this.getVmClusterId();
        result = result * 59 + ($vmClusterId == null ? 43 : $vmClusterId.hashCode());
        UpdateType $updateType = this.getUpdateType();
        result = result * 59 + ($updateType == null ? 43 : ((Object)((Object)$updateType)).hashCode());
        VmClusterUpdateSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public VmClusterUpdateSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVmClusterUpdatesRequest, Void> {
        private String vmClusterId;
        private UpdateType updateType;
        private VmClusterUpdateSummary.LifecycleState lifecycleState;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVmClusterUpdatesRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.updateType(o.getUpdateType());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVmClusterUpdatesRequest build() {
            ListVmClusterUpdatesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder lifecycleState(VmClusterUpdateSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListVmClusterUpdatesRequest buildWithoutInvocationCallback() {
            return new ListVmClusterUpdatesRequest(this.vmClusterId, this.updateType, this.lifecycleState, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListVmClusterUpdatesRequest.Builder(vmClusterId=" + this.vmClusterId + ", updateType=" + (Object)((Object)this.updateType) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum UpdateType {
        GiUpgrade("GI_UPGRADE"),
        GiPatch("GI_PATCH"),
        OsUpdate("OS_UPDATE");

        private final String value;
        private static Map<String, UpdateType> map;

        private UpdateType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpdateType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UpdateType: " + key);
        }

        static {
            map = new HashMap<String, UpdateType>();
            for (UpdateType v : UpdateType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

