/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline.items;

import org.netbeans.modules.profiler.snaptracer.ItemValueFormatter;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;

public abstract class ValueItemDescriptor
extends ProbeItemDescriptor {
    private final ItemValueFormatter formatter;
    private final double dataFactor;
    private final long minValue;
    private final long maxValue;

    ValueItemDescriptor(String name, String description, ItemValueFormatter formatter, double dataFactor, long minValue, long maxValue) {
        super(name, description);
        if (formatter == null) {
            throw new IllegalArgumentException("formatter cannot be null");
        }
        if (dataFactor == 0.0) {
            throw new IllegalArgumentException("dataFactor cannot be 0");
        }
        this.formatter = formatter;
        this.dataFactor = dataFactor;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public final String getValueString(long value, int format) {
        return this.formatter.formatValue(value, format);
    }

    public final String getUnitsString(int format) {
        return this.formatter.getUnits(format);
    }

    public final double getDataFactor() {
        return this.dataFactor;
    }

    public final long getMinValue() {
        return this.minValue;
    }

    public final long getMaxValue() {
        return this.maxValue;
    }
}

