/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteCustomerSecretKeyRequest
extends BmcRequest<Void> {
    private String userId;
    private String customerSecretKeyId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "customerSecretKeyId", "ifMatch"})
    DeleteCustomerSecretKeyRequest(String userId, String customerSecretKeyId, String ifMatch) {
        this.userId = userId;
        this.customerSecretKeyId = customerSecretKeyId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).customerSecretKeyId(this.customerSecretKeyId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteCustomerSecretKeyRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", customerSecretKeyId=" + this.getCustomerSecretKeyId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteCustomerSecretKeyRequest)) {
            return false;
        }
        DeleteCustomerSecretKeyRequest other = (DeleteCustomerSecretKeyRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$customerSecretKeyId = this.getCustomerSecretKeyId();
        String other$customerSecretKeyId = other.getCustomerSecretKeyId();
        if (this$customerSecretKeyId == null ? other$customerSecretKeyId != null : !this$customerSecretKeyId.equals(other$customerSecretKeyId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteCustomerSecretKeyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $customerSecretKeyId = this.getCustomerSecretKeyId();
        result = result * 59 + ($customerSecretKeyId == null ? 43 : $customerSecretKeyId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCustomerSecretKeyId() {
        return this.customerSecretKeyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCustomerSecretKeyRequest, Void> {
        private String userId;
        private String customerSecretKeyId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCustomerSecretKeyRequest o) {
            this.userId(o.getUserId());
            this.customerSecretKeyId(o.getCustomerSecretKeyId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCustomerSecretKeyRequest build() {
            DeleteCustomerSecretKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder customerSecretKeyId(String customerSecretKeyId) {
            this.customerSecretKeyId = customerSecretKeyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteCustomerSecretKeyRequest buildWithoutInvocationCallback() {
            return new DeleteCustomerSecretKeyRequest(this.userId, this.customerSecretKeyId, this.ifMatch);
        }

        public String toString() {
            return "DeleteCustomerSecretKeyRequest.Builder(userId=" + this.userId + ", customerSecretKeyId=" + this.customerSecretKeyId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

