/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.output;

import java.net.URL;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public final class OutputListeners {
    private OutputListeners() {
    }

    public static Runnable openFileAt(FileObject file, int line, int col) {
        return () -> {
            if (file != null) {
                try {
                    EditorCookie cookie;
                    DataObject data = DataObject.find((FileObject)file);
                    if (data != null && (cookie = (EditorCookie)data.getLookup().lookup(EditorCookie.class)) != null) {
                        try {
                            cookie.getLineSet().getOriginal(line - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, col - 1);
                        }
                        catch (IndexOutOfBoundsException ex) {
                            cookie.open();
                        }
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        };
    }

    public static Runnable openURL(URL url) {
        return () -> HtmlBrowser.URLDisplayer.getDefault().showURL(url);
    }

    public static Runnable displayStatusText(String text) {
        return () -> StatusDisplayer.getDefault().setStatusText(text);
    }
}

