/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

public class IndentationCounter {
    private static final Collection<PHPTokenId> CONTROL_STATEMENT_TOKENS = Arrays.asList(PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE);
    private Collection<ScopeDelimiter> scopeDelimiters;
    private final BaseDocument doc;
    private final int indentSize;
    private final int continuationSize;
    private final int itemsArrayDeclararionSize;

    public IndentationCounter(BaseDocument doc) {
        this.doc = doc;
        this.indentSize = CodeStyle.get((Document)doc).getIndentSize();
        this.continuationSize = CodeStyle.get((Document)doc).getContinuationIndentSize();
        this.itemsArrayDeclararionSize = CodeStyle.get((Document)doc).getItemsInArrayDeclarationIndentSize();
        int initialIndentSize = CodeStyle.get((Document)doc).getInitialIndent();
        this.scopeDelimiters = Arrays.asList(new ScopeDelimiter(PHPTokenId.PHP_SEMICOLON, 0), new ScopeDelimiter(PHPTokenId.PHP_OPENTAG, initialIndentSize), new ScopeDelimiter(PHPTokenId.PHP_CURLY_CLOSE, 0), new ScopeDelimiter(PHPTokenId.PHP_CURLY_OPEN, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_CASE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_IF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSEIF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_WHILE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DO, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOR, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOREACH, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DEFAULT, this.indentSize));
    }

    public Indentation count(int caretOffset) {
        Indentation result = Indentation.NONE;
        this.doc.readLock();
        try {
            result = this.countUnderReadLock(caretOffset);
        }
        finally {
            this.doc.readUnlock();
        }
        return result;
    }

    private Indentation countUnderReadLock(int caretOffset) {
        int newIndent = 0;
        try {
            boolean insideString = false;
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.doc, caretOffset);
            int caretLineStart = LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)(LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)caretOffset) - 1));
            if (ts != null) {
                ts.move(caretOffset);
                ts.moveNext();
                boolean indentStartComment = false;
                boolean movePrevious = false;
                if (ts.token() == null) {
                    return Indentation.NONE;
                }
                if (ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                    int neOffset = LineDocumentUtils.getPreviousNonWhitespace((LineDocument)this.doc, (int)(caretOffset - 1));
                    Indentation result = Indentation.NONE;
                    if (neOffset != -1) {
                        result = new IndentationImpl(Utilities.getRowIndent((BaseDocument)this.doc, (int)neOffset) + this.indentSize);
                    }
                    return result;
                }
                if (this.isAttributeCloseBracket(ts)) {
                    int attributeIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)caretLineStart);
                    return new IndentationImpl(attributeIndent < 0 ? 0 : attributeIndent);
                }
                if (ts.token().id() == PHPTokenId.WHITESPACE && ts.moveNext()) {
                    movePrevious = true;
                }
                if (ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                    newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)caretLineStart);
                    if (newIndent < 0) {
                        int caretStart = caretOffset - 1;
                        int caretLineEnd = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)(LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)caretOffset) - 1));
                        int curlyOffset = ts.offset() - 1;
                        newIndent = caretLineEnd == caretStart ? caretStart - caretLineStart : (caretLineEnd < curlyOffset ? caretLineEnd - 1 - caretLineStart : curlyOffset - caretLineStart);
                        if (newIndent < 0) {
                            newIndent = 0;
                        }
                    }
                    return new IndentationImpl(newIndent);
                }
                if (ts.token().id() == PHPTokenId.PHP_COMMENT || ts.token().id() == PHPTokenId.PHP_LINE_COMMENT || ts.token().id() == PHPTokenId.PHP_COMMENT_START || ts.token().id() == PHPTokenId.PHP_COMMENT_END) {
                    if (ts.token().id() == PHPTokenId.PHP_COMMENT_START && ts.offset() >= caretOffset) {
                        indentStartComment = true;
                    } else {
                        if (!movePrevious) {
                            return Indentation.NONE;
                        }
                        if (ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                            ts.movePrevious();
                            CharSequence whitespace = ts.token().text();
                            if (ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                int index;
                                for (index = 0; index < whitespace.length() && whitespace.charAt(index) != '\n'; ++index) {
                                }
                                if (index == whitespace.length()) {
                                    return Indentation.NONE;
                                }
                            }
                            ts.moveNext();
                            movePrevious = false;
                        }
                    }
                }
                if (movePrevious) {
                    ts.movePrevious();
                }
                if ((ts.token().id() == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE || ts.token().id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING) && caretOffset > ts.offset()) {
                    int stringLineStart = LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)ts.offset());
                    newIndent = stringLineStart >= caretLineStart ? Utilities.getRowIndent((BaseDocument)this.doc, (int)stringLineStart) + this.indentSize : Utilities.getRowIndent((BaseDocument)this.doc, (int)caretLineStart);
                    insideString = true;
                }
                int bracketBalance = 0;
                int squaredBalance = 0;
                PHPTokenId previousTokenId = (PHPTokenId)ts.token().id();
                while (!insideString && ts.movePrevious()) {
                    int startExpression;
                    Token token = ts.token();
                    ScopeDelimiter delimiter = this.getScopeDelimiter(token);
                    int anchor = ts.offset();
                    int shiftAtAncor = 0;
                    if (delimiter != null) {
                        if (delimiter.tokenId == PHPTokenId.PHP_SEMICOLON) {
                            int casePosition = this.breakProceededByCase(ts);
                            if (casePosition > -1) {
                                newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)anchor);
                                if (LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)casePosition) == caretLineStart) break;
                                newIndent -= this.indentSize;
                                break;
                            }
                            CodeB4BreakData codeB4BreakData = this.processCodeBeforeBreak(ts, indentStartComment);
                            anchor = codeB4BreakData.expressionStartOffset;
                            shiftAtAncor = codeB4BreakData.indentDelta;
                            if (codeB4BreakData.processedByControlStmt) {
                                newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)anchor) - this.indentSize;
                                break;
                            }
                            newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)anchor) + delimiter.indentDelta + shiftAtAncor;
                            break;
                        }
                        if (delimiter.tokenId == PHPTokenId.PHP_CURLY_OPEN && ts.movePrevious()) {
                            startExpression = this.isInMatchExpression(ts.offset(), ts) ? this.findMatchExpressionStart(ts) : LexUtilities.findStartTokenOfExpression(ts);
                            newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression) + this.indentSize;
                            break;
                        }
                        if (anchor < 0) break;
                        newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)anchor) + delimiter.indentDelta + shiftAtAncor;
                        break;
                    }
                    if (ts.token().id() == PHPTokenId.PHP_TOKEN || ts.token().id() == PHPTokenId.PHP_ATTRIBUTE || ts.token().id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)"=", (CharSequence)ts.token().text())) {
                        char ch = ts.token().text().charAt(0);
                        boolean continualIndent = false;
                        boolean indent = false;
                        switch (ch) {
                            case ')': {
                                ++bracketBalance;
                                break;
                            }
                            case '(': {
                                if (bracketBalance == 0) {
                                    continualIndent = true;
                                }
                                --bracketBalance;
                                break;
                            }
                            case ']': {
                                ++squaredBalance;
                                break;
                            }
                            case '[': {
                                if (squaredBalance == 0) {
                                    continualIndent = true;
                                }
                                --squaredBalance;
                                break;
                            }
                            case ',': {
                                continualIndent = true;
                                break;
                            }
                            case '.': {
                                continualIndent = true;
                                break;
                            }
                            case ':': {
                                if (IndentationCounter.isInTernaryOperatorStatement(ts)) {
                                    continualIndent = true;
                                    break;
                                }
                                indent = true;
                                break;
                            }
                            case '=': {
                                continualIndent = true;
                                break;
                            }
                        }
                        if (ts.token().id() == PHPTokenId.PHP_ATTRIBUTE) {
                            if (squaredBalance == 0) {
                                indent = true;
                            }
                            --squaredBalance;
                        }
                        if (continualIndent || indent) {
                            ts.move(caretOffset);
                            ts.movePrevious();
                            int startExpression2 = LexUtilities.findStartTokenOfExpression(ts);
                            if (startExpression2 == -1) break;
                            if (continualIndent) {
                                int offsetArrayDeclaration = IndentationCounter.offsetArrayDeclaration(startExpression2, ts);
                                newIndent = offsetArrayDeclaration > -1 ? Utilities.getRowIndent((BaseDocument)this.doc, (int)offsetArrayDeclaration) + this.itemsArrayDeclararionSize : (this.inGroupUse(startExpression2, ts) ? Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression2) : (this.isInMatchExpression(startExpression2, ts) && this.isFirstCommaAfterDoubleArrow(startExpression2, caretOffset, ts) ? Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression2) : (this.isInAttributeExpression(caretOffset, ts) ? Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression2) + this.indentSize : Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression2) + this.continuationSize)));
                            }
                            if (!indent) break;
                            newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression2) + this.indentSize;
                            break;
                        }
                    } else if ((previousTokenId == PHPTokenId.PHP_OBJECT_OPERATOR || previousTokenId == PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR || ts.token().id() == PHPTokenId.PHP_OBJECT_OPERATOR || ts.token().id() == PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR || ts.token().id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) && bracketBalance <= 0) {
                        startExpression = LexUtilities.findStartTokenOfExpression(ts);
                        if (startExpression != -1) {
                            int rememberOffset = ts.offset();
                            ts.move(startExpression);
                            ts.moveNext();
                            if (ts.token().id() != PHPTokenId.PHP_IF && ts.token().id() != PHPTokenId.PHP_WHILE && ts.token().id() != PHPTokenId.PHP_FOR && ts.token().id() != PHPTokenId.PHP_FOREACH) {
                                newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression) + this.continuationSize;
                                break;
                            }
                            ts.move(rememberOffset);
                            ts.moveNext();
                        }
                    } else if ((ts.token().id() == PHPTokenId.PHP_PUBLIC || ts.token().id() == PHPTokenId.PHP_PROTECTED || ts.token().id() == PHPTokenId.PHP_PRIVATE || ts.token().id() == PHPTokenId.PHP_VARIABLE && bracketBalance <= 0) && (startExpression = LexUtilities.findStartTokenOfExpression(ts)) != -1) {
                        newIndent = Utilities.getRowIndent((BaseDocument)this.doc, (int)startExpression) + this.continuationSize;
                        break;
                    }
                    previousTokenId = (PHPTokenId)ts.token().id();
                }
                if (newIndent < 0) {
                    newIndent = 0;
                }
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new IndentationImpl(newIndent);
    }

    private static boolean isInTernaryOperatorStatement(TokenSequence<? extends PHPTokenId> ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        ts.movePrevious();
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_TOKEN));
        if (previousToken != null && previousToken.id() == PHPTokenId.PHP_TOKEN && previousToken.text().charAt(0) == '?') {
            result = true;
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private CodeB4BreakData processCodeBeforeBreak(TokenSequence ts, boolean indentComment) {
        CodeB4BreakData retunValue = new CodeB4BreakData();
        int origOffset = ts.offset();
        Token token = ts.token();
        if (token.id() == PHPTokenId.PHP_SEMICOLON && ts.movePrevious()) {
            retunValue.expressionStartOffset = LexUtilities.findStartTokenOfExpression(ts);
            boolean hasColon = false;
            ts.move(retunValue.expressionStartOffset);
            ts.moveNext();
            if (ts.token().id() == PHPTokenId.PHP_CASE) {
                while (ts.moveNext() && ts.offset() < origOffset) {
                    TokenId id = ts.token().id();
                    if (!ts.token().id().equals((Object)PHPTokenId.PHP_TOKEN) || !TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)":")) continue;
                    hasColon = true;
                    break;
                }
                ts.move(retunValue.expressionStartOffset);
                ts.moveNext();
            }
            retunValue.indentDelta = ts.token().id() == PHPTokenId.PHP_CASE && hasColon || ts.token().id() == PHPTokenId.PHP_DEFAULT ? this.indentSize : 0;
            retunValue.processedByControlStmt = false;
            ts.move(origOffset);
            ts.moveNext();
            return retunValue;
        }
        while (ts.movePrevious()) {
            token = ts.token();
            ScopeDelimiter delimiter = this.getScopeDelimiter(token);
            if (delimiter != null) {
                retunValue.expressionStartOffset = ts.offset();
                retunValue.indentDelta = delimiter.indentDelta;
                if (!CONTROL_STATEMENT_TOKENS.contains((Object)delimiter.tokenId)) break;
                retunValue.indentDelta = 0;
                break;
            }
            if (!indentComment || token.id() != PHPTokenId.WHITESPACE || TokenUtilities.indexOf((CharSequence)token.text(), (int)10) == -1 || !ts.moveNext()) continue;
            retunValue.expressionStartOffset = ts.offset();
            retunValue.indentDelta = 0;
            break;
        }
        if (token.id() == PHPTokenId.PHP_OPENTAG && ts.moveNext()) {
            LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
            retunValue.expressionStartOffset = ts.offset();
            retunValue.indentDelta = 0;
        }
        ts.move(origOffset);
        ts.moveNext();
        return retunValue;
    }

    private static int offsetArrayDeclaration(int startExpression, TokenSequence ts) {
        Token token;
        int result = -1;
        int origOffset = ts.offset();
        int balance = 0;
        int squaredBalance = 0;
        do {
            if ((token = ts.token()).id() != PHPTokenId.PHP_TOKEN) continue;
            switch (token.text().charAt(0)) {
                case ')': {
                    --balance;
                    break;
                }
                case '(': {
                    ++balance;
                    break;
                }
                case ']': {
                    --squaredBalance;
                    break;
                }
                case '[': {
                    ++squaredBalance;
                    break;
                }
            }
        } while (!(ts.offset() <= startExpression || token.id() == PHPTokenId.PHP_ARRAY && balance == 1 || token.id() == PHPTokenId.PHP_TOKEN && squaredBalance == 1) && ts.movePrevious());
        if (token.id() == PHPTokenId.PHP_ARRAY && balance == 1 || token.id() == PHPTokenId.PHP_TOKEN && squaredBalance == 1) {
            result = ts.offset();
        }
        ts.move(origOffset);
        ts.moveNext();
        return result;
    }

    private boolean inGroupUse(int startExpression, TokenSequence ts) {
        boolean result = false;
        int origOffset = ts.offset();
        ts.move(startExpression);
        if (ts.moveNext() && ts.movePrevious()) {
            boolean openCurlyFound = false;
            boolean namespaceFound = false;
            do {
                TokenId tokenId;
                if ((tokenId = ts.token().id()) == PHPTokenId.PHP_USE) {
                    result = openCurlyFound && namespaceFound;
                    break;
                }
                if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                    if (!openCurlyFound) {
                        openCurlyFound = true;
                        continue;
                    }
                    break;
                }
                if (tokenId == PHPTokenId.PHP_NS_SEPARATOR) {
                    namespaceFound = true;
                    continue;
                }
                if (tokenId != PHPTokenId.WHITESPACE && tokenId != PHPTokenId.PHP_STRING && tokenId != PHPTokenId.PHP_CONST && tokenId != PHPTokenId.PHP_FUNCTION) break;
            } while (ts.movePrevious());
        }
        ts.move(origOffset);
        ts.moveNext();
        return result;
    }

    private boolean isInMatchExpression(int startExpression, TokenSequence ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        ts.move(startExpression);
        if (ts.moveNext() && ts.movePrevious()) {
            TokenId tokenId;
            while (ts.movePrevious() && (tokenId = ts.token().id()) != PHPTokenId.PHP_SEMICOLON) {
                if (tokenId != PHPTokenId.PHP_MATCH) continue;
                result = true;
                break;
            }
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private boolean isInAttributeExpression(int caretOffset, TokenSequence ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        ts.move(caretOffset);
        if (ts.moveNext() && ts.token().id() == PHPTokenId.PHP_ATTRIBUTE && ts.offset() + ts.token().length() <= caretOffset) {
            result = true;
        }
        int bracketBalance = 0;
        int parenBlance = 0;
        while (!result && ts.movePrevious()) {
            TokenId tokenId = ts.token().id();
            if (IndentationCounter.isCloseBracket(ts.token())) {
                --bracketBalance;
            } else if (IndentationCounter.isOpenBracket(ts.token())) {
                ++bracketBalance;
            } else if (IndentationCounter.isCloseParen(ts.token())) {
                --parenBlance;
            } else if (IndentationCounter.isOpenParen(ts.token())) {
                ++parenBlance;
            }
            if (tokenId == PHPTokenId.PHP_SEMICOLON || tokenId == PHPTokenId.PHP_CURLY_CLOSE) break;
            if (tokenId != PHPTokenId.PHP_ATTRIBUTE) continue;
            if (++bracketBalance == 0 || parenBlance != 0) break;
            result = true;
            break;
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private int findMatchExpressionStart(TokenSequence<? extends PHPTokenId> ts) {
        int originalOffset = ts.offset();
        Token<? extends PHPTokenId> matchToken = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_MATCH));
        assert (matchToken != null);
        int startExpression = ts.offset();
        ts.move(originalOffset);
        ts.moveNext();
        return startExpression;
    }

    private boolean isFirstCommaAfterDoubleArrow(int startExpression, int caretOffset, TokenSequence ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        ts.move(caretOffset);
        int parenBalance = 0;
        int bracketBalance = 0;
        int curlyBalance = 0;
        int commaCount = 0;
        if (ts.moveNext() && ts.movePrevious()) {
            TokenId tokenId;
            while (ts.offset() >= startExpression && (tokenId = ts.token().id()) != PHPTokenId.PHP_SEMICOLON) {
                if (tokenId == PHPTokenId.PHP_TOKEN) {
                    char c = ts.token().text().charAt(0);
                    switch (c) {
                        case '(': {
                            ++parenBalance;
                            break;
                        }
                        case ')': {
                            --parenBalance;
                            break;
                        }
                        case '[': {
                            ++bracketBalance;
                            break;
                        }
                        case ']': {
                            --bracketBalance;
                            break;
                        }
                        case ',': {
                            if (parenBalance != 0 || bracketBalance != 0 || curlyBalance != 0) break;
                            ++commaCount;
                            break;
                        }
                    }
                } else if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                    ++curlyBalance;
                } else if (tokenId == PHPTokenId.PHP_CURLY_CLOSE) {
                    --curlyBalance;
                } else if (IndentationCounter.isDoubleArrowOperator((Token<PHPTokenId>)ts.token())) {
                    result = parenBalance == 0 && bracketBalance == 0 && curlyBalance == 0 && commaCount == 1;
                    break;
                }
                if (ts.movePrevious()) continue;
                break;
            }
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private static boolean isDoubleArrowOperator(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)"=>", (CharSequence)token.text());
    }

    private int breakProceededByCase(TokenSequence<? extends PHPTokenId> ts) {
        int retunValue = -1;
        int origOffset = ts.offset();
        if (ts.movePrevious() && this.semicolonProceededByBreak(ts)) {
            while (ts.movePrevious()) {
                PHPTokenId tid = (PHPTokenId)ts.token().id();
                if (tid == PHPTokenId.PHP_CASE) {
                    retunValue = ts.offset();
                    break;
                }
                if (!CONTROL_STATEMENT_TOKENS.contains((Object)tid)) continue;
                break;
            }
        }
        ts.move(origOffset);
        ts.moveNext();
        return retunValue;
    }

    private boolean semicolonProceededByBreak(TokenSequence ts) {
        boolean retunValue = false;
        if (ts.token().id() == PHPTokenId.PHP_BREAK) {
            retunValue = true;
        } else if (ts.token().id() == PHPTokenId.PHP_NUMBER) {
            int origOffset = ts.offset();
            if (ts.movePrevious() && ts.token().id() == PHPTokenId.WHITESPACE && ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_BREAK) {
                retunValue = true;
            }
            ts.move(origOffset);
            ts.moveNext();
        }
        return retunValue;
    }

    private ScopeDelimiter getScopeDelimiter(Token token) {
        for (ScopeDelimiter scopeDelimiter : this.scopeDelimiters) {
            if (!scopeDelimiter.matches(token)) continue;
            return scopeDelimiter;
        }
        return null;
    }

    private boolean isAttributeCloseBracket(TokenSequence ts) {
        int originalOffset = ts.offset();
        boolean result = false;
        Token<? extends PHPTokenId> findPrevious = LexUtilities.findPrevious((TokenSequence<? extends PHPTokenId>)ts, Arrays.asList(PHPTokenId.WHITESPACE));
        if (findPrevious != null && IndentationCounter.isCloseBracket(findPrevious)) {
            int balance = -1;
            while (ts.movePrevious()) {
                if (IndentationCounter.isOpenBracket(ts.token())) {
                    ++balance;
                } else if (IndentationCounter.isCloseBracket(ts.token())) {
                    --balance;
                } else if (ts.token().id() == PHPTokenId.PHP_ATTRIBUTE) {
                    if (++balance != 0) break;
                    result = true;
                    break;
                }
                if (balance != 0) continue;
            }
        }
        if (result) {
            int lineStart = LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)(LineDocumentUtils.getLineStart((LineDocument)this.doc, (int)ts.offset()) - 1));
            while (ts.movePrevious() && ts.offset() >= lineStart) {
                if (ts.token().id() == PHPTokenId.WHITESPACE) continue;
                result = false;
                break;
            }
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private static boolean isOpenBracket(Token token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"[");
    }

    private static boolean isCloseBracket(Token token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"]");
    }

    private static boolean isOpenParen(Token token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(");
    }

    private static boolean isCloseParen(Token token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)")");
    }

    private static final class IndentationImpl
    implements Indentation {
        private final int indentation;

        public IndentationImpl(int indentation) {
            this.indentation = indentation;
        }

        @Override
        public int getIndentation() {
            return this.indentation;
        }

        @Override
        public void modify(final Context context) {
            assert (context != null);
            context.document().render(new Runnable(){

                @Override
                public void run() {
                    this.modifyUnderWriteLock(context);
                }
            });
        }

        private void modifyUnderWriteLock(Context context) {
            try {
                context.modifyIndent(LineDocumentUtils.getLineStart((LineDocument)((BaseDocument)context.document()), (int)context.caretOffset()), this.indentation);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static interface Indentation {
        public static final Indentation NONE = new Indentation(){

            @Override
            public int getIndentation() {
                return 0;
            }

            @Override
            public void modify(Context context) {
            }
        };

        public int getIndentation();

        public void modify(Context var1);
    }

    private static class ScopeDelimiter {
        private PHPTokenId tokenId;
        private String tokenContent;
        private int indentDelta;

        public ScopeDelimiter(PHPTokenId tokenId, int indentDelta) {
            this(tokenId, null, indentDelta);
        }

        public ScopeDelimiter(PHPTokenId tokenId, String tokenContent, int indentDelta) {
            this.tokenId = tokenId;
            this.tokenContent = tokenContent;
            this.indentDelta = indentDelta;
        }

        public boolean matches(Token token) {
            if (this.tokenId != token.id()) {
                return false;
            }
            return this.tokenContent == null || !TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)this.tokenContent);
        }
    }

    private static class CodeB4BreakData {
        int expressionStartOffset;
        boolean processedByControlStmt;
        int indentDelta;

        private CodeB4BreakData() {
        }
    }
}

