/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;

public class DBConnectionProvider
extends CodeActionsProvider {
    private static final String GET_DB_CONNECTION = "java.db.connection";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("java.db.connection"));

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (!GET_DB_CONNECTION.equals(command)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        if (conn != null) {
            result.put("DATASOURCES_DEFAULT_URL", conn.getDatabaseURL());
            result.put("DATASOURCES_DEFAULT_USERNAME", conn.getUser());
            result.put("DATASOURCES_DEFAULT_PASSWORD", conn.getPassword());
            result.put("DATASOURCES_DEFAULT_DRIVER_CLASS_NAME", conn.getDriverClass());
            String ocid = (String)conn.getConnectionProperties().get("OCID");
            if (ocid != null && !ocid.isEmpty()) {
                result.put("DATASOURCES_DEFAULT_OCID", ocid);
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public Set<String> getCommands() {
        return COMMANDS;
    }
}

