/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class ArtifactSpec<T> {
    public static final String TAG_BASE = "<basic>";
    public static final String TAG_SHADED = "<shaded>";
    public static final String CLASSIFIER_SOURCES = "sources";
    public static final String CLASSIFIER_TESTS = "tests";
    public static final String CLASSIFIER_TEST_SOURCES = "test-sources";
    static final Logger LOG = Logger.getLogger(ProjectDependencies.class.getName());
    private final VersionKind kind;
    private final String type;
    private final String groupId;
    private final String artifactId;
    private final String versionSpec;
    private final String classifier;
    private final boolean optional;
    private final URI location;
    private final Set<String> tags;
    private FileObject localFile;
    final T data;

    ArtifactSpec(VersionKind kind, String groupId, String artifactId, String versionSpec, String type, String classifier, boolean optional, URI location, FileObject localFile, Set<String> tags, T impl) {
        this.kind = kind;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.versionSpec = versionSpec;
        this.classifier = classifier;
        this.optional = optional;
        this.data = impl;
        this.type = type;
        this.location = location;
        this.localFile = localFile;
        this.tags = tags == null ? Collections.emptySet() : tags;
    }

    public T getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getLocalFile() {
        FileObject f = this.localFile;
        if (f == null && this.location != null) {
            try {
                ArtifactSpec artifactSpec = this;
                synchronized (artifactSpec) {
                    this.localFile = URLMapper.findFileObject((URL)this.location.toURL());
                    return this.localFile;
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, "Artifact location cannot be converted to URL: {0}", this.location);
                f = this.localFile = FileUtil.getConfigRoot();
            }
        }
        return f == FileUtil.getConfigRoot() ? null : f;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public URI getLocation() {
        return this.location;
    }

    public VersionKind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionSpec() {
        return this.versionSpec;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode((Object)this.kind);
        hash = 79 * hash + Objects.hashCode(this.type);
        hash = 79 * hash + Objects.hashCode(this.groupId);
        hash = 79 * hash + Objects.hashCode(this.artifactId);
        hash = 79 * hash + Objects.hashCode(this.versionSpec);
        hash = 79 * hash + Objects.hashCode(this.classifier);
        hash = 79 * hash + Objects.hashCode(this.location);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactSpec other = (ArtifactSpec)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.versionSpec, other.versionSpec)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        return this.kind == other.kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getVersionSpec() == null ? "" : this.getVersionSpec()));
        if (this.classifier != null) {
            sb.append(":").append(this.classifier);
        }
        if (this.type != null) {
            sb.append("[").append(this.type).append("]");
        }
        if (this.optional) {
            sb.append("?");
        }
        return sb.toString();
    }

    public T getProjectData() {
        return this.data;
    }

    public static <V> ArtifactSpec<V> createVersionSpec(@NullAllowed String groupId, @NonNull String artifactId, @NullAllowed String type, @NullAllowed String classifier, @NullAllowed String versionSpec, boolean optional, @NullAllowed FileObject localFile, @NonNull V data) {
        URL u = localFile == null ? null : URLMapper.findURL((FileObject)localFile, (int)1);
        URI uri = null;
        if (u != null) {
            try {
                uri = u.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return new ArtifactSpec<V>(VersionKind.REGULAR, groupId, artifactId, versionSpec, type, classifier, optional, uri, localFile, Collections.emptySet(), data);
    }

    public static <V> ArtifactSpec<V> createSnapshotSpec(@NullAllowed String groupId, @NullAllowed String artifactId, @NullAllowed String type, @NullAllowed String classifier, @NullAllowed String versionSpec, boolean optional, @NullAllowed FileObject localFile, @NonNull V data) {
        URL u;
        URI uri = null;
        if (localFile != null && (u = URLMapper.findURL((FileObject)localFile, (int)1)) != null) {
            try {
                uri = u.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return new ArtifactSpec<V>(VersionKind.SNAPSHOT, groupId, artifactId, versionSpec, type, classifier, optional, uri, localFile, Collections.emptySet(), data);
    }

    public static final <T> Builder<T> builder(String group, String artifact, String version, T projectData) {
        return new Builder<T>(group, artifact, version, projectData);
    }

    public static final class Builder<T> {
        private final T data;
        private final String groupId;
        private final String artifactId;
        private final String versionSpec;
        private VersionKind kind = VersionKind.REGULAR;
        private String type;
        private String classifier;
        private boolean optional;
        private FileObject localFile;
        private URI location;
        private Set<String> tags;

        public Builder(String groupId, String artifactId, String versionSpec, T data) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.versionSpec = versionSpec;
            this.data = data;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder localFile(FileObject localFile) {
            this.localFile = localFile;
            return this;
        }

        public Builder tag(String tag) {
            if (this.tags == null) {
                this.tags = new HashSet<String>();
            }
            this.tags.add(tag);
            return this;
        }

        public Builder tags(String ... tags) {
            if (tags == null || tags.length == 0) {
                return this;
            }
            for (String t : tags) {
                this.tag(t);
            }
            return this;
        }

        public Builder forceLocalFile(FileObject localFile) {
            this.localFile = localFile == null ? FileUtil.getConfigRoot() : localFile;
            return this;
        }

        public Builder location(URI location) {
            this.location = location;
            return this;
        }

        public ArtifactSpec build() {
            return new ArtifactSpec<T>(this.kind, this.groupId, this.artifactId, this.versionSpec, this.type, this.classifier, this.optional, this.location, this.localFile, this.tags, this.data);
        }
    }

    public static enum VersionKind {
        REGULAR,
        SNAPSHOT;

    }
}

