/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;
import org.openide.awt.Mnemonics;

public class PropertyPicker
extends JPanel {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    static final long serialVersionUID = 5689122601606238081L;
    private JLabel componentLabel;
    private JComboBox componentsCombo;
    private JLabel listLabel;
    private JScrollPane propertiesScrollPane;
    private JList propertyList;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class<?> requiredType;
    private PropertyPickerItem[] items;
    private RADComponent selectedComponent;
    private static Class[] NO_PARAMETERS = new Class[0];

    public PropertyPicker(FormModel formModel, RADComponent componentToSelect, Class requiredType) {
        this.requiredType = requiredType;
        this.initComponents();
        List<RADComponent> componentsList = formModel.getComponentList();
        Collections.sort(componentsList, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[componentsList.size()];
        componentsList.toArray(this.components);
        int selIndex = -1;
        for (RADComponent radComp : componentsList) {
            if (componentToSelect != null && componentToSelect == radComp) {
                selIndex = this.componentsCombo.getItemCount();
            }
            if (radComp == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(radComp.getName());
        }
        if (selIndex >= 0) {
            this.componentsCombo.setSelectedIndex(selIndex);
        }
        this.propertyList.setSelectionMode(0);
        this.updatePropertyList();
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)FormUtils.getBundleString("CTL_CW_Component"));
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)FormUtils.getBundleString("CTL_CW_PropertyList"));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.propertyList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_PropertyPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean v) {
        boolean old = this.pickerValid;
        this.pickerValid = v;
        this.firePropertyChange("pickerValid", old, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent selectedComponent) {
        if (selectedComponent != null) {
            this.componentsCombo.setSelectedItem(selectedComponent.getName());
        }
    }

    PropertyPickerItem getSelectedProperty() {
        if (this.selectedComponent == null || this.propertyList.getSelectedIndex() == -1) {
            return null;
        }
        return this.items[this.propertyList.getSelectedIndex()];
    }

    void setSelectedProperty(PropertyDescriptor selectedProperty) {
        if (selectedProperty == null) {
            this.propertyList.setSelectedIndex(-1);
        } else {
            this.propertyList.setSelectedValue(selectedProperty.getName(), true);
        }
    }

    private void updatePropertyList() {
        RADComponent sel = this.getSelectedComponent();
        if (sel == null) {
            this.propertyList.setListData(new Object[0]);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        } else {
            PropertyDescriptor[] descs = sel.getBeanInfo().getPropertyDescriptors();
            HashMap<String, PropertyPickerItem> filtered = new HashMap<String, PropertyPickerItem>();
            for (int i = 0; i < descs.length; ++i) {
                if (descs[i].getReadMethod() == null || descs[i].getPropertyType() == null || !this.requiredType.isAssignableFrom(descs[i].getPropertyType())) continue;
                PropertyPickerItem item = this.createItem(descs[i]);
                filtered.put(item.getPropertyName(), item);
            }
            if (sel == sel.getFormModel().getTopRADComponent()) {
                String[] names = FormEditor.getFormJavaSource(sel.getFormModel()).getPropertyReadMethodNames(this.requiredType);
                for (int i = 0; i < names.length; ++i) {
                    PropertyPickerItem item = this.createItem(names[i]);
                    if (filtered.containsKey(item.getPropertyName())) continue;
                    filtered.put(item.getPropertyName(), item);
                }
            }
            this.items = new PropertyPickerItem[filtered.size()];
            filtered.values().toArray(this.items);
            Arrays.sort(this.items, new Comparator<PropertyPickerItem>(){

                @Override
                public int compare(PropertyPickerItem o1, PropertyPickerItem o2) {
                    return o1.getPropertyName().compareTo(o2.getPropertyName());
                }
            });
            String[] listItems = new String[this.items.length];
            for (int i = 0; i < listItems.length; ++i) {
                listItems[i] = this.items[i].getPropertyName();
            }
            this.propertyList.setListData(listItems);
            this.propertyList.revalidate();
            this.propertyList.repaint();
        }
    }

    private PropertyPickerItem createItem(final PropertyDescriptor desc) {
        return new PropertyPickerItem(){

            @Override
            public String getPropertyName() {
                return desc.getName();
            }

            @Override
            public String getReadMethodName() {
                return desc.getReadMethod().getName();
            }

            @Override
            public PropertyDescriptor getPropertyDescriptor() {
                return desc;
            }
        };
    }

    private PropertyPickerItem createItem(final String name) {
        return new PropertyPickerItem(){

            @Override
            public String getPropertyName() {
                return FormJavaSource.extractPropertyName(name);
            }

            @Override
            public String getReadMethodName() {
                return FormUtils.getMethodName(name, NO_PARAMETERS);
            }

            @Override
            public PropertyDescriptor getPropertyDescriptor() {
                return null;
            }
        };
    }

    private void updateState() {
        this.setPickerValid(this.getSelectedComponent() != null && this.getSelectedProperty() != null);
    }

    private void initComponents() {
        this.componentsCombo = new JComboBox();
        this.propertiesScrollPane = new JScrollPane();
        this.propertyList = new JList();
        this.componentLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.componentsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PropertyPicker.this.componentsComboItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 128;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.propertyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PropertyPicker.this.propertyListValueChanged(evt);
            }
        });
        this.propertiesScrollPane.setViewportView(this.propertyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText("Component:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.propertyList);
        this.listLabel.setText("Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void propertyListValueChanged(ListSelectionEvent evt) {
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent evt) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updatePropertyList();
    }

    static interface PropertyPickerItem {
        public String getPropertyName();

        public String getReadMethodName();

        public PropertyDescriptor getPropertyDescriptor();
    }
}

