/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.debugger.ui.WatchesReader;
import org.openide.filesystems.FileObject;

public final class EditorPin
implements Watch.Pin {
    public static final String PROP_LINE = "line";
    public static final String PROP_LOCATION = "location";
    public static final String PROP_COMMENT = "comment";
    private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);
    private final FileObject file;
    private volatile int line;
    private volatile Point location;
    private volatile String comment;
    private String vpId;

    public EditorPin(FileObject file, int line, Point location) {
        this.file = file;
        this.line = line;
        this.location = location;
    }

    public int getLine() {
        return this.line;
    }

    public FileObject getFile() {
        return this.file;
    }

    public Point getLocation() {
        return this.location;
    }

    public void move(int line, Point location) {
        int oldLine = this.line;
        this.line = line;
        if (oldLine != line) {
            this.pchs.firePropertyChange(PROP_LINE, oldLine, line);
        }
        Point oldLocation = this.location;
        this.location = location;
        if (!oldLocation.equals(location)) {
            this.pchs.firePropertyChange(PROP_LOCATION, oldLocation, location);
        }
    }

    public void setComment(String comment) {
        String oldComment = this.comment;
        this.comment = comment;
        if (!Objects.equals(oldComment, comment)) {
            this.pchs.firePropertyChange(PROP_COMMENT, oldComment, comment);
        }
    }

    public String getComment() {
        return this.comment;
    }

    void setVpId(String vpId) {
        this.vpId = vpId;
        this.pchs.firePropertyChange("valueProviderId", null, vpId);
    }

    String getVpId() {
        return this.vpId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.removePropertyChangeListener(listener);
    }

    static {
        WatchesReader.PIN_READER_ACCESS = new WatchesReader.PinReaderAccess(){

            @Override
            public String getVpId(EditorPin pin) {
                return pin.getVpId();
            }

            @Override
            public void setVpId(EditorPin pin, String vpId) {
                pin.setVpId(vpId);
            }
        };
    }
}

