/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EntityClassesPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Set<String> availableEntities = new HashSet<String>();
    private final Set<String> selectedEntities = new HashSet<String>();
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableEntitiesLabel;
    private JList<String> availableEntitiesList;
    private JScrollPane availableEntitiesScrollPane;
    private JPanel buttonPanel;
    private JPanel entitiesPanel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectedEntitiesLabel;
    private JList<String> selectedEntitiesList;
    private JScrollPane selectedEntitiesScrollPane;

    public EntityClassesPanel() {
        this.initComponents();
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntityClassesPanel.this.updateButtons();
            }
        };
        this.availableEntitiesList.getSelectionModel().addListSelectionListener(selectionListener);
        this.selectedEntitiesList.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void initialize(Set<String> entities) {
        this.availableEntities.addAll(entities);
        this.availableEntitiesList.setListData((String[])this.availableEntities.toArray(new String[this.availableEntities.size()]));
        this.selectedEntitiesList.setListData((String[])this.selectedEntities.toArray(new String[this.selectedEntities.size()]));
        this.updateButtons();
    }

    public Set<String> getSelectedEntities() {
        return this.selectedEntities;
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.availableEntitiesList.getSelectedIndices().length > 0);
        this.addAllButton.setEnabled(!this.availableEntities.isEmpty());
        this.removeButton.setEnabled(this.selectedEntitiesList.getSelectedIndices().length > 0);
        this.removeAllButton.setEnabled(!this.selectedEntities.isEmpty());
    }

    private void initComponents() {
        this.entitiesPanel = new EntitiesPanel();
        this.availableEntitiesLabel = new JLabel();
        this.availableEntitiesScrollPane = new JScrollPane();
        this.availableEntitiesList = new JList();
        this.selectedEntitiesLabel = new JLabel();
        this.selectedEntitiesScrollPane = new JScrollPane();
        this.selectedEntitiesList = new JList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.setMinimumSize(new Dimension(200, 300));
        this.setName(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_EntityClasses"));
        this.setPreferredSize(new Dimension(496, 350));
        this.setLayout(new GridBagLayout());
        this.entitiesPanel.setPreferredSize(new Dimension(440, 174));
        this.entitiesPanel.setLayout(new GridBagLayout());
        this.availableEntitiesLabel.setLabelFor(this.availableEntitiesList);
        Mnemonics.setLocalizedText((JLabel)this.availableEntitiesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_AvailableEntities"));
        this.availableEntitiesLabel.setToolTipText(NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_AvailableEntities"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.entitiesPanel.add((Component)this.availableEntitiesLabel, gridBagConstraints);
        this.availableEntitiesScrollPane.setPreferredSize(new Dimension(160, 130));
        this.availableEntitiesList.setNextFocusableComponent(this.addButton);
        this.availableEntitiesScrollPane.setViewportView(this.availableEntitiesList);
        this.availableEntitiesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityClassesPanel.class, (String)"ACSN_AvailableEntities"));
        this.availableEntitiesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityClassesPanel.class, (String)"ACSD_AvailableEntities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.entitiesPanel.add((Component)this.availableEntitiesScrollPane, gridBagConstraints);
        this.selectedEntitiesLabel.setLabelFor(this.selectedEntitiesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedEntitiesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SelectedEntities"));
        this.selectedEntitiesLabel.setToolTipText(NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_SelectedEntities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.entitiesPanel.add((Component)this.selectedEntitiesLabel, gridBagConstraints);
        this.selectedEntitiesScrollPane.setPreferredSize(new Dimension(160, 130));
        this.selectedEntitiesScrollPane.setViewportView(this.selectedEntitiesList);
        this.selectedEntitiesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityClassesPanel.class, (String)"ACSN_SelectedEntities"));
        this.selectedEntitiesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityClassesPanel.class, (String)"ACSD_SelectedEntities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.entitiesPanel.add((Component)this.selectedEntitiesScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_AddAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_RemoveAll"));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.entitiesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.entitiesPanel, gridBagConstraints);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.availableEntities.addAll(this.selectedEntities);
        this.selectedEntities.clear();
        this.availableEntitiesList.setListData((String[])this.availableEntities.toArray(new String[this.availableEntities.size()]));
        this.selectedEntitiesList.setListData((String[])this.selectedEntities.toArray(new String[this.selectedEntities.size()]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        this.selectedEntities.addAll(this.availableEntities);
        this.availableEntities.clear();
        this.availableEntitiesList.setListData((String[])this.availableEntities.toArray(new String[this.availableEntities.size()]));
        this.selectedEntitiesList.setListData((String[])this.selectedEntities.toArray(new String[this.selectedEntities.size()]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.availableEntities.addAll(this.selectedEntitiesList.getSelectedValuesList());
        this.selectedEntities.removeAll(this.selectedEntitiesList.getSelectedValuesList());
        this.availableEntitiesList.setListData((String[])this.availableEntities.toArray(new String[this.availableEntities.size()]));
        this.selectedEntitiesList.setListData((String[])this.selectedEntities.toArray(new String[this.selectedEntities.size()]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.selectedEntities.addAll(this.availableEntitiesList.getSelectedValuesList());
        this.availableEntities.removeAll(this.availableEntitiesList.getSelectedValuesList());
        this.availableEntitiesList.setListData((String[])this.availableEntities.toArray(new String[this.availableEntities.size()]));
        this.selectedEntitiesList.setListData((String[])this.selectedEntities.toArray(new String[this.selectedEntities.size()]));
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final String title;
        private EntityClassesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Map<String, String> entities;

        public WizardPanel(String wizardTitle) {
            this.title = wizardTitle;
        }

        public EntityClassesPanel getComponent() {
            if (this.component == null) {
                this.component = new EntityClassesPanel();
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(EntityClassesPanel.class);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void readSettings(WizardDescriptor settings) {
            this.wizardDescriptor = settings;
            if (this.title != null) {
                this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
            }
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.entities = (Map)settings.getProperty("wizard-entities");
                this.getComponent().initialize(this.entities.keySet());
            }
        }

        public boolean isValid() {
            if (this.entities.isEmpty()) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoEntities", (Object)ProjectUtils.getInformation((Project)Templates.getProject((WizardDescriptor)this.wizardDescriptor)).getDisplayName()));
                return false;
            }
            if (this.getComponent().getSelectedEntities().isEmpty()) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_SelectEntities"));
                return false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public void storeSettings(WizardDescriptor settings) {
            Set<String> selected = this.getComponent().getSelectedEntities();
            Map<String, String> selEntities = this.entities.entrySet().stream().filter(entry -> selected.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
            this.wizardDescriptor.putProperty("wizard-selected-entities", selEntities);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }
    }

    private final class EntitiesPanel
    extends JPanel {
        private EntitiesPanel() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Rectangle availableBounds = EntityClassesPanel.this.availableEntitiesScrollPane.getBounds();
            Rectangle selectedBounds = EntityClassesPanel.this.selectedEntitiesScrollPane.getBounds();
            if (Math.abs(availableBounds.width - selectedBounds.width) > 1) {
                GridBagConstraints buttonPanelConstraints = ((GridBagLayout)this.getLayout()).getConstraints(EntityClassesPanel.this.buttonPanel);
                int totalWidth = this.getWidth() - EntityClassesPanel.this.buttonPanel.getWidth() - buttonPanelConstraints.insets.left - buttonPanelConstraints.insets.right;
                int equalWidth = totalWidth / 2;
                int xOffset = equalWidth - availableBounds.width;
                availableBounds.width = equalWidth;
                EntityClassesPanel.this.availableEntitiesScrollPane.setBounds(availableBounds);
                Rectangle buttonBounds = EntityClassesPanel.this.buttonPanel.getBounds();
                buttonBounds.x += xOffset;
                EntityClassesPanel.this.buttonPanel.setBounds(buttonBounds);
                Rectangle labelBounds = EntityClassesPanel.this.selectedEntitiesLabel.getBounds();
                labelBounds.x += xOffset;
                EntityClassesPanel.this.selectedEntitiesLabel.setBounds(labelBounds);
                selectedBounds.x += xOffset;
                selectedBounds.width = totalWidth - equalWidth;
                EntityClassesPanel.this.selectedEntitiesScrollPane.setBounds(selectedBounds);
            }
        }
    }
}

