/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.errors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.preview.PreviewEnabler;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class EnablePreviewMavenProj
implements PreviewEnabler {
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private final Project prj;
    private static final Logger LOG = Logger.getLogger(EnablePreviewMavenProj.class.getName());

    private EnablePreviewMavenProj(@NonNull Project prj) {
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        this.prj = prj;
    }

    public void enablePreview(String newSourceLevel) throws Exception {
        ActionConfig[] actions;
        FileObject pom = this.prj.getProjectDirectory().getFileObject("pom.xml");
        pom.getFileSystem().runAtomicAction(() -> {
            ArrayList<AddMvnCompilerPluginForEnablePreview> operations = new ArrayList<AddMvnCompilerPluginForEnablePreview>();
            operations.add(new AddMvnCompilerPluginForEnablePreview(newSourceLevel));
            Utilities.performPOMModelOperations((FileObject)pom, operations);
        });
        ProjectConfiguration cfg = ((ProjectConfigurationProvider)this.prj.getLookup().lookup(ProjectConfigurationProvider.class)).getActiveConfiguration();
        for (ActionConfig action : actions = new ActionConfig[]{ActionConfig.runAction("run"), ActionConfig.runAction("debug"), ActionConfig.runAction("profile"), ActionConfig.runAction("run.single.main"), ActionConfig.runAction("debug.single.main"), ActionConfig.runAction("profile.single.main"), ActionConfig.testAction("test"), ActionConfig.testAction("test.single"), ActionConfig.testAction("debug.test.single"), ActionConfig.testAction("profile.test.single")}) {
            NetbeansActionMapping mapp = ModelHandle2.getMapping((String)action.actionName, (Project)this.prj, (ProjectConfiguration)cfg);
            Map properties = mapp.getProperties();
            String existingValue = properties.getOrDefault(action.propertyName, "");
            if (existingValue.contains(ENABLE_PREVIEW_FLAG)) continue;
            properties.put(action.propertyName, ENABLE_PREVIEW_FLAG + (existingValue.isEmpty() ? "" : " ") + existingValue);
            ModelHandle2.putMapping((NetbeansActionMapping)mapp, (Project)this.prj, (ProjectConfiguration)cfg);
        }
    }

    public boolean canChangeSourceLevel() {
        CheckCanChangeSourceLevel canChange = new CheckCanChangeSourceLevel();
        try {
            FileObject pom = this.prj.getProjectDirectory().getFileObject("pom.xml");
            pom.getFileSystem().runAtomicAction(() -> {
                List<CheckCanChangeSourceLevel> operations = Collections.singletonList(canChange);
                Utilities.performPOMModelOperations((FileObject)pom, operations);
            });
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return canChange.canChangeSourceLevel;
    }

    public static class FactoryImpl
    implements PreviewEnabler.Factory {
        public PreviewEnabler enablerFor(FileObject file) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (this.isMavenProject(prj)) {
                return new EnablePreviewMavenProj(prj);
            }
            return null;
        }

        private boolean isMavenProject(Project prj) {
            if (prj == null) {
                return false;
            }
            FileObject prjDir = prj.getProjectDirectory();
            if (prjDir == null) {
                return false;
            }
            FileObject pom = prjDir.getFileObject("pom.xml");
            return pom != null && pom.isValid();
        }
    }

    private static class CheckCanChangeSourceLevel
    extends BaseMvnCompilerPluginForEnablePreview
    implements ModelOperation<POMModel> {
        private boolean canChangeSourceLevel;

        private CheckCanChangeSourceLevel() {
        }

        public void performOperation(POMModel model) {
            Configuration configuration;
            Build build = model.getProject().getBuild();
            Plugin plugin = build != null ? (Plugin)this.searchMavenCompilerPlugin(build).second() : null;
            Configuration configuration2 = configuration = plugin != null ? plugin.getConfiguration() : null;
            if (configuration != null) {
                POMExtensibilityElement releaseConfig = this.findElement(configuration, "release");
                POMExtensibilityElement sourceConfig = this.findElement(configuration, "source");
                POMExtensibilityElement targetConfig = this.findElement(configuration, "target");
                try {
                    if (releaseConfig != null) {
                        new SpecificationVersion(releaseConfig.getElementText().trim());
                    } else if (sourceConfig != null) {
                        new SpecificationVersion(sourceConfig.getElementText().trim());
                        new SpecificationVersion(targetConfig.getElementText().trim());
                    }
                    this.canChangeSourceLevel = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.canChangeSourceLevel = true;
            }
        }
    }

    private static class AddMvnCompilerPluginForEnablePreview
    extends BaseMvnCompilerPluginForEnablePreview
    implements ModelOperation<POMModel> {
        private final String newSourceLevel;
        private POMComponentFactory factory;

        public AddMvnCompilerPluginForEnablePreview(String newSourceLevel) {
            this.newSourceLevel = newSourceLevel;
        }

        public void performOperation(POMModel model) {
            Pair<PluginContainer, Plugin> containerAndPlugin;
            this.factory = model.getFactory();
            org.netbeans.modules.maven.model.pom.Project proj = model.getProject();
            Build build = model.getProject().getBuild();
            if (build == null) {
                build = this.factory.createBuild();
                proj.setBuild(build);
            }
            if ((containerAndPlugin = this.searchMavenCompilerPlugin(build)) == null) {
                build.addPlugin(this.createMavenCompilerPlugin());
            } else {
                PluginContainer container = (PluginContainer)containerAndPlugin.first();
                Plugin oldPlugin = (Plugin)containerAndPlugin.second();
                Plugin newPlugin = this.updateMavenCompilerPlugin(oldPlugin);
                container.removePlugin(oldPlugin);
                container.addPlugin(newPlugin);
            }
        }

        private Plugin createMavenCompilerPlugin() {
            Plugin plugin = this.factory.createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion("3.11.0");
            plugin.setConfiguration(this.updateMavenCompilerPluginConfiguration(this.createConfiguration(), "3.11.0"));
            return plugin;
        }

        private Configuration createConfiguration() {
            Configuration configuration = this.factory.createConfiguration();
            return configuration;
        }

        private Plugin updateMavenCompilerPlugin(Plugin oldPlugin) {
            Configuration currenConfig = oldPlugin.getConfiguration();
            Plugin newPlugin = this.factory.createPlugin();
            newPlugin.setGroupId(oldPlugin.getGroupId());
            newPlugin.setArtifactId(oldPlugin.getArtifactId());
            newPlugin.setVersion(oldPlugin.getVersion());
            newPlugin.setConfiguration(this.updateMavenCompilerPluginConfiguration(currenConfig, oldPlugin.getVersion()));
            return newPlugin;
        }

        private Configuration updateMavenCompilerPluginConfiguration(Configuration currenConfig, String version) {
            POMExtensibilityElement compilerArgsConfig;
            Configuration newConfiguration = this.createConfiguration();
            if (currenConfig == null) {
                currenConfig = this.createConfiguration();
            }
            boolean supportsRelease = version == null || new ComparableVersion(version).compareTo(new ComparableVersion("3.6")) >= 0;
            HashMap<Object, POMExtensibilityElement> old2New = new HashMap<Object, POMExtensibilityElement>();
            if (this.newSourceLevel != null) {
                POMExtensibilityElement releaseConfig = this.findElement(currenConfig, "release");
                POMExtensibilityElement sourceConfig = this.findElement(currenConfig, "source");
                POMExtensibilityElement targetConfig = this.findElement(currenConfig, "target");
                Properties properties = currenConfig.getModel().getProject().getProperties();
                if (releaseConfig != null && supportsRelease) {
                    try {
                        new SpecificationVersion(releaseConfig.getElementText().trim());
                        POMExtensibilityElement newReleaseElement = this.factory.createPOMExtensibilityElement(releaseConfig.getQName());
                        newReleaseElement.setElementText(this.newSourceLevel);
                        old2New.put(releaseConfig, newReleaseElement);
                    }
                    catch (NumberFormatException newReleaseElement) {}
                } else if (sourceConfig != null) {
                    try {
                        new SpecificationVersion(sourceConfig.getElementText().trim());
                        new SpecificationVersion(targetConfig.getElementText().trim());
                        POMExtensibilityElement newSourceElement = this.factory.createPOMExtensibilityElement(sourceConfig.getQName());
                        newSourceElement.setElementText(this.newSourceLevel);
                        old2New.put(sourceConfig, newSourceElement);
                        POMExtensibilityElement newTargetElement = this.factory.createPOMExtensibilityElement(targetConfig.getQName());
                        newTargetElement.setElementText(this.newSourceLevel);
                        old2New.put(targetConfig, newTargetElement);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (properties != null && properties.getProperty("maven.compiler.release") != null && supportsRelease) {
                    properties.setProperty("maven.compiler.release", this.newSourceLevel);
                } else if (properties != null && properties.getProperty("maven.compiler.source") != null) {
                    properties.setProperty("maven.compiler.source", this.newSourceLevel);
                    properties.setProperty("maven.compiler.target", this.newSourceLevel);
                } else {
                    if (properties == null) {
                        properties = this.factory.createProperties();
                        currenConfig.getModel().getProject().setProperties(properties);
                    }
                    if (supportsRelease) {
                        properties.setProperty("maven.compiler.release", this.newSourceLevel);
                    } else {
                        properties.setProperty("maven.compiler.source", this.newSourceLevel);
                        properties.setProperty("maven.compiler.target", this.newSourceLevel);
                    }
                }
            }
            if ((compilerArgsConfig = this.findElement(currenConfig, "compilerArgs")) != null) {
                POMExtensibilityElement newElement = this.factory.createPOMExtensibilityElement(POMQName.createQName((String)"compilerArgs"));
                for (POMExtensibilityElement nested : compilerArgsConfig.getAnyElements()) {
                    newElement.addExtensibilityElement((POMExtensibilityElement)nested.copy((Component)newElement));
                }
                newElement.setChildElementText("compilerId", EnablePreviewMavenProj.ENABLE_PREVIEW_FLAG, POMQName.createQName((String)"arg"));
                old2New.put(compilerArgsConfig, newElement);
            }
            for (POMExtensibilityElement element : currenConfig.getConfigurationElements()) {
                POMExtensibilityElement replacement = (POMExtensibilityElement)old2New.get(element);
                if (replacement == null) {
                    replacement = (POMExtensibilityElement)element.copy((Component)newConfiguration);
                }
                newConfiguration.addExtensibilityElement(replacement);
            }
            if (compilerArgsConfig == null) {
                POMExtensibilityElement compilerArgs = this.factory.createPOMExtensibilityElement(POMQName.createQName((String)"compilerArgs"));
                compilerArgs.setChildElementText("compilerId", EnablePreviewMavenProj.ENABLE_PREVIEW_FLAG, POMQName.createQName((String)"arg"));
                newConfiguration.addExtensibilityElement(compilerArgs);
            }
            return newConfiguration;
        }
    }

    private static class BaseMvnCompilerPluginForEnablePreview {
        protected static final String MAVEN_COMPILER_GROUP_ID = "org.apache.maven.plugins";
        protected static final String MAVEN_COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
        protected static final String COMPILER_ID_PROPERTY = "compilerId";
        protected static final String RELEASE = "release";
        protected static final String RELEASE_PROPERTY = "maven.compiler.release";
        protected static final String SOURCE = "source";
        protected static final String SOURCE_PROPERTY = "maven.compiler.source";
        protected static final String TARGET = "target";
        protected static final String TARGET_PROPERTY = "maven.compiler.target";
        protected static final String COMPILER_ARG = "compilerArgs";
        protected static final String MAVEN_COMPILER_VERSION = "3.11.0";
        protected static final String ARG = "arg";

        private BaseMvnCompilerPluginForEnablePreview() {
        }

        protected Pair<PluginContainer, Plugin> searchMavenCompilerPlugin(Build build) {
            for (PluginContainer container : new PluginContainer[]{build.getPluginManagement(), build}) {
                List plugins;
                if (container == null || (plugins = container.getPlugins()) == null) continue;
                for (Plugin plugin : plugins) {
                    if (plugin.getGroupId() != null && !MAVEN_COMPILER_GROUP_ID.equals(plugin.getGroupId()) || !MAVEN_COMPILER_ARTIFACT_ID.equals(plugin.getArtifactId())) continue;
                    return Pair.of((Object)container, (Object)plugin);
                }
            }
            return null;
        }

        protected POMExtensibilityElement findElement(Configuration configuration, String requiredName) {
            for (POMExtensibilityElement element : configuration.getConfigurationElements()) {
                if (!element.getQName().getLocalPart().equals(requiredName)) continue;
                return element;
            }
            return null;
        }
    }

    private static final class ActionConfig {
        public final String actionName;
        public final String propertyName;

        public ActionConfig(String actionName, String propertyName) {
            this.actionName = actionName;
            this.propertyName = propertyName;
        }

        public static ActionConfig runAction(String actionName) {
            return new ActionConfig(actionName, "exec.args");
        }

        public static ActionConfig testAction(String actionName) {
            return new ActionConfig(actionName, "argLine");
        }
    }
}

