/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DisasterRecoveryConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="disasterRecoveryType")
    private final DisasterRecoveryType disasterRecoveryType;

    @Deprecated
    @ConstructorProperties(value={"disasterRecoveryType"})
    public DisasterRecoveryConfiguration(DisasterRecoveryType disasterRecoveryType) {
        this.disasterRecoveryType = disasterRecoveryType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DisasterRecoveryType getDisasterRecoveryType() {
        return this.disasterRecoveryType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DisasterRecoveryConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("disasterRecoveryType=").append(String.valueOf((Object)this.disasterRecoveryType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisasterRecoveryConfiguration)) {
            return false;
        }
        DisasterRecoveryConfiguration other = (DisasterRecoveryConfiguration)((Object)o);
        return Objects.equals((Object)this.disasterRecoveryType, (Object)other.disasterRecoveryType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.disasterRecoveryType == null ? 43 : this.disasterRecoveryType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DisasterRecoveryType implements BmcEnum
    {
        Adg("ADG"),
        BackupBased("BACKUP_BASED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DisasterRecoveryType> map;

        private DisasterRecoveryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DisasterRecoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DisasterRecoveryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DisasterRecoveryType.class);
            map = new HashMap<String, DisasterRecoveryType>();
            for (DisasterRecoveryType v : DisasterRecoveryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="disasterRecoveryType")
        private DisasterRecoveryType disasterRecoveryType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder disasterRecoveryType(DisasterRecoveryType disasterRecoveryType) {
            this.disasterRecoveryType = disasterRecoveryType;
            this.__explicitlySet__.add("disasterRecoveryType");
            return this;
        }

        public DisasterRecoveryConfiguration build() {
            DisasterRecoveryConfiguration model = new DisasterRecoveryConfiguration(this.disasterRecoveryType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DisasterRecoveryConfiguration model) {
            if (model.wasPropertyExplicitlySet("disasterRecoveryType")) {
                this.disasterRecoveryType(model.getDisasterRecoveryType());
            }
            return this;
        }
    }
}

