/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSLazyString;

public abstract class JSCollectionsNormalizeNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    public static JSCollectionsNormalizeNode create() {
        return JSCollectionsNormalizeNodeGen.create();
    }

    @Specialization
    public int doInt(int value) {
        return value;
    }

    @Specialization
    public Object doDouble(double value) {
        return JSSet.normalizeDouble(value);
    }

    @Specialization
    public String doJSLazyString(JSLazyString value, @Cached(value="createBinaryProfile()") ConditionProfile flatten) {
        return value.toString(flatten);
    }

    @Specialization
    public String doString(String value) {
        return value;
    }

    @Specialization
    public boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSDynamicObject(object)"})
    public Object doDynamicObject(DynamicObject object) {
        return object;
    }

    @Specialization
    public Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    public BigInt doBigInt(BigInt bigInt) {
        return bigInt;
    }

    @Specialization(guards={"isForeignObject(object)"}, limit="3")
    public Object doForeignObject(Object object, @CachedLibrary(value="object") InteropLibrary interop, @Cached(value="createBinaryProfile()") ConditionProfile primitiveProfile, @Cached(value="create()") JSCollectionsNormalizeNode nestedNormalizeNode) {
        Object primitive = JSInteropUtil.toPrimitiveOrDefault(object, null, interop, this);
        return primitiveProfile.profile(primitive == null) ? object : nestedNormalizeNode.execute(primitive);
    }
}

