/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectonebutton.SelectOneButton;

public class SelectOneButtonRenderer
extends org.primefaces.component.selectonebutton.SelectOneButtonRenderer {
    public void encodeMarkup(FacesContext context, SelectOneButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        String style = button.getStyle();
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-selectonebutton ui-controlgroup ui-controlgroup-horizontal ui-corner-all" : "ui-selectonebutton ui-controlgroup ui-controlgroup-horizontal ui-corner-all " + styleClass;
        Converter converter = button.getConverter();
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("class", (Object)"ui-controlgroup-controls", "id");
        if (selectItems != null && !selectItems.isEmpty()) {
            int itemCount = selectItems.size();
            Object value = button.getSubmittedValue();
            if (value == null) {
                value = button.getValue();
            }
            Class type = value == null ? String.class : value.getClass();
            for (int idx = 0; idx < selectItems.size(); ++idx) {
                boolean selected;
                SelectItem selectItem = selectItems.get(idx);
                boolean disabled = selectItem.isDisabled() || button.isDisabled();
                String id = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
                Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
                boolean bl = selected = coercedItemValue != null && coercedItemValue.equals(value);
                String labelClass = idx == 0 ? "ui-first-child" : (idx == itemCount - 1 ? "ui-last-child" : null);
                this.encodeOption(context, button, selectItem, id, clientId, converter, selected, disabled, labelClass);
            }
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectOneButton button, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled, String labelClass) throws IOException {
        String labelStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)button, converter, option.getValue());
        String string = labelStyleClass = labelClass == null ? "ui-btn ui-corner-all ui-btn-inherit" : "ui-btn ui-corner-all ui-btn-inherit " + labelClass;
        if (selected) {
            labelStyleClass = labelStyleClass + " ui-btn-active";
        }
        if (disabled) {
            labelStyleClass = labelStyleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("class", (Object)"ui-radio", null);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelStyleClass, null);
        writer.writeAttribute("for", (Object)id, null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("data-role", (Object)"none", null);
        this.renderOnchange(context, (UIComponent)button);
        this.renderDynamicPassThruAttributes(context, (UIComponent)button);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

