/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;

public interface LibraryListener
extends EventListener {
    public void librariesChanged(@NonNull Project var1);

    public static final class Support {
        private final List<LibraryListener> listeners = new CopyOnWriteArrayList<LibraryListener>();

        public void addLibraryListener(@NullAllowed LibraryListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeLibraryListener(@NullAllowed LibraryListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void fireLibrariesChanged(@NonNull Project project) {
            assert (project != null);
            for (LibraryListener listener : this.listeners) {
                listener.librariesChanged(project);
            }
        }

        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }
    }
}

