/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.common.util.XMLUtil;
import com.sun.xml.registry.uddi.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.uddi.BusinessQueryManagerImpl;
import com.sun.xml.registry.uddi.CapabilityProfileImpl;
import com.sun.xml.registry.uddi.ConnectionImpl;
import com.sun.xml.registry.uddi.LifeCycleManagerImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegistryServiceImpl
implements RegistryService {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private BusinessLifeCycleManager businessLCM;
    private BusinessQueryManager businessQM;
    private LifeCycleManager lcm;
    private ConnectionImpl connection;
    private BulkResponse bulkResponse;
    private UDDIMapper uddiMapper;
    private String serviceId;
    private UDDIObjectCache objectManager;
    private HashMap bulkResponses = new HashMap();
    private XMLUtil xmlUtil;
    private boolean securitySet = false;
    private HashMap equivalentConcepts = new HashMap();
    private String defaultPostalSchemeId;

    RegistryServiceImpl(ConnectionImpl connection) {
        this.connection = connection;
        this.serviceId = Utility.generateUUID();
        this.xmlUtil = XMLUtil.getInstance();
        this.uddiMapper = new UDDIMapper(this);
        this.objectManager = this.uddiMapper.getObjectManager();
    }

    public UDDIMapper getUDDIMapper() {
        if (this.uddiMapper == null) {
            this.uddiMapper = new UDDIMapper(this);
        }
        return this.uddiMapper;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public UDDIObjectCache getObjectManager() {
        if (this.objectManager == null) {
            this.objectManager = this.uddiMapper.getObjectManager();
        }
        return this.objectManager;
    }

    public CapabilityProfile getCapabilityProfile() throws JAXRException {
        return CapabilityProfileImpl.getInstance();
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        if (this.businessLCM == null) {
            this.businessLCM = new BusinessLifeCycleManagerImpl(this);
        }
        return this.businessLCM;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        if (this.businessQM == null) {
            this.businessQM = new BusinessQueryManagerImpl(this);
        }
        return this.businessQM;
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        if (this.lcm == null) {
            this.lcm = new LifeCycleManagerImpl(this);
        }
        return this.lcm;
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        throw new UnsupportedCapabilityException();
    }

    public String makeRegistrySpecificRequest(String request) throws JAXRException {
        boolean secure = false;
        try {
            return this.uddiMapper.makeRegistrySpecificRequest(request, secure);
        }
        catch (JAXRException jex) {
            secure = true;
            return this.uddiMapper.makeRegistrySpecificRequest(request, secure);
        }
    }

    void addConceptMapping(String conceptId, String equivalentConceptId) throws JAXRException {
        if (conceptId != null && equivalentConceptId != null) {
            this.equivalentConcepts.put(conceptId, equivalentConceptId);
        }
    }

    HashMap getEquivalentConcepts() {
        return this.equivalentConcepts;
    }

    void setDefaultPostalScheme() {
        if (this.defaultPostalSchemeId == null) {
            this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        }
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        if (this.defaultPostalSchemeId == null) {
            this.logger.finest(" defaultPostalSchemeId is null");
        }
        if (this.uddiMapper == null) {
            this.getUDDIMapper();
        }
        if (this.uddiMapper != null) {
            ClassificationScheme defaultScheme = this.uddiMapper.getClassificationSchemeById(this.defaultPostalSchemeId);
            return defaultScheme;
        }
        return null;
    }

    void storeBulkResponse(BulkResponse response) {
        try {
            this.bulkResponses.put(response.getRequestId(), response);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Storing response with id: " + response.getRequestId());
            }
        }
        catch (JAXRException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public BulkResponse getBulkResponse(String requestId) throws JAXRException {
        Object response = this.bulkResponses.remove(requestId);
        if (response == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryServiceImpl:No_response_exists_for_specified_requestId"));
        }
        return (BulkResponse)response;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public SOAPBody jaxmSend(SOAPMessage msg, boolean secure) throws JAXRException {
        SOAPBody resultNode = null;
        try {
            final String proxyHost = this.getConnection().getHttpProxyHost();
            final String proxyPort = this.getConnection().getHttpProxyPort();
            String proxyUserName = this.getConnection().getProxyUserName();
            String proxyPassword = this.getConnection().getProxyPassword();
            final String sslProxyHost = this.getConnection().getHttpsProxyHost();
            final String sslProxyPort = this.getConnection().getHttpsProxyPort();
            if (proxyHost != null && !proxyHost.equals("") && proxyPort != null && !proxyPort.equals("")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Properties sysProps = System.getProperties();
                        sysProps.put("http.proxyHost", proxyHost);
                        sysProps.put("http.proxyPort", proxyPort);
                        return null;
                    }
                });
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("proxy host = " + proxyHost);
                    this.logger.finest("proxy port = " + proxyPort);
                }
            }
            if (sslProxyHost != null && !sslProxyHost.equals("") && sslProxyPort != null && !sslProxyPort.equals("")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Properties sysProps = System.getProperties();
                        sysProps.put("https.proxyHost", sslProxyHost);
                        sysProps.put("https.proxyPort", sslProxyPort);
                        return null;
                    }
                });
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("https proxy host = " + sslProxyHost);
                    this.logger.finest("https proxy port = " + sslProxyPort);
                }
            }
            final SOAPConnectionFactory scf = (SOAPConnectionFactory)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return SOAPConnectionFactory.newInstance();
                    }
                    catch (SOAPException se) {
                        se.printStackTrace();
                        return null;
                    }
                }
            });
            SOAPConnection soapConnection = (SOAPConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return scf.createConnection();
                    }
                    catch (SOAPException se) {
                        se.printStackTrace();
                        return null;
                    }
                }
            });
            if (proxyUserName != null && proxyPassword != null) {
                final String fProxyUserName = proxyUserName;
                final String fProxyPassword = proxyPassword;
                String authentication = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return "Basic " + Base64.getEncoder().encodeToString((fProxyUserName + ":" + fProxyPassword).getBytes());
                    }
                });
                msg.getMimeHeaders().setHeader("Proxy-Authorization", authentication);
            }
            String urlString = null;
            if (secure) {
                if (!this.securitySet) {
                    this.securitySet = true;
                }
                urlString = this.connection.getLifeCycleManagerURL();
            } else {
                urlString = this.connection.getQueryManagerURL();
            }
            msg.saveChanges();
            MarshallerUtil.getInstance().log(msg);
            URL url = new URL(urlString);
            SOAPMessage reply = soapConnection.call(msg, url);
            MarshallerUtil.getInstance().log(reply);
            resultNode = reply.getSOAPBody();
            soapConnection.close();
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, e.getMessage(), e);
            throw new JAXRException((Throwable)e);
        }
        return resultNode;
    }

    public Node send(SOAPMessage doc, boolean secure) throws JAXRException {
        boolean useSOAP = this.getConnection().useSOAP();
        try {
            String useSoapString = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("useSOAP");
                }
            });
            if (useSoapString != null && useSoapString.equalsIgnoreCase("true")) {
                useSOAP = true;
            }
        }
        catch (Throwable t) {
            this.logger.finest("Ignoring error checking for system useSOAP property: " + t);
        }
        if (useSOAP) {
            this.logger.fine("External Soap no longer used");
        }
        return this.jaxmSend(doc, secure);
    }

    private void printNode(Node node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            this.printNode(list.item(i));
        }
    }

    public String getCurrentUser() {
        ConnectionImpl con = this.getConnection();
        if (con != null) {
            return con.getCurrentUser();
        }
        return null;
    }
}

