/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import junit.framework.TestResult;
import org.netbeans.junit.MultiTestCase;
import org.netbeans.junit.NbTestSuite;

public abstract class MultiTestSuite
extends NbTestSuite {
    private Throwable err = null;

    public MultiTestSuite() {
        this.setName(this.getClass().getSimpleName());
    }

    public MultiTestSuite(String name) {
        super(name);
    }

    protected abstract MultiTestCase nextTestCase();

    public void run(TestResult result) {
        if (this.isPrepared()) {
            this.runAllTests(result);
            this.cleanit();
        }
        if (this.gotFailed()) {
            this.createFailLog(result);
        }
    }

    protected void runAllTests(TestResult result) {
        MultiTestCase testCase = null;
        while ((testCase = this.nextTestCase()) != null) {
            this.runTest(testCase, result);
        }
    }

    public void prepare() {
    }

    public void cleanup() {
    }

    private final boolean isPrepared() {
        boolean result = false;
        try {
            this.prepare();
            result = true;
        }
        catch (Throwable e) {
            this.err = e;
            System.out.println("Exception occured while preparing for test " + this.getName() + ": " + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    private final void cleanit() {
        try {
            this.cleanup();
        }
        catch (Throwable e) {
            this.err = e;
            System.out.println("Exception occured while cleaning after test " + this.getName() + ": " + e.toString());
            e.printStackTrace();
        }
    }

    private final boolean gotFailed() {
        return this.err != null;
    }

    private final void createFailLog(TestResult result) {
        String nameFailed = this.getName() + "FailLog";
        MultiTestCase dummy = new MultiTestCase(){

            @Override
            public void execute() {
            }
        };
        dummy.setName(nameFailed);
        dummy.setError(this.err);
        this.runTest(dummy, result);
    }
}

