/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

public final class RegexFlags
extends AbstractConstantKeysObject
implements JsonConvertible {
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("source", "ignoreCase", "multiline", "sticky", "global", "unicode", "dotAll");
    private static final int NONE = 0;
    private static final int IGNORE_CASE = 1;
    private static final int MULTILINE = 2;
    private static final int STICKY = 4;
    private static final int GLOBAL = 8;
    private static final int UNICODE = 16;
    private static final int DOT_ALL = 32;
    public static final RegexFlags DEFAULT = new RegexFlags("", 0);
    private final String source;
    private final int value;

    private RegexFlags(String source, int value) {
        this.source = source;
        this.value = value;
    }

    @CompilerDirectives.TruffleBoundary
    public static RegexFlags parseFlags(String source) throws RegexSyntaxException {
        if (source.isEmpty()) {
            return DEFAULT;
        }
        int flags = 0;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            int repeated = 0;
            switch (ch) {
                case 'i': {
                    repeated = flags & 1;
                    flags |= 1;
                    break;
                }
                case 'm': {
                    repeated = flags & 2;
                    flags |= 2;
                    break;
                }
                case 'g': {
                    repeated = flags & 8;
                    flags |= 8;
                    break;
                }
                case 'y': {
                    repeated = flags & 4;
                    flags |= 4;
                    break;
                }
                case 'u': {
                    repeated = flags & 0x10;
                    flags |= 0x10;
                    break;
                }
                case 's': {
                    repeated = flags & 0x20;
                    flags |= 0x20;
                    break;
                }
                default: {
                    throw new RegexSyntaxException(source, "unsupported regex flag: " + ch);
                }
            }
            if (repeated == 0) continue;
            throw new RegexSyntaxException(source, "repeated regex flag: " + ch);
        }
        return new RegexFlags(source, flags);
    }

    public String getSource() {
        return this.source;
    }

    public boolean isIgnoreCase() {
        return this.isSet(1);
    }

    public boolean isMultiline() {
        return this.isSet(2);
    }

    public boolean isSticky() {
        return this.isSet(4);
    }

    public boolean isGlobal() {
        return this.isSet(8);
    }

    public boolean isUnicode() {
        return this.isSet(16);
    }

    public boolean isDotAll() {
        return this.isSet(32);
    }

    public boolean isNone() {
        return this.value == 0;
    }

    private boolean isSet(int flag) {
        return (this.value & flag) != 0;
    }

    public String toString() {
        return this.source;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RegexFlags && this.value == ((RegexFlags)obj).value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("ignoreCase", this.isIgnoreCase()), Json.prop("multiline", this.isMultiline()), Json.prop("global", this.isGlobal()), Json.prop("sticky", this.isSticky()), Json.prop("unicode", this.isUnicode()), Json.prop("dotAll", this.isDotAll()));
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "source": {
                return this.getSource();
            }
            case "ignoreCase": {
                return this.isIgnoreCase();
            }
            case "multiline": {
                return this.isMultiline();
            }
            case "sticky": {
                return this.isSticky();
            }
            case "global": {
                return this.isGlobal();
            }
            case "unicode": {
                return this.isUnicode();
            }
            case "dotAll": {
                return this.isDotAll();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }
}

