/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.EntityChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodModel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.IconVisitor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class MethodChildren
extends ComponentMethodModel {
    private ComponentMethodViewStrategy mvs;
    private final EntityMethodController controller;
    private final boolean local;
    private final FileObject ddFile;
    private final Entity entity;
    private final EntityChildren entityChildren;

    public MethodChildren(EntityChildren entityChildren, ClasspathInfo cpInfo, EjbJar ejbModule, EntityMethodController smc, Entity model, boolean local, FileObject ddFile) {
        super(cpInfo, ejbModule, smc.getBeanClass(), local ? smc.getLocalHome() : smc.getHome());
        this.controller = smc;
        this.local = local;
        this.ddFile = ddFile;
        this.entity = model;
        this.entityChildren = entityChildren;
        this.mvs = new EntityStrategy();
    }

    @Override
    protected Collection<String> getInterfaces() {
        if (this.local) {
            return this.controller.getLocalInterfaces();
        }
        return this.controller.getRemoteInterfaces();
    }

    @Override
    public ComponentMethodViewStrategy createViewStrategy() {
        return this.mvs;
    }

    @Override
    public void fireTypeChange() {
        this.entityChildren.propertyChange(new PropertyChangeEvent((Object)this, "TYPE_CHANGE", "", ""));
    }

    private class EntityStrategy
    implements ComponentMethodViewStrategy {
        private EntityStrategy() {
        }

        @Override
        public void deleteImplMethod(MethodModel me, String implClass, FileObject implClassFO) throws IOException {
            String methodName = me.getName();
            if (methodName.startsWith("find") || methodName.startsWith("ejbSelect")) {
                MethodChildren.this.controller.deleteQueryMapping(me, MethodChildren.this.ddFile);
            }
            MethodChildren.this.controller.delete(me, MethodChildren.this.local);
        }

        @Override
        public Image getBadge(MethodModel me) {
            return null;
        }

        @Override
        public Image getIcon(MethodModel me) {
            IconVisitor iv = new IconVisitor();
            return ImageUtilities.loadImage((String)iv.getIconUrl(MethodChildren.this.controller.getMethodTypeFromInterface(me)));
        }

        @Override
        public void openMethod(final MethodModel me, final String implClass, FileObject implClassFO) {
            if (MethodChildren.this.controller.getMethodTypeFromInterface(me).getKind() == MethodType.Kind.FINDER) {
                try {
                    DataObject ddFileDO = DataObject.find((FileObject)MethodChildren.this.ddFile);
                    OpenCookie c = (OpenCookie)ddFileDO.getLookup().lookup(OpenCookie.class);
                    if (c != null) {
                        c.open();
                    }
                }
                catch (DataObjectNotFoundException donf) {
                    Exceptions.printStackTrace((Throwable)donf);
                }
            }
            final ArrayList methodHandle = new ArrayList();
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFO);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = controller.getElements().getTypeElement(implClass);
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            if (!MethodModelSupport.isSameMethod((CompilationController)controller, (ExecutableElement)executableElement, (MethodModel)me)) continue;
                            methodHandle.add(ElementHandle.create((Element)executableElement));
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (methodHandle.size() > 0) {
                ElementOpen.open((FileObject)implClassFO, (ElementHandle)((ElementHandle)methodHandle.get(0)));
            }
        }
    }
}

