/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.micronaut.symbol.MicronautSymbolFinder;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class MicronautEndpointRequestProvider
implements CommandProvider {
    private static final String GENERATE_DATA_ENDPOINT = "nbls.micronaut.get.endpoint.request.body";

    public Set<String> getCommands() {
        return Set.of(GENERATE_DATA_ENDPOINT);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            if (arguments.size() < 3) {
                future.complete(null);
            } else {
                JavaSource js;
                String uri = ((JsonPrimitive)arguments.get(0)).getAsString();
                String type = ((JsonPrimitive)arguments.get(1)).getAsString();
                int line = ((JsonObject)arguments.get(2)).get("line").getAsInt();
                int column = ((JsonObject)arguments.get(2)).get("character").getAsInt();
                FileObject fo = URLMapper.findFileObject((URL)URI.create(uri).toURL());
                JavaSource javaSource = js = fo != null ? JavaSource.forFileObject((FileObject)fo) : null;
                if (js == null) {
                    future.complete(null);
                } else {
                    js.runUserActionTask(cc -> {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        int offset = (int)cc.getCompilationUnit().getLineMap().getPosition(line, column);
                        TreePath path = cc.getTreeUtilities().pathFor(offset);
                        path = cc.getTreeUtilities().getPathElementOfKind(Tree.Kind.METHOD, path);
                        if (path == null) {
                            future.complete(null);
                        } else {
                            Element el = cc.getTrees().getElement(path);
                            if (el != null && el.getKind() == ElementKind.METHOD) {
                                String contentType = MicronautEndpointRequestProvider.getContentType((CompilationInfo)cc, el, type);
                                ArrayList<VariableElement> fileUploads = new ArrayList<VariableElement>();
                                LinkedHashMap<String, VariableElement> body2params = new LinkedHashMap<String, VariableElement>();
                                for (VariableElement variableElement : ((ExecutableElement)el).getParameters()) {
                                    if (variableElement.asType().getKind() == TypeKind.DECLARED && "io.micronaut.http.multipart.CompletedFileUpload".contentEquals(((TypeElement)((DeclaredType)variableElement.asType()).asElement()).getQualifiedName())) {
                                        fileUploads.add(variableElement);
                                        if (contentType != null) continue;
                                        contentType = "multipart/form-data";
                                        continue;
                                    }
                                    AnnotationMirror ann = Utils.getAnnotation(variableElement.getAnnotationMirrors(), "io.micronaut.http.annotation.Body");
                                    if (ann == null) continue;
                                    String id = "";
                                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ann.getElementValues().entrySet()) {
                                        if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                                        id = (String)entry.getValue().getValue();
                                        if (contentType != null) continue;
                                        contentType = "application/json";
                                    }
                                    body2params.put(id, variableElement);
                                    if (contentType != null || !id.isEmpty()) continue;
                                    TypeMirror tm = variableElement.asType();
                                    if (tm.getKind() == TypeKind.TYPEVAR) {
                                        tm = ((TypeVariable)tm).getUpperBound();
                                    }
                                    if (tm.getKind() == TypeKind.DECLARED && Utils.getAnnotation(((DeclaredType)tm).asElement().getAnnotationMirrors(), "io.micronaut.serde.annotation.Serdeable") != null) {
                                        contentType = "application/json";
                                        continue;
                                    }
                                    if (cc.getTypes().isAssignable(variableElement.asType(), cc.getElements().getTypeElement("java.lang.CharSequence").asType())) continue;
                                    contentType = "";
                                }
                                AtomicInteger cnt = new AtomicInteger();
                                StringBuilder stringBuilder = new StringBuilder();
                                if (contentType != null) {
                                    stringBuilder.append("\nContent-Type: ${").append(cnt.incrementAndGet()).append(':').append(contentType).append("}");
                                }
                                if (!fileUploads.isEmpty() && "multipart/form-data".equals(contentType)) {
                                    stringBuilder.append("; boundary=mfd\n\n");
                                    for (VariableElement fileUpload : fileUploads) {
                                        int fnNum = cnt.incrementAndGet();
                                        stringBuilder.append("--mfd\nContent-Disposition: form-data; name=").append(fileUpload.getSimpleName()).append("; filename=\"${").append(fnNum).append(":file-name}\"\n\n");
                                        stringBuilder.append("< ${").append(cnt.incrementAndGet()).append(":/path/to/}${").append(fnNum).append("}\n");
                                    }
                                    stringBuilder.append("--mfd--");
                                } else if (body2params.isEmpty()) {
                                    stringBuilder.append("\n\n${").append(cnt.incrementAndGet()).append(":// TODO: Fill the value").append(contentType).append("}");
                                } else if (body2params.size() == 1 && ((String)body2params.keySet().iterator().next()).isEmpty()) {
                                    stringBuilder.append("\n\n");
                                    MicronautEndpointRequestProvider.fillJSON((CompilationInfo)cc, 0, null, (VariableElement)body2params.values().iterator().next(), stringBuilder, cnt);
                                } else {
                                    stringBuilder.append("\n\n{\n");
                                    Iterator it = body2params.entrySet().iterator();
                                    while (it.hasNext()) {
                                        Map.Entry entry = it.next();
                                        MicronautEndpointRequestProvider.fillJSON((CompilationInfo)cc, 1, (String)entry.getKey(), (VariableElement)entry.getValue(), stringBuilder, cnt);
                                        if (it.hasNext()) {
                                            stringBuilder.append(',');
                                        }
                                        stringBuilder.append('\n');
                                    }
                                    stringBuilder.append('}');
                                }
                                future.complete(stringBuilder.toString());
                            } else {
                                future.complete(null);
                            }
                        }
                    }, true);
                }
            }
        }
        catch (IOException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private static void fillJSON(CompilationInfo info, int level, String name, VariableElement ve, StringBuilder sb, AtomicInteger cnt) {
        TypeMirror tm;
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        if (name != null) {
            sb.append('\"').append(name).append("\": ");
        }
        if ((tm = ve.asType()).getKind() == TypeKind.TYPEVAR) {
            tm = ((TypeVariable)tm).getUpperBound();
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            TypeElement te = (TypeElement)((DeclaredType)tm).asElement();
            if ("java.lang.String".contentEquals(te.getQualifiedName())) {
                sb.append("\"${").append(cnt.incrementAndGet()).append(':').append(ve.getSimpleName()).append("}\"");
            } else if (Utils.getAnnotation(te.getAnnotationMirrors(), "io.micronaut.serde.annotation.Serdeable") != null) {
                sb.append("{\n");
                if (level > 0) {
                    VariableElement id = Utils.getIdElement(ElementFilter.fieldsIn(te.getEnclosedElements()));
                    if (id != null) {
                        MicronautEndpointRequestProvider.fillJSON(info, level + 1, id.getSimpleName().toString(), id, sb, cnt);
                    } else {
                        sb.append("${").append(cnt.incrementAndGet()).append(": // TODO: Fill the value for '").append(id.getSimpleName()).append("' of type '").append(Utils.getTypeName(info, id.asType(), false, false)).append("'}");
                    }
                    sb.append('\n');
                } else {
                    Iterator<VariableElement> it = ElementFilter.fieldsIn(te.getEnclosedElements()).iterator();
                    while (it.hasNext()) {
                        VariableElement field = it.next();
                        MicronautEndpointRequestProvider.fillJSON(info, level + 1, field.getSimpleName().toString(), field, sb, cnt);
                        if (it.hasNext()) {
                            sb.append(',');
                        }
                        sb.append('\n');
                    }
                }
                for (int i = 0; i < level; ++i) {
                    sb.append("  ");
                }
                sb.append('}');
            } else {
                Types types = info.getTypes();
                if (types.isAssignable(types.erasure(tm), info.getElements().getTypeElement("java.util.Collection").asType())) {
                    sb.append("[]");
                } else if (types.isAssignable(types.erasure(tm), info.getElements().getTypeElement("java.lang.Number").asType())) {
                    sb.append("${").append(cnt.incrementAndGet()).append(':').append(ve.getSimpleName()).append('}');
                } else {
                    try {
                        tm = info.getTypes().unboxedType(tm);
                        sb.append("${").append(cnt.incrementAndGet()).append(':').append(ve.getSimpleName()).append('}');
                    }
                    catch (IllegalArgumentException e) {
                        sb.append("${").append(cnt.incrementAndGet()).append(": // TODO: Fill the value for '").append(ve.getSimpleName()).append("' of type '").append(Utils.getTypeName(info, ve.asType(), false, false)).append("'}");
                    }
                }
            }
        } else if (tm.getKind().isPrimitive()) {
            sb.append("${").append(cnt.incrementAndGet()).append(':').append(ve.getSimpleName()).append('}');
        } else {
            sb.append("${").append(cnt.incrementAndGet()).append(": // TODO: Fill the value for '").append(ve.getSimpleName()).append("' of type '").append(Utils.getTypeName(info, ve.asType(), false, false)).append("'}");
        }
    }

    private static String type2AnnType(String type) {
        switch (type) {
            case "POST": {
                return "io.micronaut.http.annotation.Post";
            }
            case "PUT": {
                return "io.micronaut.http.annotation.Put";
            }
        }
        return null;
    }

    private static String getContentType(CompilationInfo info, Element el, String type) {
        String annType = MicronautEndpointRequestProvider.type2AnnType(type);
        if (annType != null) {
            MicronautSymbolFinder.MthIterator it = new MicronautSymbolFinder.MthIterator(el, info.getElements(), info.getTypes());
            while (it.hasNext()) {
                ExecutableElement mth = it.next();
                AnnotationMirror ann = Utils.getAnnotation(mth.getAnnotationMirrors(), annType);
                if (ann == null) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ann.getElementValues().entrySet()) {
                    if (!"consumes".contentEquals(entry.getKey().getSimpleName())) continue;
                    return entry.getValue().accept(new SimpleAnnotationValueVisitor6<String, Void>(){

                        @Override
                        public String visitString(String s, Void p) {
                            return s;
                        }

                        @Override
                        public String visitArray(List<? extends AnnotationValue> vals, Void p) {
                            Iterator<? extends AnnotationValue> iterator = vals.iterator();
                            if (iterator.hasNext()) {
                                AnnotationValue val = iterator.next();
                                return val.accept(this, p);
                            }
                            return (String)this.defaultAction(vals, p);
                        }
                    }, null);
                }
            }
        }
        return null;
    }
}

