/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.parsing.api.Source;

public final class CompletionContext {
    private boolean attribute;
    private int caretOffset;
    private String prefix;
    private int startOffset = -1;
    private int tokenTail;
    private String piTarget;
    private String piData;
    private String tagName;
    private int tagStartOffset = -1;
    private int rootTagStartOffset = -1;
    private Type type;
    private ClasspathInfo cpInfo;
    private CompilationInfo compilationInfo;
    private Document doc;
    private WhiteListQuery.WhiteList typeWhiteList;
    private int rootAttrInsertOffset;
    private boolean currentIsRoot;
    private int queryType;
    private FxmlParserResult fxmlParserResult;
    private TokenHierarchy<?> hierarchy;
    private List<? extends FxNode> parents;
    private FxNode elementParent;
    private boolean replaceExisting;
    private int nextCaretPos = -1;
    private FxInstance instanceElement;
    private int tagEndOffset = -1;
    private boolean finished;
    private boolean selfClosed;
    private Map<String, String> rootNamespacePrefixes = new HashMap<String, String>();
    private static final String NAMESPACE_PREFIX = "xmlns:";
    private static final ArgumentInfo NO_ARGUMENT = new ArgumentInfo(-1, -1, -1, null);
    private Map<String, ArgumentInfo> attributes = Collections.emptyMap();
    private Map<String, ArgumentInfo> rootAttributes = Collections.emptyMap();
    private String propertyName;

    public CompletionContext(Document doc, int offset, int completionType) {
        this.doc = doc;
        this.caretOffset = offset;
        this.queryType = completionType;
    }

    CompletionContext(FxmlParserResult result, int offset, int completionType) {
        this.fxmlParserResult = result;
        this.hierarchy = result.getTokenHierarchy();
        this.caretOffset = offset;
        this.queryType = completionType;
        this.processTokens(this.hierarchy);
    }

    public int getCompletionType() {
        return this.queryType;
    }

    public void init(TokenHierarchy h, CompilationInfo info, FxmlParserResult fxmlResult) {
        this.hierarchy = h;
        this.compilationInfo = info;
        this.cpInfo = info.getClasspathInfo();
        this.fxmlParserResult = fxmlResult;
        this.processTokens(h);
    }

    public Source getSource() {
        return this.fxmlParserResult.getSnapshot().getSource();
    }

    public FxModel getModel() {
        return this.fxmlParserResult.getSourceModel();
    }

    public FxBean getBeanInfo(String className) {
        if (className == null) {
            return null;
        }
        return FxBean.getBeanProvider(this.compilationInfo).getBeanInfo(className);
    }

    public FxBean getBeanInfo(FxInstance inst) {
        return this.getBeanInfo(inst.getResolvedName());
    }

    public String getSimpleClassName(String fqn) {
        int lastDot = fqn.lastIndexOf(46);
        String sn = fqn.substring(lastDot + 1);
        if (fqn.equals(this.resolveClassName(sn))) {
            return sn;
        }
        return null;
    }

    public String resolveClassName(String name) {
        Set<String> names = this.fxmlParserResult.resolveClassName(this.compilationInfo, name);
        if (names == null || names.size() > 1) {
            return null;
        }
        return (String)names.iterator().next();
    }

    private void processTokens(TokenHierarchy h) {
        TextPositions pos;
        int end;
        TokenSequence ts = h.tokenSequence();
        this.readRootElement((TokenSequence<XMLTokenId>)ts);
        FxModel m = this.fxmlParserResult.getSourceModel();
        FxNode n = m.getRootComponent();
        if (n != null && this.caretOffset >= (end = (pos = this.fxmlParserResult.getTreeUtilities().positions(n)).getEnd()) && pos.isDefined(TextPositions.Position.End)) {
            this.type = Type.UNKNOWN;
        }
        this.processType((TokenSequence<XMLTokenId>)ts);
        this.processValueType();
        if (this.rootTagStartOffset != -1 && this.caretOffset < this.rootTagStartOffset) {
            switch (this.type) {
                case BEAN: 
                case PROPERTY_VALUE: 
                case PROPERTY_ELEMENT: 
                case CHILD_ELEMENT: 
                case ROOT: {
                    this.type = Type.INSTRUCTION_TARGET;
                }
            }
        }
        this.readCurrentContent((TokenSequence<XMLTokenId>)ts);
        this.processNamespaces();
        this.processPath();
        if (this.parents.size() == 1) {
            switch (this.type) {
                case PROPERTY_VALUE: {
                    this.type = Type.UNKNOWN;
                    break;
                }
                case PROPERTY_ELEMENT: 
                case CHILD_ELEMENT: {
                    this.type = Type.BEAN;
                }
            }
        }
        if (this.getType() == Type.CHILD_ELEMENT && !this.getParents().isEmpty()) {
            List<? extends FxNode> parents = this.getParents();
            n = parents.get(0);
            if (n.getKind() == FxNode.Kind.Property) {
                this.type = Type.BEAN;
            } else if (n.getKind() == FxNode.Kind.Instance) {
                FxInstance inst = (FxInstance)n;
                FxBean bi = this.getBeanInfo(inst);
                if (bi != null) {
                    if (bi.getDefaultProperty() == null) {
                        this.type = Type.PROPERTY_ELEMENT;
                    } else {
                        for (PropertyValue pv : inst.getProperties()) {
                            if (!(pv instanceof PropertySetter) || !((PropertySetter)pv).isImplicit()) continue;
                            this.type = Type.PROPERTY_ELEMENT;
                            break;
                        }
                    }
                }
            } else if (n.getKind() == FxNode.Kind.Property) {
                this.type = Type.PROPERTY_VALUE_CONTENT;
            } else if (n.getKind() == FxNode.Kind.Event) {
                this.type = Type.HANDLER;
            }
        }
        this.findNextCaretPos(ts);
    }

    public boolean isReplaceExisting() {
        return this.replaceExisting;
    }

    private void findNextCaretPos(TokenSequence ts) {
        int off = ts.move(this.caretOffset);
        if (off == 0 && this.caretOffset == this.startOffset) {
            return;
        }
        switch (this.type) {
            case PROPERTY: {
                boolean wsFound = false;
                block14: while (ts.moveNext()) {
                    Token t = ts.token();
                    switch ((XMLTokenId)t.id()) {
                        case WS: {
                            wsFound = true;
                            continue block14;
                        }
                        case ARGUMENT: {
                            if (wsFound) {
                                return;
                            }
                        }
                        case OPERATOR: 
                        case VALUE: {
                            this.replaceExisting = true;
                            this.nextCaretPos = ts.offset() + 1;
                            return;
                        }
                    }
                    return;
                }
                break;
            }
            case BEAN: 
            case PROPERTY_ELEMENT: 
            case CHILD_ELEMENT: 
            case ROOT: {
                if (this.prefix.length() == 1 && this.tokenTail == 0) {
                    return;
                }
                block15: while (ts.moveNext()) {
                    Token t = ts.token();
                    switch ((XMLTokenId)t.id()) {
                        case WS: {
                            this.nextCaretPos = ts.offset() + 1;
                            continue block15;
                        }
                        case TAG: {
                            if (ts.offset() == this.startOffset) continue block15;
                            this.replaceExisting = true;
                            if (t.text().charAt(0) != '>' || this.nextCaretPos > -1) {
                                return;
                            }
                            if (this.type == Type.PROPERTY_ELEMENT) {
                                this.nextCaretPos = ts.offset() + 1;
                                return;
                            }
                            this.nextCaretPos = ts.offset();
                            return;
                        }
                        case ARGUMENT: {
                            this.replaceExisting = true;
                            return;
                        }
                    }
                    return;
                }
                break;
            }
        }
    }

    public int getNextCaretPos() {
        return this.nextCaretPos;
    }

    public List<? extends FxNode> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public FxNode getElementParent() {
        return this.elementParent;
    }

    public FxProperty getEnclosingProperty() {
        FxInstance inst;
        FxBean bean;
        if (this.parents.isEmpty()) {
            return null;
        }
        FxNode parent = this.parents.get(0);
        if (parent instanceof PropertySetter) {
            return ((PropertySetter)parent).getPropertyInfo();
        }
        if (parent.getKind() == FxNode.Kind.Instance && (bean = (inst = (FxInstance)parent).getDefinition()) != null && bean.getDefaultProperty() != null) {
            String pn = bean.getDefaultProperty().getName();
            if (inst.getProperty(pn) != null) {
                return null;
            }
            if (this.fxmlParserResult.getTreeUtilities().positions(inst).contentContains(this.caretOffset, true)) {
                return bean.getDefaultProperty();
            }
        }
        return null;
    }

    public FxInstance getInstanceElement() {
        return this.instanceElement;
    }

    private void processPath() {
        PropertySetter ps;
        this.parents = this.fxmlParserResult.getTreeUtilities().findEnclosingElements(this.getCaretOffset(), this.isTag(), true);
        if (this.parents.isEmpty()) {
            return;
        }
        int index = 1;
        FxNode parent = this.parents.get(0);
        if (this.fxmlParserResult.getTreeUtilities().isAttribute(parent) && this.parents.size() > index) {
            parent = this.parents.get(index++);
        }
        if (parent instanceof PropertySetter && (ps = (PropertySetter)parent).isImplicit() && this.parents.size() > index) {
            FxNode superParent;
            if ((superParent = this.parents.get(index++)).getKind() != FxNode.Kind.Instance) {
                throw new IllegalStateException();
            }
            parent = (FxInstance)superParent;
        }
        this.elementParent = parent;
        if (parent != null && parent.getKind() == FxNode.Kind.Instance) {
            this.instanceElement = (FxInstance)parent;
        }
    }

    @NonNull
    public CompilationInfo getCompilationInfo() {
        return this.compilationInfo;
    }

    @NonNull
    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    void setClasspathInfo(ClasspathInfo cpInfo) {
        this.cpInfo = cpInfo;
    }

    public Type getType() {
        return this.type;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getTokenTail() {
        return this.tokenTail;
    }

    public String getPiTarget() {
        return this.piTarget;
    }

    public String getPiData() {
        return this.piData;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getTagStartOffset() {
        return this.tagStartOffset;
    }

    public int getEndOffset() {
        return this.getCaretOffset() + this.getTokenTail();
    }

    public int getReplaceLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public Document getDoc() {
        return this.doc;
    }

    public int getTagEndOffset() {
        return this.tagEndOffset;
    }

    public boolean isTagFinished() {
        return this.finished;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    private void markUnclosed(int offendingContent) {
        this.finished = false;
        this.selfClosed = false;
        this.tagEndOffset = offendingContent;
    }

    public boolean isProcessingInstruction() {
        switch (this.type) {
            case INSTRUCTION_DATA: 
            case INSTRUCTION_TARGET: {
                return true;
            }
        }
        return false;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isTag() {
        switch (this.type) {
            case BEAN: 
            case PROPERTY_ELEMENT: 
            case CHILD_ELEMENT: 
            case ROOT: {
                return true;
            }
        }
        return false;
    }

    private void readPIContent(TokenSequence<XMLTokenId> seq) {
        boolean cont = true;
        block8: while (cont && seq.moveNext()) {
            Token t = seq.token();
            XMLTokenId id = (XMLTokenId)t.id();
            switch (id) {
                case TAG: {
                    this.markUnclosed(seq.offset());
                    return;
                }
                case ARGUMENT: 
                case OPERATOR: 
                case VALUE: 
                case CHARACTER: 
                case BLOCK_COMMENT: 
                case CDATA_SECTION: 
                case DECLARATION: 
                case TEXT: 
                case PI_START: 
                case ERROR: {
                    this.markUnclosed(seq.offset());
                    return;
                }
                case PI_TARGET: {
                    this.piTarget = t.text().toString();
                    continue block8;
                }
                case PI_CONTENT: {
                    this.piData = t.text().toString();
                    continue block8;
                }
                case PI_END: {
                    this.selfClosed = true;
                    this.finished = true;
                    this.tagEndOffset = seq.offset() + t.length();
                    return;
                }
                case WS: {
                    continue block8;
                }
            }
            this.markUnclosed(seq.offset());
            return;
        }
    }

    public boolean isRootElement() {
        return this.currentIsRoot;
    }

    public int getRootAttrInsertOffset() {
        return this.rootAttrInsertOffset;
    }

    public String findNsPrefix(String nsUri) {
        return this.rootNamespacePrefixes.get(nsUri);
    }

    public String findFxmlNsPrefix() {
        String fxPrefix = "http://javafx.com/fxml";
        String candidate = null;
        int version = -1;
        for (Map.Entry<String, String> nsE : this.rootNamespacePrefixes.entrySet()) {
            int thisVersion;
            block4: {
                String p = nsE.getKey();
                if (!p.startsWith("http://javafx.com/fxml")) continue;
                if (p.length() > "http://javafx.com/fxml".length()) {
                    if (p.charAt("http://javafx.com/fxml".length()) != '/') continue;
                    try {
                        thisVersion = Integer.parseInt(p.substring("http://javafx.com/fxml".length() + 1));
                        break block4;
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                }
                thisVersion = 0;
            }
            if (version >= thisVersion) continue;
            candidate = nsE.getValue();
        }
        return version == -1 ? null : candidate;
    }

    public String findPrefixString(@NonNull String nsURI, @NonNull String suggested) {
        String existing = this.findNsPrefix(nsURI);
        if (existing != null) {
            return existing;
        }
        boolean repeat = false;
        int counter = 1;
        String pref = suggested;
        block0: while (repeat) {
            repeat = false;
            for (String s : this.rootNamespacePrefixes.values()) {
                if (!s.equals(pref)) continue;
                pref = suggested + counter;
                ++counter;
                repeat = true;
                continue block0;
            }
        }
        return pref;
    }

    private void processNamespaces() {
        for (String s : this.rootAttributes.keySet()) {
            if (!s.startsWith(NAMESPACE_PREFIX)) continue;
            String nsPrefix = s.substring(NAMESPACE_PREFIX.length());
            String uri = this.rootAttributes.get(s).valueContent;
            this.rootNamespacePrefixes.put(uri, nsPrefix);
        }
    }

    private void copyToRoot() {
        this.rootTagStartOffset = this.tagStartOffset;
        this.rootAttributes = this.attributes;
        this.tagStartOffset = -1;
        this.attributes = Collections.emptyMap();
        this.finished = false;
        this.selfClosed = false;
    }

    private void readRootElement(TokenSequence<XMLTokenId> seq) {
        seq.move(0);
        while (seq.moveNext()) {
            Token t = seq.token();
            XMLTokenId id = (XMLTokenId)t.id();
            if (id != XMLTokenId.TAG || t.length() <= 1) continue;
            int startOffset = seq.offset();
            this.readTagContent(seq);
            this.copyToRoot();
            this.rootTagStartOffset = startOffset;
            this.rootAttrInsertOffset = startOffset + t.length();
            if (t.text().charAt(t.length() - 1) == '>') {
                --this.rootAttrInsertOffset;
                if (t.length() > 2 && t.text().charAt(t.length() - 2) == '/') {
                    --this.rootAttrInsertOffset;
                }
            }
            this.findRootInsertionPoint();
            return;
        }
    }

    private void findRootInsertionPoint() {
        if (!this.rootAttributes.isEmpty()) {
            int min = Integer.MAX_VALUE;
            for (ArgumentInfo ai : this.rootAttributes.values()) {
                min = Math.min(min, ai.argStart);
            }
            this.rootAttrInsertOffset = min;
        }
    }

    ArgumentInfo attr(String aName) {
        ArgumentInfo ai = this.attributes.get(aName);
        return ai != null ? ai : NO_ARGUMENT;
    }

    public Enumeration<String> attributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String value(String arg) {
        return this.attr(arg).valueContent;
    }

    public String createNSName(String prefix, String name) {
        if (prefix == null) {
            return name;
        }
        return prefix + ":" + name;
    }

    public String fxAttributeName(String name) {
        String prefix = this.findFxmlNsPrefix();
        if (prefix == null) {
            return null;
        }
        return prefix + ":" + name;
    }

    public String attributeNSName(String prefix, String name) {
        if (prefix == null) {
            return name;
        }
        if (!this.rootNamespacePrefixes.containsValue(prefix)) {
            return null;
        }
        return prefix + ":" + name;
    }

    public String attributeName(String nsURI, String name) {
        if (nsURI == null) {
            return name;
        }
        String prefix = this.findNsPrefix(nsURI);
        if (prefix == null) {
            return null;
        }
        return prefix + ":" + name;
    }

    public boolean contains(String a) {
        return this.attr(a).argStart != -1;
    }

    public int attrStart(String a) {
        return this.attr(a).argStart;
    }

    public int valueStart(String a) {
        return this.attr(a).valueStart;
    }

    public int valueEnd(String a) {
        return this.attr(a).valueEnd;
    }

    private void readCurrentContent(TokenSequence<XMLTokenId> seq) {
        if (this.tagStartOffset == -1) {
            return;
        }
        int diff = seq.move(this.tagStartOffset);
        if (diff > 0) {
            throw new IllegalStateException();
        }
        if (!seq.moveNext()) {
            return;
        }
        Token t = seq.token();
        if (t.id() == XMLTokenId.TAG) {
            if (t.text().toString().endsWith("/>")) {
                this.finished = true;
                this.tagEndOffset = seq.offset() + t.length();
                this.selfClosed = true;
                return;
            }
            if (this.rootTagStartOffset == seq.offset()) {
                this.currentIsRoot = true;
            }
            this.readTagContent(seq);
        } else if (t.id() == XMLTokenId.PI_START) {
            this.readPIContent(seq);
        }
    }

    private CharSequence stripQuotes(CharSequence s) {
        char q = '\u0000';
        if (s == null || s.length() == 0) {
            return s;
        }
        char c = s.charAt(0);
        int start = 0;
        int end = s.length();
        if (c == '\'' || c == '\"') {
            ++start;
            q = c;
        }
        if (end == start - 1) {
            return s.subSequence(start, end);
        }
        c = s.charAt(end - 1);
        if (c == q) {
            return s.subSequence(start, end - 1);
        }
        while (end > start && Character.isWhitespace(c)) {
            c = s.charAt(--end);
        }
        return s.subSequence(start, end + 1);
    }

    private void readTagContent(TokenSequence<XMLTokenId> seq) {
        this.attributes = new HashMap<String, ArgumentInfo>();
        String argName = null;
        int argStart = -1;
        while (seq.moveNext()) {
            Token t = seq.token();
            XMLTokenId id = (XMLTokenId)t.id();
            switch (id) {
                case TAG: {
                    CharSequence s = t.text();
                    if (s.charAt(0) == '<') {
                        this.markUnclosed(seq.offset());
                        return;
                    }
                    if (s.charAt(s.length() - 1) == '>') {
                        this.finished = true;
                        this.tagEndOffset = seq.offset() + s.length();
                        this.selfClosed = s.length() >= 2 && s.charAt(s.length() - 2) == '/';
                        return;
                    }
                }
                case ARGUMENT: {
                    argName = t.text().toString();
                    argStart = seq.offset();
                    break;
                }
                case VALUE: {
                    if (argName == null) break;
                    int len = t.length();
                    CharSequence val = t.text();
                    StringBuilder compound = null;
                    while (seq.moveNext()) {
                        Token nt = seq.token();
                        if (nt.id() != XMLTokenId.CHARACTER && nt.id() != XMLTokenId.VALUE) {
                            seq.movePrevious();
                            break;
                        }
                        if (compound == null) {
                            compound = new StringBuilder();
                            compound.append(val);
                        }
                        compound.append(nt.text());
                        len += nt.length();
                    }
                    this.attributes.put(argName, new ArgumentInfo(argStart, seq.offset(), seq.offset() + len, this.stripQuotes(compound == null ? t.text() : compound).toString()));
                    break;
                }
                case OPERATOR: {
                    break;
                }
                case CHARACTER: 
                case BLOCK_COMMENT: 
                case CDATA_SECTION: 
                case DECLARATION: 
                case TEXT: 
                case ERROR: {
                    this.markUnclosed(seq.offset());
                    return;
                }
                case PI_TARGET: 
                case PI_CONTENT: 
                case PI_END: {
                    this.markUnclosed(seq.offset());
                    return;
                }
                case WS: {
                    break;
                }
            }
        }
    }

    private void processValueType() {
        char c;
        switch (this.type) {
            case PROPERTY_VALUE: 
            case PROPERTY: {
                this.attribute = true;
            }
        }
        if (this.type != Type.PROPERTY_VALUE && this.type != Type.PROPERTY_VALUE_CONTENT) {
            return;
        }
        if (!(this.prefix.isEmpty() || (c = this.prefix.charAt(0)) != '\'' && c != '\"')) {
            this.prefix = this.prefix.substring(1);
        }
        if (this.prefix.startsWith("@")) {
            this.type = Type.RESOURCE_REF;
        } else if (this.prefix.startsWith("%")) {
            this.type = Type.BUNDLE_REF;
        } else if (this.prefix.startsWith("${")) {
            this.type = Type.BINDING;
        } else if (this.prefix.startsWith("$")) {
            this.type = Type.VARIABLE;
        } else if (this.prefix.startsWith("#")) {
            this.type = Type.HANDLER;
        }
    }

    private boolean isTextContent(XMLTokenId id) {
        return id == XMLTokenId.TEXT || id == XMLTokenId.CDATA_SECTION || id == XMLTokenId.CHARACTER;
    }

    private void setTextContentBoundaries(TokenSequence<XMLTokenId> ts) {
        Token t;
        XMLTokenId id;
        Token t2;
        XMLTokenId id2;
        while (ts.movePrevious() && !this.isTextContent(id2 = (XMLTokenId)(t2 = ts.token()).id())) {
        }
        int start = ts.offset() + ts.token().length();
        while (ts.moveNext() && !this.isTextContent(id = (XMLTokenId)(t = ts.token()).id())) {
        }
        int end = ts.offset();
        this.startOffset = start;
        this.tokenTail = end - this.caretOffset;
    }

    public String getPropertyName() {
        if (this.type == Type.PROPERTY_VALUE) {
            return this.propertyName;
        }
        if (this.type == Type.PROPERTY) {
            return this.tagName;
        }
        if (this.type == Type.PROPERTY_ELEMENT) {
            return this.tagName;
        }
        return null;
    }

    private void processType(TokenSequence<XMLTokenId> ts) {
        XMLTokenId id;
        boolean cont;
        CharSequence s;
        int diff = ts.move(this.caretOffset);
        boolean middle = diff > 0;
        boolean hasToken = middle ? ts.moveNext() : ts.movePrevious();
        boolean wsFound = false;
        Token t = null;
        boolean dontAdvance = false;
        while (this.type == null && hasToken) {
            t = ts.token();
            if (middle) {
                this.tokenTail = t.length() - diff;
            }
            XMLTokenId id2 = (XMLTokenId)t.id();
            switch (id2) {
                case PI_END: {
                    this.type = Type.INSTRUCTION_END;
                    break;
                }
                case PI_CONTENT: {
                    String tail = t.text().subSequence(diff, diff + this.tokenTail).toString();
                    String trimmed = tail.trim();
                    this.tokenTail = trimmed.isEmpty() ? 0 : tail.indexOf(trimmed) + trimmed.length();
                    this.type = Type.INSTRUCTION_DATA;
                    break;
                }
                case PI_TARGET: {
                    this.type = Type.INSTRUCTION_TARGET;
                    this.piTarget = t.text().toString();
                    this.tagStartOffset = ts.offset();
                    dontAdvance = this.caretOffset == ts.offset() + t.length();
                    break;
                }
                case PI_START: {
                    this.type = Type.INSTRUCTION_TARGET;
                    dontAdvance = true;
                    break;
                }
                case VALUE: {
                    this.type = Type.PROPERTY_VALUE;
                    break;
                }
                case OPERATOR: {
                    this.type = Type.PROPERTY_VALUE;
                    if (this.startOffset == -1) {
                        this.startOffset = this.caretOffset;
                    }
                    this.prefix = "";
                    dontAdvance = true;
                    break;
                }
                case CHARACTER: 
                case CDATA_SECTION: 
                case TEXT: {
                    String nonWh = t.text().toString().trim();
                    if (!nonWh.isEmpty()) {
                        if (nonWh.startsWith("<")) {
                            int nonWhPos = t.text().toString().indexOf(nonWh);
                            if (this.startOffset == -1) {
                                this.startOffset = ts.offset() + nonWhPos;
                            }
                            if (this.caretOffset > this.startOffset + nonWh.length()) {
                                this.type = Type.UNKNOWN;
                            } else {
                                this.tokenTail = nonWh.length() - (this.caretOffset - this.startOffset);
                                this.type = Type.CHILD_ELEMENT;
                            }
                            this.tagName = t.text().subSequence(nonWhPos + 1, nonWh.length()).toString();
                            this.tagStartOffset = ts.offset();
                            break;
                        }
                        this.type = this.rootTagStartOffset == -1 || this.rootTagStartOffset <= this.startOffset ? Type.ROOT : Type.PROPERTY_VALUE;
                        this.setTextContentBoundaries(ts);
                        break;
                    }
                }
                case WS: 
                case ERROR: {
                    wsFound = true;
                    middle = false;
                    this.tokenTail = 0;
                    this.startOffset = this.caretOffset;
                    this.prefix = "";
                    break;
                }
                case TAG: {
                    s = t.text();
                    if (s.length() == 1 && s.charAt(0) == '>') {
                        this.type = Type.CHILD_ELEMENT;
                        if (this.startOffset != -1) break;
                        this.startOffset = ts.offset() + 1;
                        this.prefix = "";
                        break;
                    }
                    if (s.length() > 1 && s.charAt(1) == '/') {
                        this.type = Type.UNKNOWN;
                        break;
                    }
                    s = s.subSequence(1, s.length());
                    CharSequence s2 = CompletionContext.getUnprefixed(s);
                    this.type = s.length() != s2.length() ? Type.CHILD_ELEMENT : (wsFound ? Type.PROPERTY : (s2.length() == 0 ? Type.CHILD_ELEMENT : (CompletionContext.isClassTagName(s2) ? Type.BEAN : Type.PROPERTY_ELEMENT)));
                    int l = s2.length();
                    if (s2.length() > 1 && s2.charAt(l - 2) == '/') {
                        --l;
                    }
                    this.tagName = s2.subSequence(0, l).toString();
                    this.tagStartOffset = ts.offset();
                    dontAdvance = this.caretOffset == this.tagStartOffset + t.length();
                    break;
                }
                case ARGUMENT: {
                    this.type = Type.PROPERTY;
                    boolean bl = dontAdvance = this.caretOffset == ts.offset() + t.length();
                }
            }
            if (this.type != null) continue;
            hasToken = ts.movePrevious();
            middle = false;
        }
        if (!wsFound && this.prefix == null) {
            if (t == null) {
                this.prefix = "";
            } else if (diff > 0) {
                this.prefix = t.text().subSequence(0, diff).toString();
            } else if (ts.offset() < this.caretOffset) {
                this.prefix = t.text().toString();
            }
        }
        if (this.startOffset == -1) {
            this.startOffset = hasToken ? ts.offset() : this.caretOffset;
        }
        if (!(dontAdvance || !wsFound && middle || this.type == null)) {
            Type oldType = this.type;
            switch (oldType) {
                case INSTRUCTION_TARGET: {
                    this.type = Type.INSTRUCTION_DATA;
                    break;
                }
                case PROPERTY_VALUE: {
                    this.type = Type.PROPERTY;
                    break;
                }
                case BEAN: 
                case PROPERTY_ELEMENT: {
                    this.type = Type.PROPERTY;
                    break;
                }
                case INSTRUCTION_END: {
                    this.type = Type.ROOT;
                }
            }
            if (oldType != this.type) {
                this.prefix = "";
                this.tokenTail = 0;
                this.startOffset = this.caretOffset;
            }
        }
        boolean bl = cont = this.tagStartOffset == -1;
        while (ts.movePrevious() && cont) {
            t = ts.token();
            id = (XMLTokenId)t.id();
            switch (id) {
                case TAG: {
                    s = t.text();
                    if (s.length() == 1 && s.charAt(0) == '>') break;
                    int start = 0;
                    int end = s.length();
                    if (s.charAt(0) == '<') {
                        ++start;
                        if (s.length() > 1 && s.charAt(1) == '/') {
                            ++start;
                        }
                    }
                    if (s.charAt(s.length() - 1) == '>') {
                        --end;
                    }
                    this.tagName = s.subSequence(start, end).toString();
                    this.tagStartOffset = ts.offset();
                    cont = false;
                    break;
                }
                case PI_END: {
                    cont = false;
                    break;
                }
                case PI_START: {
                    this.tagStartOffset = ts.offset();
                    cont = false;
                    break;
                }
                case BLOCK_COMMENT: 
                case TEXT: {
                    break;
                }
                case ARGUMENT: {
                    if (this.type != Type.PROPERTY_VALUE || this.propertyName != null) break;
                    this.propertyName = t.text().toString();
                    break;
                }
                case PI_TARGET: {
                    this.piTarget = t.text().toString();
                }
            }
        }
        if (cont && this.type == null) {
            this.type = Type.ROOT;
        }
        if (this.type == Type.ROOT) {
            ts.move(this.caretOffset);
            cont = true;
            while (cont && ts.moveNext()) {
                t = ts.token();
                id = (XMLTokenId)t.id();
                switch (id) {
                    case BLOCK_COMMENT: {
                        break;
                    }
                    case CDATA_SECTION: 
                    case TEXT: {
                        break;
                    }
                    case PI_START: {
                        this.type = Type.INSTRUCTION_TARGET;
                        cont = false;
                        break;
                    }
                    case TAG: {
                        cont = false;
                    }
                }
            }
        }
    }

    private static boolean isClassTagName(CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) != '.' || i >= s.length() - 1) continue;
            char c = s.charAt(i + 1);
            return Character.isUpperCase(c);
        }
        return Character.isUpperCase(s.charAt(0));
    }

    public boolean isBlackListed(Element elem) {
        if (this.getCompilationInfo().getElements().isDeprecated(elem)) {
            return true;
        }
        if (this.typeWhiteList == null) {
            return false;
        }
        WhiteListQuery.Result r = this.typeWhiteList.check(ElementHandle.create((Element)elem), WhiteListQuery.Operation.USAGE);
        return r != null && !r.isAllowed();
    }

    private static CharSequence getUnprefixed(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ':') continue;
            return s.subSequence(i + 1, s.length());
        }
        return s;
    }

    public static enum Type {
        UNKNOWN,
        ROOT,
        INSTRUCTION_TARGET,
        INSTRUCTION_DATA,
        INSTRUCTION_END,
        CHILD_ELEMENT,
        BEAN,
        PROPERTY_ELEMENT,
        PROPERTY,
        PROPERTY_VALUE,
        PROPERTY_VALUE_CONTENT,
        VARIABLE,
        BINDING,
        BUNDLE_REF,
        RESOURCE_REF,
        HANDLER;

    }

    static class ArgumentInfo {
        private int argStart;
        private int valueStart;
        private int valueEnd;
        private String valueContent;

        public ArgumentInfo(int argStart, int valueStart, int valueEnd, String valContent) {
            this.argStart = argStart;
            this.valueStart = valueStart;
            this.valueEnd = valueEnd;
            this.valueContent = valContent;
        }
    }
}

