/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.jstesting;

import java.net.URL;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.jstesting.TestRunInfo;
import org.netbeans.modules.web.clientproject.jstesting.JsTestingProviderAccessor;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.clientproject.spi.jstesting.JsTestingProviderImplementation;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Parameters;

public final class JsTestingProvider {
    private final JsTestingProviderImplementation delegate;

    private JsTestingProvider(JsTestingProviderImplementation delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    @NonNull
    public String getIdentifier() {
        return this.delegate.getIdentifier();
    }

    @NonNull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public boolean isCoverageSupported(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.isCoverageSupported(project);
    }

    public void runTests(@NonNull Project project, @NonNull TestRunInfo runInfo) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"runInfo", (Object)runInfo);
        this.delegate.runTests(project, runInfo);
    }

    @CheckForNull
    public FileObject fromServer(@NonNull Project project, @NonNull URL serverUrl) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"serverUrl", (Object)serverUrl);
        return this.delegate.fromServer(project, serverUrl);
    }

    @CheckForNull
    public URL toServer(@NonNull Project project, @NonNull FileObject projectFile) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"projectFile", (Object)projectFile);
        return this.delegate.toServer(project, projectFile);
    }

    public void projectOpened(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.delegate.projectOpened(project);
    }

    public void projectClosed(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.delegate.projectClosed(project);
    }

    void notifyEnabled(@NonNull Project project, boolean enabled) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.delegate.notifyEnabled(project, enabled);
    }

    @CheckForNull
    NodeList<Node> createNodeList(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.createNodeList(project);
    }

    boolean isEnabled(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.isEnabled(project);
    }

    @CheckForNull
    CustomizerPanelImplementation createCustomizerPanel(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return this.delegate.createCustomizerPanel(project);
    }

    public String toString() {
        return "JsTestingProvider{identifier=" + this.delegate.getIdentifier() + '}';
    }

    static {
        JsTestingProviderAccessor.setDefault(new JsTestingProviderAccessor(){

            @Override
            public JsTestingProvider create(JsTestingProviderImplementation jsTestingProviderImplementation) {
                return new JsTestingProvider(jsTestingProviderImplementation);
            }

            @Override
            public boolean isEnabled(JsTestingProvider jsTestingProvider, Project project) {
                return jsTestingProvider.isEnabled(project);
            }

            @Override
            public void notifyEnabled(JsTestingProvider jsTestingProvider, Project project, boolean enabled) {
                jsTestingProvider.notifyEnabled(project, enabled);
            }

            @Override
            public NodeList<Node> createNodeList(JsTestingProvider jsTestingProvider, Project project) {
                return jsTestingProvider.createNodeList(project);
            }

            @Override
            public CustomizerPanelImplementation createCustomizerPanel(JsTestingProvider jsTestingProvider, Project project) {
                return jsTestingProvider.createCustomizerPanel(project);
            }
        });
    }
}

