/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis;

import java.util.Collection;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.jakarta.web.beans.CdiUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiEditorAwareJavaSourceTaskFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class BeansXmlFix
implements Fix {
    private Project myProject;
    private CdiEditorAwareJavaSourceTaskFactory myFactory;
    private FileObject myFileObject;

    BeansXmlFix(Project project, FileObject fileObject, CdiEditorAwareJavaSourceTaskFactory factory) {
        this.myProject = project;
        this.myFileObject = fileObject;
        this.myFactory = factory;
    }

    public String getText() {
        return NbBundle.getMessage(BeansXmlFix.class, (String)"MSG_HintCreateBeansXml");
    }

    public ChangeInfo implement() throws Exception {
        CdiUtil util = (CdiUtil)this.myProject.getLookup().lookup(CdiUtil.class);
        Collection<FileObject> infs = util == null ? CdiUtil.getBeansTargetFolder(this.myProject, true) : util.getBeansTargetFolder(true);
        for (FileObject inf : infs) {
            if (inf == null) continue;
            FileObject beansXml = inf.getFileObject("beans.xml");
            if (beansXml != null) {
                return null;
            }
            DDHelper.createBeansXml((Profile)Profile.JAVA_EE_6_FULL, (FileObject)inf, (String)"beans");
            CdiUtil logger = (CdiUtil)this.myProject.getLookup().lookup(CdiUtil.class);
            if (logger != null) {
                logger.log("USG_CDI_BEANS_FIX", BeansXmlFix.class, new Object[]{this.myProject.getClass().getName()}, true);
            }
            if (this.myFactory != null) {
                this.myFactory.restart(this.myFileObject);
            }
            return null;
        }
        return null;
    }
}

