/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.jakarta.web.beans.navigation.HTMLDocView;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DocumentationScrollPane
extends JScrollPane {
    private static final long serialVersionUID = -8672029782033541392L;
    private static final String BACK = "org/netbeans/modules/java/navigation/resources/back.png";
    private static final String FORWARD = "org/netbeans/modules/java/navigation/resources/forward.png";
    private static final String GOTO_SOURCE = "org/netbeans/modules/java/navigation/resources/open_source_in_editor.png";
    private static final String SHOW_WEB = "org/netbeans/modules/java/navigation/resources/open_in_external_browser.png";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    private static final int ACTION_JAVADOC_ESCAPE = 0;
    private static final int ACTION_JAVADOC_BACK = 1;
    private static final int ACTION_JAVADOC_FORWARD = 2;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 3;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 4;
    private JButton bBack;
    private JButton bForward;
    private JButton bGoToSource;
    private JButton bShowWeb;
    private HTMLDocView view;
    private List<ElementJavadoc> history = new ArrayList<ElementJavadoc>(5);
    private int currentHistoryIndex = -1;
    protected ElementJavadoc currentDocumentation = null;

    public DocumentationScrollPane(boolean keepDefaultBorder) {
        this.view = new HTMLDocView(this.getDefaultBackground());
        this.view.addHyperlinkListener(new HyperlinkAction());
        this.setViewportView(this.view);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationScrollPane.class, (String)"ACSN_DocScrollPane"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentationScrollPane.class, (String)"ACSD_DocScrollPane"));
        this.view.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationScrollPane.class, (String)"ACSN_DocScrollPane"));
        this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentationScrollPane.class, (String)"ACSD_DocScrollPane"));
        this.installTitleComponent();
        this.setFocusable(true);
        if (!keepDefaultBorder) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setData(ElementJavadoc doc) {
        this.setData(doc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData(ElementJavadoc doc, boolean clearHistory) {
        DocumentationScrollPane documentationScrollPane = this;
        synchronized (documentationScrollPane) {
            if (doc == null || clearHistory) {
                this.history = new ArrayList<ElementJavadoc>(5);
            }
        }
        this.setDocumentation(doc);
        if (null != doc) {
            this.addToHistory(doc);
        }
    }

    private ImageIcon resolveIcon(String res) {
        return ImageUtilities.loadImageIcon((String)res, (boolean)false);
    }

    private void installTitleComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlDkShadow")));
        toolbar.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridx = 0;
        gdc.gridy = 0;
        gdc.anchor = 17;
        ImageIcon icon = this.resolveIcon(BACK);
        if (icon != null) {
            this.bBack = new BrowserButton(icon);
            this.bBack.addMouseListener(new MouseEventListener(this.bBack));
            this.bBack.addActionListener(new DocPaneAction(1));
            this.bBack.setEnabled(false);
            this.bBack.setContentAreaFilled(false);
            this.bBack.setMargin(new Insets(0, 0, 0, 0));
            this.bBack.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_back_button"));
            toolbar.add((Component)this.bBack, gdc);
        }
        gdc.gridx = 1;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(FORWARD);
        if (icon != null) {
            this.bForward = new BrowserButton(icon);
            this.bForward.addMouseListener(new MouseEventListener(this.bForward));
            this.bForward.addActionListener(new DocPaneAction(2));
            this.bForward.setEnabled(false);
            this.bForward.setContentAreaFilled(false);
            this.bForward.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_forward_button"));
            this.bForward.setMargin(new Insets(0, 0, 0, 0));
            toolbar.add((Component)this.bForward, gdc);
        }
        gdc.gridx = 2;
        gdc.gridy = 0;
        gdc.anchor = 17;
        icon = this.resolveIcon(SHOW_WEB);
        if (icon != null) {
            this.bShowWeb = new BrowserButton(icon);
            this.bShowWeb.addMouseListener(new MouseEventListener(this.bShowWeb));
            this.bShowWeb.addActionListener(new DocPaneAction(3));
            this.bShowWeb.setEnabled(false);
            this.bShowWeb.setContentAreaFilled(false);
            this.bShowWeb.setMargin(new Insets(0, 0, 0, 0));
            this.bShowWeb.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_show_web_button"));
            toolbar.add((Component)this.bShowWeb, gdc);
        }
        gdc.gridx = 3;
        gdc.gridy = 0;
        gdc.weightx = 1.0;
        gdc.anchor = 17;
        icon = this.resolveIcon(GOTO_SOURCE);
        if (icon != null) {
            this.bGoToSource = new BrowserButton(icon);
            this.bGoToSource.addMouseListener(new MouseEventListener(this.bGoToSource));
            this.bGoToSource.addActionListener(new DocPaneAction(4));
            this.bGoToSource.setEnabled(false);
            this.bGoToSource.setContentAreaFilled(false);
            this.bGoToSource.setMargin(new Insets(0, 0, 0, 0));
            this.bGoToSource.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_goto_source_button"));
            toolbar.add((Component)this.bGoToSource, gdc);
        }
        this.setColumnHeaderView(toolbar);
        this.installKeybindings(this.view);
    }

    private synchronized void setDocumentation(ElementJavadoc doc) {
        this.currentDocumentation = doc;
        if (null != doc) {
            String text = this.currentDocumentation.getText();
            URL url = this.currentDocumentation.getURL();
            if (text != null) {
                Document document = this.view.getDocument();
                document.putProperty("stream", null);
                if (url != null && document instanceof HTMLDocument) {
                    ((HTMLDocument)document).setBase(url);
                }
                this.view.setContent(text, null);
            } else if (url != null) {
                try {
                    this.view.setPage(url);
                }
                catch (IOException ioe) {
                    StatusDisplayer.getDefault().setStatusText(ioe.toString());
                }
            }
            this.bShowWeb.setEnabled(url != null);
            this.bGoToSource.setEnabled(this.currentDocumentation.getGotoSourceAction() != null);
        } else {
            this.bShowWeb.setEnabled(false);
            this.bGoToSource.setEnabled(false);
            this.view.setContent("", null);
        }
    }

    private synchronized void addToHistory(ElementJavadoc doc) {
        int histSize = this.history.size();
        for (int i = this.currentHistoryIndex + 1; i < histSize; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(doc);
        this.currentHistoryIndex = this.history.size() - 1;
        if (this.currentHistoryIndex > 0) {
            this.bBack.setEnabled(true);
        }
        this.bForward.setEnabled(false);
    }

    private synchronized void backHistory() {
        if (this.currentHistoryIndex > 0 && this.currentHistoryIndex <= this.history.size()) {
            --this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == 0) {
                this.bBack.setEnabled(false);
            }
            this.bForward.setEnabled(true);
        }
    }

    private synchronized void forwardHistory() {
        if (this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == this.history.size() - 1) {
                this.bForward.setEnabled(false);
            }
            this.bBack.setEnabled(true);
        }
    }

    synchronized void clearHistory() {
        this.currentHistoryIndex = -1;
        this.history.clear();
        this.bBack.setEnabled(false);
        this.bForward.setEnabled(false);
    }

    private void openInExternalBrowser() {
        URL url;
        if (this.currentDocumentation != null && (url = this.currentDocumentation.getURL()) != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private void goToSource() {
        Action action = this.currentDocumentation.getGotoSourceAction();
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.currentDocumentation, 0, null));
        }
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey, JTextComponent component) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (component != null) {
            KeyStroke[] keys;
            Action a;
            EditorKit kit;
            TextUI componentUI = component.getUI();
            Keymap km = component.getKeymap();
            if (componentUI != null && km != null && (kit = componentUI.getEditorKit(component)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                ret = keys;
            }
        }
        return ret;
    }

    private void registerKeybinding(int action, String actionName, KeyStroke stroke, String editorActionName, JTextComponent component) {
        KeyStroke[] keys = this.findEditorKeys(editorActionName, stroke, component);
        for (int i = 0; i < keys.length; ++i) {
            this.view.getInputMap().put(keys[i], actionName);
        }
        this.view.getActionMap().put(actionName, new DocPaneAction(action));
    }

    private void installKeybindings(JTextComponent component) {
        this.registerKeybinding(1, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null, component);
        this.registerKeybinding(2, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null, component);
        this.registerKeybinding(3, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null, component);
        this.registerKeybinding(4, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null, component);
        this.mapWithShift(KeyStroke.getKeyStroke(38, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(40, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(33, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(34, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(36, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(35, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(39, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(37, 0));
    }

    private void mapWithShift(KeyStroke key) {
        InputMap inputMap = this.view.getInputMap(1);
        Object actionKey = inputMap.get(key);
        if (actionKey != null) {
            key = KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers() | 1);
            this.view.getInputMap().put(key, actionKey);
        }
    }

    private Color getDefaultBackground() {
        Color bgColor = new JEditorPane().getBackground();
        bgColor = new Color(Math.max(bgColor.getRed() - 8, 0), Math.max(bgColor.getGreen() - 8, 0), bgColor.getBlue());
        return bgColor;
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        private HyperlinkAction() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            ElementJavadoc doc;
            String desc;
            if (e != null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (desc = e.getDescription()) != null && (doc = DocumentationScrollPane.this.currentDocumentation.resolveLink(desc)) != null) {
                DocumentationScrollPane.this.setData(doc, false);
            }
        }
    }

    private static class BrowserButton
    extends JButton {
        private static final long serialVersionUID = 3572084819036272122L;

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
        }
    }

    private static class MouseEventListener
    extends MouseAdapter {
        private JButton button;

        MouseEventListener(JButton button) {
            this.button = button;
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (this.button.isEnabled()) {
                this.button.setContentAreaFilled(true);
                this.button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            this.button.setContentAreaFilled(false);
            this.button.setBorderPainted(false);
        }
    }

    private class DocPaneAction
    extends AbstractAction {
        private static final long serialVersionUID = -5754757066129335109L;
        private int action;

        private DocPaneAction(int action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 1: {
                    DocumentationScrollPane.this.backHistory();
                    break;
                }
                case 2: {
                    DocumentationScrollPane.this.forwardHistory();
                    break;
                }
                case 3: {
                    DocumentationScrollPane.this.openInExternalBrowser();
                    break;
                }
                case 4: {
                    DocumentationScrollPane.this.goToSource();
                }
            }
        }
    }
}

