/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation.actions;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.ObserversModel;
import org.netbeans.modules.jakarta.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.jakarta.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.jakarta.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class ObserversActionStrategy
implements ModelActionStrategy {
    ObserversActionStrategy() {
    }

    @Override
    public boolean isApplicable(ModelActionStrategy.InspectActionId id) {
        return id == ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT || id == ModelActionStrategy.InspectActionId.OBSERVERS_CONTEXT;
    }

    @Override
    public boolean isApplicable(WebBeansModel model, Object[] context) {
        VariableElement var = WebBeansActionHelper.findVariable(model, context);
        if (var == null) {
            return false;
        }
        if (context[2] == ModelActionStrategy.InspectActionId.OBSERVERS_CONTEXT && !model.isEventInjectionPoint(var)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotEventInjectionPoint"), 700);
            return false;
        }
        return model.isEventInjectionPoint(var);
    }

    @Override
    public void invokeModelAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] subject, JTextComponent component, FileObject fileObject) {
        List<ExecutableElement> observers;
        VariableElement var = WebBeansActionHelper.findVariable(model, subject);
        List<ExecutableElement> list = observers = var == null ? null : model.getObservers(var, null);
        if (var == null || observers.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ObserversNotFound"), 700);
            return;
        }
        CompilationController controller = model.getCompilationController();
        final ObserversModel uiModel = new ObserversModel(observers, controller, metaModel);
        final String name = var.getSimpleName().toString();
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showObserversDialog(observers, metaModel, model, subject, uiModel, name);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showObserversDialog(observers, (MetadataModel<WebBeansModel>)metaModel, null, subject, uiModel, name);
                }
            });
        }
    }
}

