/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.RenamePanel;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class RenameAction
extends CookieAction {
    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance instance = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (instance == null || instance.isRemoveForbidden()) continue;
            RenameAction.showRenameDialog(instance);
        }
    }

    protected boolean enable(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance instance = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (instance != null && !instance.isRemoveForbidden()) continue;
            return false;
        }
        return true;
    }

    protected Class[] cookieClasses() {
        return new Class[]{ServerInstance.class};
    }

    protected int mode() {
        return 4;
    }

    public String getName() {
        return Bundle.LBL_Rename();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void showRenameDialog(final ServerInstance instance) {
        final RenamePanel panel = new RenamePanel(instance.getDisplayName());
        final JButton confirm = new JButton(Bundle.LBL_ConfirmButton());
        JButton cancel = new JButton(Bundle.LBL_CancelButton());
        confirm.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_ConfirmButton());
        cancel.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_CancelButton());
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                confirm.setEnabled(panel.isPanelValid());
            }
        });
        confirm.setEnabled(panel.isPanelValid());
        final Dialog[] dialog = new Dialog[1];
        DialogDescriptor dd = new DialogDescriptor((Object)RenameAction.wrapPanel(panel), Bundle.MSG_RenameInstanceTitle(), true, new Object[]{confirm, cancel}, (Object)confirm, 0, null, new ActionListener(){
            private boolean operationRunning;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.operationRunning) {
                    return;
                }
                if (dialog[0] instanceof JDialog) {
                    ((JDialog)dialog[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialog[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (e.getSource() == confirm) {
                    instance.getInstanceProperties().setProperty("displayName", panel.getServerName());
                }
                dialog[0].setVisible(false);
            }
        });
        dd.setClosingOptions(new Object[0]);
        dialog[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialog[0].setVisible(true);
        dialog[0].dispose();
        dialog[0] = null;
    }

    private static JComponent wrapPanel(JComponent component) {
        component.setBorder(new EmptyBorder(12, 12, 12, 12));
        return component;
    }
}

