/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.installer.ui;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class LicenseComboBoxModel
implements ComboBoxModel {
    private List<ListDataListener> listeners;
    private List<String> names;
    private List<String> types;
    private String selectedItem;
    private boolean selectedItemFromList;
    private Project suiteProject;

    public LicenseComboBoxModel(Project suiteProject, List<String> names, List<String> types) {
        this.suiteProject = suiteProject;
        this.names = new LinkedList<String>();
        this.names.addAll(names);
        this.types = new LinkedList<String>();
        this.types.addAll(types);
        this.listeners = new LinkedList<ListDataListener>();
        if (names.size() > 0) {
            this.selectedItem = names.get(0);
            this.selectedItemFromList = true;
        } else {
            this.selectedItem = "";
            this.selectedItemFromList = false;
        }
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName() {
        if (this.selectedItemFromList) {
            return this.names.get(this.names.indexOf(this.selectedItem));
        }
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object item) {
        String oldSelectedItem = this.selectedItem;
        this.selectedItem = (String)item;
        if (this.names.indexOf(item) != -1) {
            if (this.types.get(this.names.indexOf(this.selectedItem)).equals("custom")) {
                File home = FileUtil.toFile((FileObject)this.suiteProject.getProjectDirectory());
                File licenseFile = new FileChooserBuilder("installer-license-dir").setTitle(NbBundle.getMessage(LicenseComboBoxModel.class, (String)"InstallerPanel_License.FileChooser.Title")).setDefaultWorkingDirectory(home).setFilesOnly(true).showOpenDialog();
                if (licenseFile != null) {
                    this.names.add(licenseFile.getAbsolutePath());
                    this.types.add("file");
                    this.selectedItem = this.names.get(this.names.size() - 1);
                } else {
                    this.selectedItem = oldSelectedItem;
                }
            }
            this.selectedItemFromList = true;
        } else {
            this.selectedItemFromList = false;
        }
        this.fireContentsChanged(-1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.names.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener listener) {
        List<ListDataListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener listener) {
        List<ListDataListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContentsChanged(int index) {
        ListDataListener[] clone;
        List<ListDataListener> list = this.listeners;
        synchronized (list) {
            clone = this.listeners.toArray(new ListDataListener[0]);
        }
        ListDataEvent event = new ListDataEvent(this, 0, index, index);
        for (ListDataListener listener : clone) {
            listener.contentsChanged(event);
        }
    }
}

