/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.lsp.client.options.Bundle;
import org.netbeans.modules.lsp.client.options.LanguageDescriptionPanel;
import org.netbeans.modules.lsp.client.options.LanguageServersOptionsPanelController;
import org.netbeans.modules.lsp.client.options.LanguageStorage;
import org.netbeans.modules.lsp.client.options.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class LanguageServersPanel
extends JPanel {
    private static final LanguageStorage.LanguageDescription PROTOTYPE = new LanguageStorage.LanguageDescription(null, null, null, null, "MMMMMMMMMMMMMMMMM", null);
    private final LanguageServersOptionsPanelController controller;
    private final DefaultListModel<LanguageStorage.LanguageDescription> languages;
    private final Set<String> usedIds;
    private JButton add;
    private JButton edit;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList<LanguageStorage.LanguageDescription> languagesList;
    private JButton remove;

    LanguageServersPanel(LanguageServersOptionsPanelController controller) {
        this.controller = controller;
        this.languages = new DefaultListModel();
        this.usedIds = new HashSet<String>();
        this.initComponents();
        this.languagesList.addListSelectionListener(evt -> this.setEnableDisable());
        this.setEnableDisable();
    }

    private void setEnableDisable() {
        this.edit.setEnabled(this.languagesList.getSelectedIndex() != -1);
        this.remove.setEnabled(this.languagesList.getSelectedIndex() != -1);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.languagesList = new JList();
        this.add = new JButton();
        this.edit = new JButton();
        this.remove = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LanguageServersPanel.class, (String)"LanguageServersPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.languagesList.setModel(this.languages);
        this.languagesList.setCellRenderer(new ListRenderer());
        this.languagesList.setPrototypeCellValue(PROTOTYPE);
        this.jScrollPane1.setViewportView(this.languagesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.add, (String)NbBundle.getMessage(LanguageServersPanel.class, (String)"LanguageServersPanel.add.text"));
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LanguageServersPanel.this.addActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.add, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getMessage(LanguageServersPanel.class, (String)"LanguageServersPanel.edit.text"));
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LanguageServersPanel.this.editActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.edit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(LanguageServersPanel.class, (String)"LanguageServersPanel.remove.text"));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LanguageServersPanel.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.remove, gridBagConstraints);
    }

    private void addActionPerformed(ActionEvent evt) {
        LanguageStorage.LanguageDescription desc = this.openCustomizeDialog(null, Bundle.CAP_AddDescription());
        if (desc != null) {
            this.languages.addElement(desc);
            this.controller.changed();
        }
    }

    private void editActionPerformed(ActionEvent evt) {
        LanguageStorage.LanguageDescription desc = this.openCustomizeDialog(this.languagesList.getSelectedValue(), Bundle.CAP_AddDescription());
        if (desc != null) {
            int pos = this.languagesList.getSelectedIndex();
            this.languages.remove(pos);
            this.languages.add(pos, desc);
            this.controller.changed();
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        this.languages.remove(this.languagesList.getSelectedIndex());
        this.controller.changed();
    }

    private LanguageStorage.LanguageDescription openCustomizeDialog(LanguageStorage.LanguageDescription desc, String title) {
        LanguageDescriptionPanel panel = new LanguageDescriptionPanel(desc, this.usedIds);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            return panel.getDescription();
        }
        return null;
    }

    void load() {
        this.languages.clear();
        this.usedIds.clear();
        LanguageStorage.load().stream().forEach(desc -> {
            this.languages.addElement((LanguageStorage.LanguageDescription)desc);
            this.usedIds.add(desc.id);
        });
    }

    void store() {
        ArrayList<LanguageStorage.LanguageDescription> descriptions = new ArrayList<LanguageStorage.LanguageDescription>();
        for (int i = 0; i < this.languages.size(); ++i) {
            descriptions.add(this.languages.elementAt(i));
        }
        LanguageStorage.store(descriptions);
    }

    boolean valid() {
        return true;
    }

    private static final class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = null;
            if (value instanceof LanguageStorage.LanguageDescription) {
                LanguageStorage.LanguageDescription ld = (LanguageStorage.LanguageDescription)value;
                value = ld.name != null && !ld.name.isEmpty() ? ld.name : Bundle.TXT_Files(ld.extensions);
                icon = ImageUtilities.image2Icon((Image)Utils.loadIcon(ld.icon != null ? FileUtil.toFileObject((File)new File(ld.icon)) : null, 1));
            }
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return this;
        }
    }
}

