/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.nodes.actions.ResourceType;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookie;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UndeployModuleCookieImpl
implements UndeployModuleCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JBoss undeploy", 1);
    private final String fileName;
    private final Lookup lookup;
    private final ResourceType type;
    private boolean isRunning;

    public UndeployModuleCookieImpl(String fileName, Lookup lookup) {
        this(fileName, ResourceType.EJB, lookup);
    }

    public UndeployModuleCookieImpl(String fileName, ResourceType type, Lookup lookup) {
        this.lookup = lookup;
        this.fileName = fileName;
        this.type = type;
        this.isRunning = false;
    }

    @Override
    public RequestProcessor.Task undeploy() {
        final WildflyDeploymentManager dm = (WildflyDeploymentManager)this.lookup.lookup(WildflyDeploymentManager.class);
        String nameWoExt = this.fileName.indexOf(46) > 0 ? this.fileName.substring(0, this.fileName.lastIndexOf(46)) : this.fileName;
        final ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(UndeployModuleCookieImpl.class, (String)"LBL_UndeployProgress", (Object)nameWoExt));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UndeployModuleCookieImpl.this.isRunning = true;
                try {
                    switch (UndeployModuleCookieImpl.this.type) {
                        case EJB: 
                        case EAR: 
                        case CAR: 
                        case RAR: 
                        case WAR: {
                            dm.getClient().undeploy(UndeployModuleCookieImpl.this.fileName);
                            break;
                        }
                        case QUEUE: {
                            dm.getClient().removeMessageDestination(new WildflyMessageDestination(UndeployModuleCookieImpl.this.fileName, MessageDestination.Type.QUEUE));
                            break;
                        }
                        case TOPIC: {
                            dm.getClient().removeMessageDestination(new WildflyMessageDestination(UndeployModuleCookieImpl.this.fileName, MessageDestination.Type.TOPIC));
                            break;
                        }
                        case DATASOURCE: {
                            dm.getClient().removeDatasource(UndeployModuleCookieImpl.this.fileName);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(UndeployModuleCookieImpl.class.getName()).log(Level.INFO, null, ex);
                }
                handle.finish();
                UndeployModuleCookieImpl.this.isRunning = false;
            }
        };
        handle.start();
        return PROCESSOR.post(r);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

