/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandSetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;

public class EnableComet
implements Runnable {
    private static final Logger LOGGER = GlassFishLogger.get(CommonServerSupport.class);
    private final GlassfishInstance instance;

    public EnableComet(GlassfishInstance instance) {
        this.instance = instance;
    }

    @Override
    public void run() {
        String propertiesPattern = "*.comet-support-enabled";
        try {
            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)propertiesPattern, (long)10000L);
            if (result.getState() == TaskState.COMPLETED) {
                String newValue = this.instance.getProperty("v3.grizzly.cometSupport");
                if (null == newValue || newValue.trim().length() < 1) {
                    newValue = "false";
                }
                for (Map.Entry entry : result.getValue().entrySet()) {
                    String key = (String)entry.getKey();
                    if (null == key || key.contains("admin-listener")) continue;
                    CommandSetProperty command = GlassfishInstanceProvider.getProvider().getCommandFactory().getSetPropertyCommand(key, newValue);
                    ResultString resultString = CommandSetProperty.setProperty((GlassFishServer)this.instance, (CommandSetProperty)command, (long)10000L);
                }
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not get comment-support-enabeld value.", gfie);
        }
    }
}

