/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BackendSetIpCollection;
import com.oracle.bmc.devops.model.CreateDeployStageDetails;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import com.oracle.bmc.devops.model.DeployStageRollbackPolicy;
import com.oracle.bmc.devops.model.LoadBalancerConfig;
import com.oracle.bmc.devops.model.LoadBalancerTrafficShiftDeployStage;
import com.oracle.bmc.devops.model.LoadBalancerTrafficShiftRolloutPolicy;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateLoadBalancerTrafficShiftDeployStageDetails
extends CreateDeployStageDetails {
    @JsonProperty(value="blueBackendIps")
    private final BackendSetIpCollection blueBackendIps;
    @JsonProperty(value="greenBackendIps")
    private final BackendSetIpCollection greenBackendIps;
    @JsonProperty(value="trafficShiftTarget")
    private final LoadBalancerTrafficShiftDeployStage.TrafficShiftTarget trafficShiftTarget;
    @JsonProperty(value="rolloutPolicy")
    private final LoadBalancerTrafficShiftRolloutPolicy rolloutPolicy;
    @JsonProperty(value="loadBalancerConfig")
    private final LoadBalancerConfig loadBalancerConfig;
    @JsonProperty(value="rollbackPolicy")
    private final DeployStageRollbackPolicy rollbackPolicy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateLoadBalancerTrafficShiftDeployStageDetails(String description, String displayName, String deployPipelineId, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, BackendSetIpCollection blueBackendIps, BackendSetIpCollection greenBackendIps, LoadBalancerTrafficShiftDeployStage.TrafficShiftTarget trafficShiftTarget, LoadBalancerTrafficShiftRolloutPolicy rolloutPolicy, LoadBalancerConfig loadBalancerConfig, DeployStageRollbackPolicy rollbackPolicy) {
        super(description, displayName, deployPipelineId, deployStagePredecessorCollection, freeformTags, definedTags);
        this.blueBackendIps = blueBackendIps;
        this.greenBackendIps = greenBackendIps;
        this.trafficShiftTarget = trafficShiftTarget;
        this.rolloutPolicy = rolloutPolicy;
        this.loadBalancerConfig = loadBalancerConfig;
        this.rollbackPolicy = rollbackPolicy;
    }

    public BackendSetIpCollection getBlueBackendIps() {
        return this.blueBackendIps;
    }

    public BackendSetIpCollection getGreenBackendIps() {
        return this.greenBackendIps;
    }

    public LoadBalancerTrafficShiftDeployStage.TrafficShiftTarget getTrafficShiftTarget() {
        return this.trafficShiftTarget;
    }

    public LoadBalancerTrafficShiftRolloutPolicy getRolloutPolicy() {
        return this.rolloutPolicy;
    }

    public LoadBalancerConfig getLoadBalancerConfig() {
        return this.loadBalancerConfig;
    }

    public DeployStageRollbackPolicy getRollbackPolicy() {
        return this.rollbackPolicy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateLoadBalancerTrafficShiftDeployStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", blueBackendIps=").append(String.valueOf((Object)this.blueBackendIps));
        sb.append(", greenBackendIps=").append(String.valueOf((Object)this.greenBackendIps));
        sb.append(", trafficShiftTarget=").append(String.valueOf((Object)this.trafficShiftTarget));
        sb.append(", rolloutPolicy=").append(String.valueOf((Object)this.rolloutPolicy));
        sb.append(", loadBalancerConfig=").append(String.valueOf((Object)this.loadBalancerConfig));
        sb.append(", rollbackPolicy=").append(String.valueOf((Object)this.rollbackPolicy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateLoadBalancerTrafficShiftDeployStageDetails)) {
            return false;
        }
        CreateLoadBalancerTrafficShiftDeployStageDetails other = (CreateLoadBalancerTrafficShiftDeployStageDetails)((Object)o);
        return Objects.equals((Object)this.blueBackendIps, (Object)other.blueBackendIps) && Objects.equals((Object)this.greenBackendIps, (Object)other.greenBackendIps) && Objects.equals((Object)this.trafficShiftTarget, (Object)other.trafficShiftTarget) && Objects.equals((Object)this.rolloutPolicy, (Object)other.rolloutPolicy) && Objects.equals((Object)this.loadBalancerConfig, (Object)other.loadBalancerConfig) && Objects.equals((Object)this.rollbackPolicy, (Object)other.rollbackPolicy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blueBackendIps == null ? 43 : this.blueBackendIps.hashCode());
        result = result * 59 + (this.greenBackendIps == null ? 43 : this.greenBackendIps.hashCode());
        result = result * 59 + (this.trafficShiftTarget == null ? 43 : this.trafficShiftTarget.hashCode());
        result = result * 59 + (this.rolloutPolicy == null ? 43 : this.rolloutPolicy.hashCode());
        result = result * 59 + (this.loadBalancerConfig == null ? 43 : this.loadBalancerConfig.hashCode());
        result = result * 59 + (this.rollbackPolicy == null ? 43 : this.rollbackPolicy.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deployPipelineId")
        private String deployPipelineId;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="blueBackendIps")
        private BackendSetIpCollection blueBackendIps;
        @JsonProperty(value="greenBackendIps")
        private BackendSetIpCollection greenBackendIps;
        @JsonProperty(value="trafficShiftTarget")
        private LoadBalancerTrafficShiftDeployStage.TrafficShiftTarget trafficShiftTarget;
        @JsonProperty(value="rolloutPolicy")
        private LoadBalancerTrafficShiftRolloutPolicy rolloutPolicy;
        @JsonProperty(value="loadBalancerConfig")
        private LoadBalancerConfig loadBalancerConfig;
        @JsonProperty(value="rollbackPolicy")
        private DeployStageRollbackPolicy rollbackPolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deployPipelineId(String deployPipelineId) {
            this.deployPipelineId = deployPipelineId;
            this.__explicitlySet__.add("deployPipelineId");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder blueBackendIps(BackendSetIpCollection blueBackendIps) {
            this.blueBackendIps = blueBackendIps;
            this.__explicitlySet__.add("blueBackendIps");
            return this;
        }

        public Builder greenBackendIps(BackendSetIpCollection greenBackendIps) {
            this.greenBackendIps = greenBackendIps;
            this.__explicitlySet__.add("greenBackendIps");
            return this;
        }

        public Builder trafficShiftTarget(LoadBalancerTrafficShiftDeployStage.TrafficShiftTarget trafficShiftTarget) {
            this.trafficShiftTarget = trafficShiftTarget;
            this.__explicitlySet__.add("trafficShiftTarget");
            return this;
        }

        public Builder rolloutPolicy(LoadBalancerTrafficShiftRolloutPolicy rolloutPolicy) {
            this.rolloutPolicy = rolloutPolicy;
            this.__explicitlySet__.add("rolloutPolicy");
            return this;
        }

        public Builder loadBalancerConfig(LoadBalancerConfig loadBalancerConfig) {
            this.loadBalancerConfig = loadBalancerConfig;
            this.__explicitlySet__.add("loadBalancerConfig");
            return this;
        }

        public Builder rollbackPolicy(DeployStageRollbackPolicy rollbackPolicy) {
            this.rollbackPolicy = rollbackPolicy;
            this.__explicitlySet__.add("rollbackPolicy");
            return this;
        }

        public CreateLoadBalancerTrafficShiftDeployStageDetails build() {
            CreateLoadBalancerTrafficShiftDeployStageDetails model = new CreateLoadBalancerTrafficShiftDeployStageDetails(this.description, this.displayName, this.deployPipelineId, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.blueBackendIps, this.greenBackendIps, this.trafficShiftTarget, this.rolloutPolicy, this.loadBalancerConfig, this.rollbackPolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateLoadBalancerTrafficShiftDeployStageDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deployPipelineId")) {
                this.deployPipelineId(model.getDeployPipelineId());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("blueBackendIps")) {
                this.blueBackendIps(model.getBlueBackendIps());
            }
            if (model.wasPropertyExplicitlySet("greenBackendIps")) {
                this.greenBackendIps(model.getGreenBackendIps());
            }
            if (model.wasPropertyExplicitlySet("trafficShiftTarget")) {
                this.trafficShiftTarget(model.getTrafficShiftTarget());
            }
            if (model.wasPropertyExplicitlySet("rolloutPolicy")) {
                this.rolloutPolicy(model.getRolloutPolicy());
            }
            if (model.wasPropertyExplicitlySet("loadBalancerConfig")) {
                this.loadBalancerConfig(model.getLoadBalancerConfig());
            }
            if (model.wasPropertyExplicitlySet("rollbackPolicy")) {
                this.rollbackPolicy(model.getRollbackPolicy());
            }
            return this;
        }
    }
}

