/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.NavigationHistory;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.lib2.ComponentUtils;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.search.DocumentFinder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class EditorFindSupport {
    private static final Logger LOG = Logger.getLogger(EditorFindSupport.class.getName());
    public static final String FIND_WHAT = "find-what";
    public static final String FIND_REPLACE_WITH = "find-replace-with";
    public static final String FIND_HIGHLIGHT_SEARCH = "find-highlight-search";
    public static final String FIND_INC_SEARCH = "find-inc-search";
    public static final String FIND_INC_SEARCH_DELAY = "find-inc-search-delay";
    public static final String FIND_BACKWARD_SEARCH = "find-backward-search";
    public static final String FIND_WRAP_SEARCH = "find-wrap-search";
    public static final String FIND_MATCH_CASE = "find-match-case";
    public static final String FIND_SMART_CASE = "find-smart-case";
    public static final String FIND_PRESERVE_CASE = "find-preserve-case";
    public static final String FIND_WHOLE_WORDS = "find-whole-words";
    public static final String FIND_REG_EXP = "find-reg-exp";
    public static final String FIND_HISTORY = "find-history";
    public static final String FIND_HISTORY_SIZE = "find-history-size";
    public static final String FIND_BLOCK_SEARCH = "find-block-search";
    public static final String FIND_BLOCK_SEARCH_START = "find-block-search-start";
    public static final String FIND_BLOCK_SEARCH_END = "find-block-search-end";
    public static final String ADD_MULTICARET = "add-multi-caret";
    private static final String FOUND_LOCALE = "find-found";
    private static final String NOT_FOUND_LOCALE = "find-not-found";
    private static final String WRAP_START_LOCALE = "find-wrap-start";
    private static final String WRAP_END_LOCALE = "find-wrap-end";
    private static final String WRAP_BLOCK_START_LOCALE = "find-block-wrap-start";
    private static final String WRAP_BLOCK_END_LOCALE = "find-block-wrap-end";
    private static final String ITEMS_REPLACED_LOCALE = "find-items-replaced";
    public static final String REVERT_MAP = "revert-map";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String REPLACE_HISTORY_PROP = "replace-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    public static final String REPLACE_HISTORY_CHANGED_PROP = "replace-history-changed-prop";
    private static final int IMPORTANCE_FIND_OR_REPLACE = 800;
    private static EditorFindSupport findSupport;
    private Map<String, Object> findProps;
    private WeakReference<JTextComponent> focusedTextComponent;
    private final RequestProcessor executor = new RequestProcessor(EditorFindSupport.class.getName(), 1);
    private final WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> comp2layer = new WeakHashMap();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private SPW lastSelected;
    private List<SPW> historyList = new ArrayList<SPW>();
    private List<RP> replaceList = new ArrayList<RP>();
    private String cachekey = "";
    private int[] cacheContent = new int[0];
    private static final int TIME_LIMIT = 2;
    private int[] findMatches = null;
    private DocumentFinder.FindReplaceResult currentResult = null;

    private EditorFindSupport() {
    }

    public static synchronized EditorFindSupport getInstance() {
        if (findSupport == null) {
            findSupport = new EditorFindSupport();
        }
        return findSupport;
    }

    public Map<String, Object> createDefaultFindProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(FIND_WHAT, null);
        props.put(FIND_REPLACE_WITH, null);
        props.put(FIND_HIGHLIGHT_SEARCH, Boolean.TRUE);
        props.put(FIND_INC_SEARCH, Boolean.TRUE);
        props.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
        props.put(FIND_WRAP_SEARCH, Boolean.TRUE);
        props.put(FIND_MATCH_CASE, Boolean.FALSE);
        props.put(FIND_SMART_CASE, Boolean.FALSE);
        props.put(FIND_WHOLE_WORDS, Boolean.FALSE);
        props.put(FIND_REG_EXP, Boolean.FALSE);
        props.put(FIND_HISTORY, 30);
        props.put(FIND_PRESERVE_CASE, Boolean.FALSE);
        props.put(ADD_MULTICARET, Boolean.FALSE);
        return props;
    }

    private int getBlockEndOffset() {
        Position pos = (Position)this.getFindProperties().get(FIND_BLOCK_SEARCH_END);
        return pos != null ? pos.getOffset() : -1;
    }

    public Map<String, Object> getFindProperties() {
        if (this.findProps == null) {
            this.findProps = this.createDefaultFindProperties();
        }
        return this.findProps;
    }

    public Object getFindProperty(String name) {
        return this.getFindProperties().get(name);
    }

    private Map<String, Object> getValidFindProperties(Map<String, Object> props) {
        return props != null ? props : this.getFindProperties();
    }

    public synchronized int[] getBlocks(final int[] blocks, final Document doc, int startOffset, int endOffset) throws BadLocationException {
        final Map<String, Object> props = this.getValidFindProperties(null);
        String newCacheKey = this.calculateCacheKey(doc, startOffset, endOffset, props);
        if (this.cachekey.equals(newCacheKey)) {
            return Arrays.copyOf(this.cacheContent, this.cacheContent.length);
        }
        boolean blockSearch = Boolean.TRUE.equals(props.get(FIND_BLOCK_SEARCH));
        Position blockSearchStartPos = (Position)props.get(FIND_BLOCK_SEARCH_START);
        Position blockSearchEndPos = (Position)props.get(FIND_BLOCK_SEARCH_END);
        if (blockSearch && blockSearchStartPos != null && blockSearchEndPos != null) {
            if (endOffset >= blockSearchStartPos.getOffset() && startOffset <= blockSearchEndPos.getOffset()) {
                startOffset = Math.max(blockSearchStartPos.getOffset(), startOffset);
                endOffset = Math.min(blockSearchEndPos.getOffset(), endOffset);
            } else {
                return blocks;
            }
        }
        final int so = startOffset;
        final int eo = endOffset;
        this.currentResult = null;
        try {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditorFindSupport.this.currentResult = DocumentFinder.findBlocks(doc, so, eo, props, blocks);
                        EditorFindSupport.access$102(EditorFindSupport.this, EditorFindSupport.this.currentResult.getFoundPositions());
                    }
                    catch (BadLocationException ble) {
                        EditorFindSupport.access$102(EditorFindSupport.this, Arrays.copyOf(blocks, blocks.length));
                        LOG.log(Level.INFO, ble.getMessage(), ble);
                    }
                }
            }).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            this.cacheContent = Arrays.copyOf(blocks, blocks.length);
            Utilities.setStatusBoldText((JTextComponent)this.getFocusedTextComponent(), (String)NbBundle.getMessage(EditorFindSupport.class, (String)"slow-search"));
            LOG.log(Level.INFO, ex.getMessage(), ex);
        }
        if (this.currentResult != null && this.currentResult.hasErrorMsg()) {
            Utilities.setStatusBoldText((JTextComponent)this.getFocusedTextComponent(), (String)this.currentResult.getErrorMsg());
        }
        this.cachekey = newCacheKey;
        return Arrays.copyOf(this.cacheContent, this.cacheContent.length);
    }

    public void putFindProperty(String name, Object newValue) {
        Object oldValue = this.getFindProperty(name);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null) {
            this.getFindProperties().put(name, newValue);
        } else {
            this.getFindProperties().remove(name);
        }
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void putFindProperties(Map<String, Object> propsToAdd) {
        if (this.getFindProperties() != propsToAdd) {
            this.getFindProperties().putAll(propsToAdd);
        }
        if (propsToAdd.get(FIND_WHAT) != null) {
            this.firePropertyChange(null, null, null);
        }
    }

    public void setFocusedTextComponent(JTextComponent component) {
        this.focusedTextComponent = new WeakReference<JTextComponent>(component);
        this.firePropertyChange(null, null, null);
    }

    public JTextComponent getFocusedTextComponent() {
        JTextComponent jc = this.focusedTextComponent != null ? (JTextComponent)this.focusedTextComponent.get() : null;
        return jc != null ? jc : EditorRegistry.lastFocusedComponent();
    }

    public void setBlockSearchHighlight(int startSelection, int endSelection) {
        BlockHighlighting layer;
        JTextComponent comp = this.getFocusedTextComponent();
        BlockHighlighting blockHighlighting = layer = comp == null ? null : this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/BLOCK_SEARCH");
        if (layer != null) {
            if (startSelection >= 0 && endSelection >= 0 && startSelection < endSelection) {
                layer.highlightBlock(startSelection, endSelection, "block-search", true, true);
            } else {
                layer.highlightBlock(-1, -1, "block-search", true, true);
            }
        }
    }

    public boolean incSearch(Map<String, Object> props, int caretPos) {
        Boolean b = (Boolean)(props = this.getValidFindProperties(props)).get(FIND_INC_SEARCH);
        if (b != null && b.booleanValue()) {
            JTextComponent comp = this.getFocusedTextComponent();
            if (comp != null) {
                int pos;
                b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
                boolean back = b != null && b != false;
                b = (Boolean)props.get(FIND_BLOCK_SEARCH);
                boolean blockSearch = b != null && b != false;
                Position blockStartPos = (Position)props.get(FIND_BLOCK_SEARCH_START);
                int blockSearchStartOffset = blockStartPos != null ? blockStartPos.getOffset() : -1;
                Position endPos = (Position)props.get(FIND_BLOCK_SEARCH_END);
                int blockSearchEndOffset = endPos != null ? endPos.getOffset() : -1;
                int len = 0;
                try {
                    int end;
                    int start = blockSearch && blockSearchStartOffset > -1 ? blockSearchStartOffset : 0;
                    int n = end = blockSearch && blockSearchEndOffset > 0 ? blockSearchEndOffset : -1;
                    if (start > 0 && end == -1) {
                        return false;
                    }
                    int[] findRet = this.findInBlock(comp, caretPos, start, end, props, false);
                    if (findRet == null) {
                        this.incSearchReset();
                        return false;
                    }
                    pos = findRet[0];
                    len = findRet.length > 1 ? findRet[1] - pos : 0;
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    return false;
                }
                if (pos >= 0) {
                    BlockHighlighting layer = this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
                    if (len > 0) {
                        Preferences prefs;
                        if (comp.getSelectionEnd() > comp.getSelectionStart()) {
                            comp.select(caretPos, caretPos);
                        }
                        if (layer != null) {
                            layer.highlightBlock(pos, pos + len, blockSearch ? "inc-search" : "selection", false, false);
                        }
                        if ((prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class)).get("editor-search-type", "default").equals("closing")) {
                            this.ensureVisible(comp, pos, pos);
                        } else {
                            this.selectText(comp, pos, pos + len, back);
                        }
                        return true;
                    }
                }
            }
        } else {
            this.incSearchReset();
        }
        return false;
    }

    public void incSearchReset() {
        BlockHighlighting layer;
        JTextComponent comp = this.getFocusedTextComponent();
        BlockHighlighting blockHighlighting = layer = comp == null ? null : this.findLayer(comp, "org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH");
        if (layer != null) {
            layer.highlightBlock(-1, -1, null, false, false);
        }
    }

    private boolean isBackSearch(Map<String, Object> props, boolean oppositeDir) {
        boolean back;
        Boolean b = (Boolean)props.get(FIND_BACKWARD_SEARCH);
        boolean bl = back = b != null && b != false;
        if (oppositeDir) {
            back = !back;
        }
        return back;
    }

    private void addCaretSelectText(JTextComponent c, int start, int end, boolean back) {
        Caret eCaret = c.getCaret();
        this.ensureVisible(c, start, end);
        if (eCaret instanceof EditorCaret) {
            EditorCaret caret = (EditorCaret)eCaret;
            try {
                caret.addCaret(c.getDocument().createPosition(end), Position.Bias.Forward, c.getDocument().createPosition(start), Position.Bias.Forward);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void selectText(JTextComponent c, int start, int end, boolean back) {
        Caret caret = c.getCaret();
        this.ensureVisible(c, start, end);
        if (back) {
            caret.setDot(end);
            caret.moveDot(start);
        } else {
            caret.setDot(start);
            caret.moveDot(end);
        }
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset) {
        this.ensureVisible(c, startOffset, endOffset, new Insets(10, 10, 10, 10));
    }

    private void ensureVisible(JTextComponent c, int startOffset, int endOffset, Insets extraInsets) {
        try {
            Rectangle startBounds = c.modelToView(startOffset);
            Rectangle endBounds = c.modelToView(endOffset);
            if (startBounds != null && endBounds != null) {
                startBounds.add(endBounds);
                if (extraInsets != null) {
                    Rectangle visibleBounds = c.getVisibleRect();
                    int extraTop = extraInsets.top < 0 ? -extraInsets.top * visibleBounds.height / 100 : extraInsets.top * endBounds.height;
                    startBounds.y -= extraTop;
                    startBounds.height += extraTop;
                    startBounds.height = startBounds.height + (extraInsets.bottom < 0 ? -extraInsets.bottom * visibleBounds.height / 100 : extraInsets.bottom * endBounds.height);
                    int extraLeft = extraInsets.left < 0 ? -extraInsets.left * visibleBounds.width / 100 : extraInsets.left * endBounds.width;
                    startBounds.x -= extraLeft;
                    startBounds.width += extraLeft;
                    startBounds.width = startBounds.width + (extraInsets.right < 0 ? -extraInsets.right * visibleBounds.width / 100 : extraInsets.right * endBounds.width);
                }
                c.scrollRectToVisible(startBounds);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private synchronized boolean findMatches(final String text, final Map<String, Object> props) {
        if (text == null) {
            return false;
        }
        try {
            final PlainDocument plainDocument = new PlainDocument();
            plainDocument.insertString(0, text, null);
            this.findMatches = null;
            try {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditorFindSupport.access$302(EditorFindSupport.this, DocumentFinder.find(plainDocument, 0, text.length(), props, false));
                        }
                        catch (BadLocationException ble) {
                            LOG.log(Level.INFO, ble.getMessage(), ble);
                        }
                    }
                }).get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                Utilities.setStatusBoldText((JTextComponent)this.getFocusedTextComponent(), (String)NbBundle.getMessage(EditorFindSupport.class, (String)"slow-search"));
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            return this.findMatches != null && this.findMatches[0] != -1;
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    DocumentFinder.FindReplaceResult findReplaceImpl(String replaceExp, Map<String, Object> props, boolean oppositeDir, JTextComponent c) {
        this.incSearchReset();
        props = this.getValidFindProperties(props);
        boolean back = this.isBackSearch(props, oppositeDir);
        if (!(props.get(FIND_WHAT) instanceof String)) {
            return null;
        }
        String findWhat = (String)props.get(FIND_WHAT);
        if (c != null) {
            Boolean b;
            ComponentUtils.clearStatusText((JTextComponent)c);
            Caret caret = c.getCaret();
            int dotPos = caret.getDot();
            if (this.findMatches(c.getSelectedText(), props)) {
                Object dp = props.get(FIND_BACKWARD_SEARCH);
                boolean direction = dp != null ? (Boolean)dp : false;
                if (dotPos == (oppositeDir ^ direction ? c.getSelectionEnd() : c.getSelectionStart())) {
                    dotPos += oppositeDir ^ direction ? -1 : 1;
                }
                if (replaceExp != null) {
                    dotPos = oppositeDir ^ direction ? c.getSelectionEnd() : c.getSelectionStart();
                }
            }
            boolean blockSearch = (b = (Boolean)props.get(FIND_BLOCK_SEARCH)) != null && b != false;
            Position blockStartPos = (Position)props.get(FIND_BLOCK_SEARCH_START);
            int blockSearchStart = blockStartPos != null ? blockStartPos.getOffset() : -1;
            int blockSearchEnd = this.getBlockEndOffset();
            boolean backSearch = Boolean.TRUE.equals(props.get(FIND_BACKWARD_SEARCH));
            if (backSearch) {
                blockSearchEnd = dotPos;
                dotPos = 0;
            }
            try {
                DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(replaceExp, c, dotPos, blockSearch && blockSearchStart > -1 ? blockSearchStart : 0, blockSearch && blockSearchEnd > 0 ? blockSearchEnd : (backSearch ? blockSearchEnd : -1), props, oppositeDir);
                if (result != null && result.hasErrorMsg()) {
                    ComponentUtils.setStatusText((JTextComponent)c, (String)result.getErrorMsg());
                    c.getCaret().setDot(c.getCaret().getDot());
                    return null;
                }
                int[] blk = null;
                if (result != null) {
                    blk = result.getFoundPositions();
                }
                if (blk != null) {
                    if (Boolean.TRUE.equals(props.get(ADD_MULTICARET))) {
                        this.addCaretSelectText(c, blk[0], blk[1], back);
                    } else {
                        this.selectText(c, blk[0], blk[1], back);
                    }
                    String msg = NbBundle.getMessage(EditorFindSupport.class, (String)FOUND_LOCALE, (Object)findWhat, (Object)DocUtils.debugPosition((Document)c.getDocument(), (int)blk[0]));
                    if (blk[2] == 1) {
                        msg = msg + "; ";
                        msg = blockSearch && blockSearchEnd > 0 && blockSearchStart > -1 ? msg + (back ? NbBundle.getMessage(EditorFindSupport.class, (String)WRAP_BLOCK_END_LOCALE) : NbBundle.getMessage(EditorFindSupport.class, (String)WRAP_BLOCK_START_LOCALE)) : msg + (back ? NbBundle.getMessage(EditorFindSupport.class, (String)WRAP_END_LOCALE) : NbBundle.getMessage(EditorFindSupport.class, (String)WRAP_START_LOCALE));
                        ComponentUtils.setStatusText((JTextComponent)c, (String)msg, (int)800);
                        c.getToolkit().beep();
                    } else {
                        ComponentUtils.setStatusText((JTextComponent)c, (String)msg, (int)800);
                    }
                    return result;
                }
                ComponentUtils.setStatusText((JTextComponent)c, (String)NbBundle.getMessage(EditorFindSupport.class, (String)NOT_FOUND_LOCALE, (Object)findWhat), (int)800);
                c.getCaret().setDot(c.getCaret().getDot());
            }
            catch (BadLocationException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean find(Map<String, Object> props, boolean oppositeDir) {
        DocumentFinder.FindReplaceResult result = this.findReplaceImpl(null, props, oppositeDir, this.getFocusedTextComponent());
        return result != null;
    }

    private synchronized DocumentFinder.FindReplaceResult findReplaceInBlock(final String replaceExp, JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map<String, Object> props, final boolean oppositeDir) throws BadLocationException {
        if (c != null) {
            int[] retFind;
            final Map<String, Object> validProps = this.getValidFindProperties(props);
            final Document doc = c.getDocument();
            int pos = -1;
            boolean wrapDone = false;
            String replaced = null;
            boolean back = this.isBackSearch(validProps, oppositeDir);
            Boolean b = (Boolean)validProps.get(FIND_WRAP_SEARCH);
            boolean wrap = b != null && b != false;
            int docLen = doc.getLength();
            if (blockEndPos == -1) {
                blockEndPos = docLen;
            }
            if (startPos == -1) {
                startPos = docLen;
            }
            while (true) {
                final int off1 = startPos;
                final int off2 = oppositeDir ? blockStartPos : blockEndPos;
                this.currentResult = null;
                try {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EditorFindSupport.this.currentResult = DocumentFinder.findReplaceResult(replaceExp, doc, off1, off2, validProps, oppositeDir);
                            }
                            catch (BadLocationException ble) {
                                LOG.log(Level.WARNING, ble.getMessage(), ble);
                            }
                        }
                    }).get(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    Utilities.setStatusBoldText((JTextComponent)this.getFocusedTextComponent(), (String)NbBundle.getMessage(EditorFindSupport.class, (String)"slow-search"));
                    LOG.log(Level.INFO, ex.getMessage(), ex);
                }
                if (this.currentResult == null) {
                    return null;
                }
                if (this.currentResult.hasErrorMsg()) {
                    return this.currentResult;
                }
                retFind = this.currentResult.getFoundPositions();
                replaced = this.currentResult.getReplacedString();
                if (retFind == null || (pos = retFind[0]) != -1 || !wrap) break;
                if (back) {
                    startPos = blockEndPos;
                    blockEndPos = docLen;
                } else {
                    startPos = blockStartPos;
                }
                wrapDone = true;
                wrap = false;
            }
            if (pos != -1) {
                int[] ret = new int[]{pos, retFind[1], wrapDone ? 1 : 0};
                return new DocumentFinder.FindReplaceResult(ret, replaced);
            }
        }
        return null;
    }

    public int[] findInBlock(JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map<String, Object> props, boolean oppositeDir) throws BadLocationException {
        DocumentFinder.FindReplaceResult result = this.findReplaceInBlock(null, c, startPos, blockStartPos, blockEndPos, props, oppositeDir);
        return result == null ? null : result.getFoundPositions();
    }

    public boolean replace(Map<String, Object> props, boolean oppositeDir) throws BadLocationException {
        this.incSearchReset();
        return this.replaceImpl(props, oppositeDir, this.getFocusedTextComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceImpl(Map<String, Object> props, boolean oppositeDir, JTextComponent c) throws BadLocationException {
        int blockSearchStartOffset;
        props = this.getValidFindProperties(props);
        boolean back = Boolean.TRUE.equals(props.get(FIND_BACKWARD_SEARCH));
        if (oppositeDir) {
            back = !back;
        }
        boolean blockSearch = Boolean.TRUE.equals(props.get(FIND_BLOCK_SEARCH));
        Position blockSearchStartPos = (Position)props.get(FIND_BLOCK_SEARCH_START);
        int n = blockSearchStartOffset = blockSearchStartPos != null ? blockSearchStartPos.getOffset() : -1;
        if (c != null) {
            int startOffset;
            Caret caret;
            String s;
            block12: {
                DocumentFinder.FindReplaceResult result;
                s = (String)props.get(FIND_REPLACE_WITH);
                caret = c.getCaret();
                if (caret.isSelectionVisible() && caret.getDot() != caret.getMark()) {
                    Object dp = props.get(FIND_BACKWARD_SEARCH);
                    boolean direction = dp != null ? (Boolean)dp : false;
                    int dotPos = oppositeDir ^ direction ? c.getSelectionEnd() : c.getSelectionStart();
                    c.setCaretPosition(dotPos);
                }
                if ((result = this.findReplaceImpl(s, props, oppositeDir, c)) == null) {
                    return false;
                }
                s = result.getReplacedString();
                Document doc = c.getDocument();
                startOffset = c.getSelectionStart();
                int len = c.getSelectionEnd() - startOffset;
                DocUtils.atomicLock((Document)doc);
                try {
                    if (len > 0) {
                        doc.remove(startOffset, len);
                    }
                    if (s == null || s.length() <= 0) break block12;
                    try {
                        NavigationHistory.getEdits().markWaypoint(c, startOffset, false, true);
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, "Can't add position to the history of edits.", e);
                    }
                    doc.insertString(startOffset, s, null);
                    if (startOffset == blockSearchStartOffset) {
                        blockSearchStartPos = doc.createPosition(startOffset);
                        props.put(FIND_BLOCK_SEARCH_START, blockSearchStartPos);
                    }
                }
                finally {
                    DocUtils.atomicUnlock((Document)doc);
                    if (blockSearch) {
                        this.setBlockSearchHighlight(blockSearchStartOffset, this.getBlockEndOffset());
                    }
                }
            }
            int adjustedCaretPos = back || s == null ? startOffset : startOffset + s.length();
            caret.setDot(adjustedCaretPos);
        }
        return true;
    }

    public void replaceAll(Map<String, Object> props) {
        this.incSearchReset();
        this.replaceAllImpl(props, this.getFocusedTextComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceAllImpl(Map<String, Object> props, JTextComponent c) {
        Position blockSearchStartPos;
        props = this.getValidFindProperties(props);
        HashMap<String, Object> localProps = new HashMap<String, Object>(props);
        String replaceWithOriginal = (String)localProps.get(FIND_REPLACE_WITH);
        Object findWhat = localProps.get(FIND_WHAT);
        if (findWhat == null) {
            return;
        }
        if (findWhat.equals(replaceWithOriginal)) {
            return;
        }
        Document doc = c.getDocument();
        int maxCnt = doc.getLength();
        int replacedCnt = 0;
        int totalCnt = 0;
        boolean blockSearch = Boolean.TRUE.equals(localProps.get(FIND_BLOCK_SEARCH));
        boolean wrapSearch = Boolean.TRUE.equals(localProps.get(FIND_WRAP_SEARCH));
        boolean backSearch = Boolean.TRUE.equals(localProps.get(FIND_BACKWARD_SEARCH));
        if (wrapSearch) {
            localProps.put(FIND_WRAP_SEARCH, Boolean.FALSE);
            localProps.put(FIND_BACKWARD_SEARCH, Boolean.FALSE);
            backSearch = false;
            this.firePropertyChange(null, null, null);
        }
        int blockSearchStartOffset = (blockSearchStartPos = (Position)localProps.get(FIND_BLOCK_SEARCH_START)) != null ? blockSearchStartPos.getOffset() : -1;
        int blockSearchEndOffset = this.getBlockEndOffset();
        if (c != null) {
            DocUtils.atomicLock((Document)doc);
            try {
                DocumentFinder.FindReplaceResult result;
                int pos;
                int actualPos;
                int startPosWholeSearch = 0;
                int endPosWholeSearch = -1;
                int caretPos = c.getCaret().getDot();
                if (!wrapSearch) {
                    if (backSearch) {
                        startPosWholeSearch = 0;
                        endPosWholeSearch = caretPos;
                    } else {
                        startPosWholeSearch = caretPos;
                        endPosWholeSearch = -1;
                    }
                }
                int n = actualPos = wrapSearch ? 0 : c.getCaret().getDot();
                int n2 = pos = blockSearch && blockSearchStartOffset > -1 ? blockSearchStartOffset : (backSearch ? 0 : actualPos);
                while ((result = this.findReplaceInBlock(replaceWithOriginal, c, pos, blockSearch && blockSearchStartOffset > -1 ? blockSearchStartOffset : startPosWholeSearch, blockSearch && blockSearchEndOffset > 0 ? blockSearchEndOffset : endPosWholeSearch, localProps, false)) != null) {
                    int[] blk = result.getFoundPositions();
                    String replaceWith = result.getReplacedString();
                    if (blk == null) break;
                    ++totalCnt;
                    int len = blk[1] - blk[0];
                    boolean skip = false;
                    try {
                        doc.remove(blk[0], len);
                    }
                    catch (BadLocationException e) {
                        if (ComponentUtils.isGuardedException((BadLocationException)e)) {
                            skip = true;
                        }
                        throw e;
                    }
                    if (skip) {
                        pos = backSearch ? blk[0] : blk[0] + len;
                    } else {
                        if (replaceWith != null && replaceWith.length() > 0) {
                            int offset = blk[0];
                            try {
                                NavigationHistory.getEdits().markWaypoint(c, offset, false, true);
                            }
                            catch (BadLocationException e) {
                                LOG.log(Level.WARNING, "Can't add position to the history of edits.", e);
                            }
                            doc.insertString(offset, replaceWith, null);
                            if (offset == blockSearchStartOffset) {
                                blockSearchStartPos = doc.createPosition(offset);
                                props.put(FIND_BLOCK_SEARCH_START, blockSearchStartPos);
                            }
                            blockSearchEndOffset = this.getBlockEndOffset();
                        }
                        int n3 = backSearch ? blk[0] : (pos = blk[0] + (replaceWith != null ? replaceWith.length() : 0));
                        if (!wrapSearch && backSearch) {
                            endPosWholeSearch = endPosWholeSearch < blk[0] ? endPosWholeSearch : blk[0];
                            blockSearchEndOffset = blockSearchEndOffset < blk[0] ? blockSearchEndOffset : blk[0];
                            pos = blockSearch && blockSearchStartOffset > -1 ? blockSearchStartOffset : 0;
                        }
                        ++replacedCnt;
                    }
                    if (replacedCnt <= maxCnt) continue;
                    break;
                }
                if (totalCnt == 0) {
                    String exp = "'" + findWhat + "' ";
                    ComponentUtils.setStatusText((JTextComponent)c, (String)(exp + NbBundle.getMessage(EditorFindSupport.class, (String)NOT_FOUND_LOCALE)), (int)800);
                } else {
                    MessageFormat fmt = new MessageFormat(NbBundle.getMessage(EditorFindSupport.class, (String)ITEMS_REPLACED_LOCALE));
                    String msg = fmt.format(new Object[]{replacedCnt, totalCnt});
                    ComponentUtils.setStatusText((JTextComponent)c, (String)msg, (int)800);
                }
            }
            catch (BadLocationException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                DocUtils.atomicUnlock((Document)doc);
                if (blockSearch) {
                    this.setBlockSearchHighlight(blockSearchStartOffset, this.getBlockEndOffset());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hookLayer(BlockHighlighting layer, JTextComponent component) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            if (type2layer == null) {
                type2layer = new HashMap<String, WeakReference<BlockHighlighting>>();
                this.comp2layer.put(component, type2layer);
            }
            type2layer.put(layer.getLayerTypeId(), new WeakReference<BlockHighlighting>(layer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhookLayer(BlockHighlighting layer, JTextComponent component) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            if (type2layer != null) {
                type2layer.remove(layer.getLayerTypeId());
                if (type2layer.isEmpty()) {
                    this.comp2layer.remove(component);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockHighlighting findLayer(JTextComponent component, String layerId) {
        WeakHashMap<JTextComponent, Map<String, WeakReference<BlockHighlighting>>> weakHashMap = this.comp2layer;
        synchronized (weakHashMap) {
            WeakReference<BlockHighlighting> ref;
            Map<String, WeakReference<BlockHighlighting>> type2layer = this.comp2layer.get(component);
            BlockHighlighting layer = null;
            if (type2layer != null && (ref = type2layer.get(layerId)) != null) {
                layer = (BlockHighlighting)ref.get();
            }
            return layer;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String findPropertyName, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(findPropertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void firePropertyChange(String settingName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(settingName, oldValue, newValue);
    }

    public void setHistory(List<SPW> spwList) {
        this.historyList = new ArrayList<SPW>(spwList);
        if (!spwList.isEmpty()) {
            this.setLastSelected(spwList.get(0));
        }
    }

    public void setReplaceHistory(List<RP> rpList) {
        this.replaceList = new ArrayList<RP>(rpList);
    }

    public List<SPW> getHistory() {
        if (this.historyList.isEmpty()) {
            this.firePropertyChange(FIND_HISTORY_CHANGED_PROP, null, null);
        }
        return this.historyList;
    }

    public List<RP> getReplaceHistory() {
        if (this.replaceList.isEmpty()) {
            this.firePropertyChange(REPLACE_HISTORY_CHANGED_PROP, null, null);
        }
        return this.replaceList;
    }

    public void setLastSelected(SPW spw) {
        this.lastSelected = spw;
        Map<String, Object> props = this.getFindProperties();
        if (spw == null) {
            return;
        }
        props.put(FIND_WHAT, spw.getSearchExpression());
        props.put(FIND_MATCH_CASE, spw.isMatchCase());
        props.put(FIND_REG_EXP, spw.isRegExp());
        props.put(FIND_WHOLE_WORDS, spw.isWholeWords());
    }

    public SPW getLastSelected() {
        return this.lastSelected;
    }

    public void addToHistory(SPW spw) {
        if (spw == null) {
            return;
        }
        this.firePropertyChange(FIND_HISTORY_PROP, null, spw);
    }

    public void addToReplaceHistory(RP rp) {
        if (rp == null) {
            return;
        }
        this.firePropertyChange(REPLACE_HISTORY_PROP, null, rp);
    }

    private String calculateCacheKey(Document doc, int startOffset, int endOffset, Map<String, Object> props) {
        StringBuilder newCacheKey = new StringBuilder();
        newCacheKey.append("#").append(doc.getLength());
        newCacheKey.append("#").append(startOffset);
        newCacheKey.append("#").append(endOffset);
        newCacheKey.append("#").append(props.get(FIND_WHAT));
        newCacheKey.append("#").append(props.get(FIND_HIGHLIGHT_SEARCH));
        newCacheKey.append("#").append(props.get(FIND_INC_SEARCH));
        newCacheKey.append("#").append(props.get(FIND_BACKWARD_SEARCH));
        newCacheKey.append("#").append(props.get(FIND_WRAP_SEARCH));
        newCacheKey.append("#").append(props.get(FIND_MATCH_CASE));
        newCacheKey.append("#").append(props.get(FIND_SMART_CASE));
        newCacheKey.append("#").append(props.get(FIND_WHOLE_WORDS));
        newCacheKey.append("#").append(props.get(FIND_REG_EXP));
        newCacheKey.append("#").append(props.get(FIND_BLOCK_SEARCH));
        newCacheKey.append("#").append(props.get(FIND_BLOCK_SEARCH_START));
        newCacheKey.append("#").append(props.get(FIND_BLOCK_SEARCH_END));
        return newCacheKey.toString();
    }

    static /* synthetic */ int[] access$102(EditorFindSupport x0, int[] x1) {
        x0.cacheContent = x1;
        return x1;
    }

    static /* synthetic */ int[] access$302(EditorFindSupport x0, int[] x1) {
        x0.findMatches = x1;
        return x1;
    }

    public static final class SPW {
        private final String searchExpression;
        private final boolean wholeWords;
        private final boolean matchCase;
        private final boolean regExp;

        public SPW(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
            this.searchExpression = searchExpression;
            this.wholeWords = wholeWords;
            this.matchCase = matchCase;
            this.regExp = regExp;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SPW)) {
                return false;
            }
            SPW sp = (SPW)obj;
            return this.searchExpression.equals(sp.getSearchExpression()) && this.wholeWords == sp.isWholeWords() && this.matchCase == sp.isMatchCase() && this.regExp == sp.isRegExp();
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.wholeWords ? 1 : 0);
            result = 37 * result + (this.matchCase ? 1 : 0);
            result = 37 * result + (this.regExp ? 1 : 0);
            result = 37 * result + this.searchExpression.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            sb.append('\n');
            sb.append("wholeWords:");
            sb.append(this.wholeWords);
            sb.append('\n');
            sb.append("matchCase:");
            sb.append(this.matchCase);
            sb.append('\n');
            sb.append("regExp:");
            sb.append(this.regExp);
            return sb.toString();
        }
    }

    public static final class RP {
        private final String replaceExpression;
        private final boolean preserveCase;

        public RP(String replaceExpression, boolean preserveCase) {
            this.replaceExpression = replaceExpression;
            this.preserveCase = preserveCase;
        }

        public String getReplaceExpression() {
            return this.replaceExpression;
        }

        public boolean isPreserveCase() {
            return this.preserveCase;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RP)) {
                return false;
            }
            RP sp = (RP)obj;
            return this.replaceExpression.equals(sp.getReplaceExpression()) && this.preserveCase == sp.isPreserveCase();
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.preserveCase ? 1 : 0);
            result = 37 * result + this.replaceExpression.hashCode();
            return result;
        }
    }
}

