/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.typinghooks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowExpression;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class PhpCommentGenerator {
    static final RequestProcessor RP = new RequestProcessor("Generating Bracket Completer", 1);
    static final String TYPE_PLACEHOLDER = "type";

    private PhpCommentGenerator() {
    }

    static void generateDocTags(BaseDocument doc, int offset, int indent) {
        DocTagsGenerator docTagsGenerator = new DocTagsGenerator(doc, offset, indent);
        RP.post((Runnable)docTagsGenerator);
    }

    private static void generateFunctionDoc(BaseDocument doc, int offset, int indent, ParserResult info, FunctionDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        ScannerImpl i = new ScannerImpl(info, decl);
        i.scan(decl);
        PhpCommentGenerator.addVariables(doc, toAdd, "@global", indent, i.globals);
        PhpCommentGenerator.addVariables(doc, toAdd, "@staticvar", indent, i.staticvars);
        PhpCommentGenerator.addVariables(doc, toAdd, "@param", indent, i.params);
        if (i.hasReturn) {
            PhpCommentGenerator.generateDocEntry(doc, toAdd, "@return", indent, null, i.getReturnType());
        }
        PhpCommentGenerator.addVariables(doc, toAdd, "@throws", indent, i.throwsExceptions);
        doc.insertString(offset, toAdd.toString(), null);
    }

    private static void addVariables(BaseDocument doc, StringBuilder toAdd, String text, int indent, List<Pair<String, String>> vars) {
        for (Pair<String, String> p : vars) {
            PhpCommentGenerator.generateDocEntry(doc, toAdd, text, indent, (String)p.first(), (String)p.second());
        }
    }

    private static void generateDocEntry(BaseDocument doc, StringBuilder toAdd, String text, int indent, String name, String type) {
        toAdd.append("\n");
        toAdd.append(IndentUtils.createIndentString((Document)doc, (int)indent));
        toAdd.append(" * ");
        toAdd.append(text);
        String returnType = PhpCommentGenerator.convertThisReturnType(type);
        if (returnType != null && !returnType.isEmpty()) {
            toAdd.append(" ");
            toAdd.append(returnType);
        } else {
            toAdd.append(" ");
            toAdd.append(TYPE_PLACEHOLDER);
        }
        if (name != null) {
            toAdd.append(" ");
            toAdd.append(name);
        }
    }

    private static String convertThisReturnType(String returnTypes) {
        if (StringUtils.isEmpty((String)returnTypes)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(returnTypes.length());
        boolean first = true;
        for (String typeName : returnTypes.split("\\|")) {
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            if (typeName.equals("\\this")) {
                sb.append("$this");
                continue;
            }
            sb.append(typeName);
        }
        return sb.toString();
    }

    private static void generateGlobalVariableDoc(BaseDocument doc, int offset, int indent, String indexName, String type) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        PhpCommentGenerator.generateDocEntry(doc, toAdd, "@global", indent, "$GLOBALS['" + indexName + "']", type);
        toAdd.append("\n").append(IndentUtils.createIndentString((Document)doc, (int)indent));
        toAdd.append(" * ").append("@name $").append(indexName);
        doc.insertString(offset - 1, toAdd.toString(), null);
    }

    private static void generateFieldDoc(BaseDocument doc, int offset, int indent, ParserResult info, FieldsDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        Expression fieldType = decl.getFieldType();
        String type = null;
        if (fieldType != null) {
            type = PhpCommentGenerator.getDeclaredTypes(fieldType);
        }
        PhpCommentGenerator.generateDocEntry(doc, toAdd, "@var", indent, null, type);
        doc.insertString(offset, toAdd.toString(), null);
    }

    private static String getDeclaredTypes(Expression declaredType) {
        String typeName;
        if (declaredType instanceof UnionType) {
            typeName = VariousUtils.getUnionType((UnionType)declaredType);
        } else if (declaredType instanceof IntersectionType) {
            typeName = VariousUtils.getIntersectionType((IntersectionType)declaredType);
        } else {
            QualifiedName name = QualifiedName.create(declaredType);
            assert (name != null) : declaredType;
            typeName = name.toString();
        }
        if (declaredType instanceof NullableType) {
            typeName = typeName + "|" + "null";
        }
        return typeName;
    }

    private static class DocTagsGenerator
    implements Runnable {
        private final BaseDocument doc;
        private final int offset;
        private final int indent;

        public DocTagsGenerator(BaseDocument doc, int offset, int indent) {
            this.doc = doc;
            this.offset = offset;
            this.indent = indent;
        }

        @Override
        public void run() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)this.doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        final ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                        if (parserResult != null) {
                            class Result
                            extends Error {
                                private ASTNode node;

                                public Result(ASTNode node) {
                                    this.node = node;
                                }
                            }
                            Variable variable;
                            ArrayAccess arrayAccess;
                            Assignment assignment;
                            ASTNode n = null;
                            try {
                                DefaultVisitor visitor = new DefaultVisitor(){

                                    @Override
                                    public void scan(ASTNode node) {
                                        Comment c;
                                        if (node != null && (c = Utils.getCommentForNode(Utils.getRoot(parserResult), node)) != null && c.getStartOffset() <= offset && offset <= c.getEndOffset()) {
                                            throw new Result(node);
                                        }
                                        super.scan(node);
                                    }
                                };
                                visitor.scan(Utils.getRoot(parserResult));
                            }
                            catch (Result r) {
                                n = r.node;
                            }
                            if (n == null) {
                                return;
                            }
                            if (n instanceof FunctionDeclaration) {
                                PhpCommentGenerator.generateFunctionDoc(doc, offset, indent, parserResult, (FunctionDeclaration)n);
                            }
                            if (n instanceof MethodDeclaration) {
                                PhpCommentGenerator.generateFunctionDoc(doc, offset, indent, parserResult, ((MethodDeclaration)n).getFunction());
                            }
                            if (n instanceof ExpressionStatement && ((ExpressionStatement)n).getExpression() instanceof Assignment && (assignment = (Assignment)((ExpressionStatement)n).getExpression()).getLeftHandSide() instanceof ArrayAccess && (arrayAccess = (ArrayAccess)assignment.getLeftHandSide()).getName() instanceof Variable && (variable = (Variable)arrayAccess.getName()).isDollared() && variable.getName() instanceof Identifier && "GLOBALS".equals(((Identifier)variable.getName()).getName()) && arrayAccess.getDimension().getIndex() instanceof Scalar) {
                                String index = ((Scalar)arrayAccess.getDimension().getIndex()).getStringValue().trim();
                                if (index.length() > 0 && (index.charAt(0) == '\'' || index.charAt(0) == '\"')) {
                                    index = index.substring(1, index.length() - 1);
                                }
                                String type = null;
                                if (assignment.getRightHandSide() instanceof Scalar) {
                                    switch (((Scalar)assignment.getRightHandSide()).getScalarType()) {
                                        case INT: {
                                            type = "integer";
                                            break;
                                        }
                                        case REAL: 
                                        case FLOAT: {
                                            type = "float";
                                            break;
                                        }
                                        case STRING: {
                                            type = "string";
                                            break;
                                        }
                                    }
                                }
                                PhpCommentGenerator.generateGlobalVariableDoc(doc, offset, indent, index, type);
                            }
                            if (n instanceof FieldsDeclaration) {
                                PhpCommentGenerator.generateFieldDoc(doc, offset, indent, parserResult, (FieldsDeclaration)n);
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class ScannerImpl
    extends DefaultVisitor {
        private final List<Pair<String, String>> globals = new LinkedList<Pair<String, String>>();
        private final List<Pair<String, String>> staticvars = new LinkedList<Pair<String, String>>();
        private final List<Pair<String, String>> params = new LinkedList<Pair<String, String>>();
        private final List<Pair<String, String>> throwsExceptions = new LinkedList<Pair<String, String>>();
        private final List<String> usedThrows = new LinkedList<String>();
        final Set<VariableName> declaredVariables = new HashSet<VariableName>();
        private boolean hasReturn;
        private final FunctionDeclaration decl;
        private final FunctionScope fnc;
        private Collection<? extends UseScope> declaredUses;

        public ScannerImpl(ParserResult info, FunctionDeclaration decl) {
            if (info instanceof PHPParseResult) {
                PHPParseResult parseResult = (PHPParseResult)info;
                Model model = parseResult.getModel();
                VariableScope variableScope = model.getVariableScope(decl.getEndOffset() - 1);
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(model.getFileScope(), decl.getEndOffset() - 1);
                if (namespaceScope != null) {
                    this.declaredUses = namespaceScope.getAllDeclaredSingleUses();
                }
                if (variableScope instanceof FunctionScope) {
                    this.fnc = (FunctionScope)variableScope;
                    this.declaredVariables.addAll(this.fnc.getDeclaredVariables());
                } else {
                    this.fnc = null;
                }
            } else {
                this.fnc = null;
            }
            this.decl = decl;
        }

        public String getReturnType() {
            if (this.decl.getReturnType() != null) {
                Expression returnType = this.decl.getReturnType();
                return PhpCommentGenerator.getDeclaredTypes(returnType);
            }
            StringBuilder type = new StringBuilder();
            if (this.hasReturn) {
                Collection<? extends String> typeNames = this.fnc.getReturnTypeNames();
                for (String string : typeNames) {
                    if (VariousUtils.isSemiType(string)) break;
                    String resolvedItem = this.resolveProperType(string);
                    type = type.toString().isEmpty() ? type.append(resolvedItem) : type.append("|").append(resolvedItem);
                }
            }
            return type.toString();
        }

        @Override
        public void scan(ASTNode node) {
            if (this.fnc != null) {
                super.scan(node);
            }
        }

        @Override
        public void visit(FormalParameter p) {
            String name = "";
            Expression expr = p.getParameterName();
            Variable var = null;
            if (expr instanceof Reference) {
                expr = ((Reference)expr).getExpression();
            }
            if (expr instanceof Variadic) {
                expr = ((Variadic)expr).getExpression();
            }
            if (expr instanceof Variable) {
                var = (Variable)expr;
            }
            if (var != null && var.getName() instanceof Identifier) {
                name = ((Identifier)var.getName()).getName();
            }
            if (name != null) {
                Expression parameterType = p.getParameterType();
                if (parameterType != null) {
                    this.params.add((Pair<String, String>)Pair.of((Object)("$" + name), (Object)PhpCommentGenerator.getDeclaredTypes(parameterType)));
                } else {
                    for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                        String type;
                        Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                        ArrayList<String> resolvedTypeNames = new ArrayList<String>();
                        typeNames.forEach(typeName -> resolvedTypeNames.add(this.resolveProperType((String)typeName)));
                        String string = type = typeNames.isEmpty() ? null : Type.asUnionType(resolvedTypeNames);
                        if (VariousUtils.isSemiType(type)) {
                            type = null;
                        }
                        this.params.add((Pair<String, String>)Pair.of((Object)variable.getName(), (Object)type));
                    }
                }
            }
            super.visit(p);
        }

        private String resolveProperType(String type) {
            String typeName = type;
            boolean isNullableType = CodeUtils.isNullableType(typeName);
            if (isNullableType) {
                typeName = typeName.substring(1);
            }
            if (this.declaredUses != null && typeName != null) {
                QualifiedName qualifiedType = QualifiedName.create(typeName);
                for (UseScope useScope : this.declaredUses) {
                    QualifiedName qualifiedUseScope = QualifiedName.create(useScope.getName());
                    if (!QualifiedName.create(true, qualifiedUseScope.getSegments()).equals(qualifiedType)) continue;
                    AliasedName aliasedName = useScope.getAliasedName();
                    if (aliasedName != null) {
                        typeName = aliasedName.getAliasName();
                        break;
                    }
                    typeName = qualifiedUseScope.getName();
                    break;
                }
            }
            if (isNullableType) {
                return typeName + "|" + "null";
            }
            return typeName;
        }

        @Override
        public void visit(GlobalStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (VariousUtils.isSemiType(type)) {
                        type = null;
                    }
                    this.globals.add((Pair<String, String>)Pair.of((Object)variable.getName(), (Object)this.resolveProperType(type)));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration declaration) {
        }

        @Override
        public void visit(ReturnStatement node) {
            this.hasReturn = true;
        }

        @Override
        public void visit(StaticStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (VariousUtils.isSemiType(type)) {
                        type = null;
                    }
                    this.staticvars.add((Pair<String, String>)Pair.of((Object)variable.getName(), (Object)this.resolveProperType(type)));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(ThrowExpression node) {
            String type = this.getTypeFromThrowExpression(node);
            if (!this.usedThrows.contains(type)) {
                this.usedThrows.add(type);
                this.throwsExceptions.add((Pair<String, String>)Pair.of(null, (Object)this.resolveProperType(type)));
            }
            super.visit(node);
        }

        private String getTypeFromThrowExpression(ThrowExpression throwExpression) {
            String type = null;
            Expression expression = throwExpression.getExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                Expression name = classInstanceCreation.getClassName().getName();
                if (name instanceof NamespaceName) {
                    NamespaceName namespaceName = (NamespaceName)name;
                    type = this.getTypeFromNamespaceName(namespaceName);
                }
            } else if (expression instanceof Variable) {
                Variable v = (Variable)expression;
                String name = CodeUtils.extractVariableName(v);
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                }
            }
            return this.resolveProperType(type);
        }

        private String getTypeFromNamespaceName(NamespaceName namespaceName) {
            StringBuilder sbType = new StringBuilder();
            if (namespaceName.isGlobal()) {
                sbType.append("\\");
            }
            List<Identifier> segments = namespaceName.getSegments();
            Iterator<Identifier> iter = segments.iterator();
            while (iter.hasNext()) {
                sbType.append(iter.next().getName());
                if (!iter.hasNext()) continue;
                sbType.append("\\");
            }
            return sbType.toString();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (node == this.decl) {
                Expression type = node.getReturnType();
                if (type != null) {
                    this.hasReturn = true;
                }
                super.visit(node);
            }
        }

        @Override
        public void visit(ClassDeclaration node) {
        }
    }
}

