/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ImplementAbstractMethodsHintError
extends HintErrorRule {
    private static final String ABSTRACT_PREFIX = "abstract ";
    private static final Logger LOGGER = Logger.getLogger(ImplementAbstractMethodsHintError.class.getName());

    public String getDisplayName() {
        return Bundle.ImplementAbstractMethodsDispName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileScope fileScope = context.fileScope;
        FileObject fileObject = context.parserResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && fileObject != null) {
            Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
            this.addHints(allClasses, context, hints, fileObject);
            Collection<? extends EnumScope> allEnums = ModelUtils.getDeclaredEnums(fileScope);
            this.addHints(allEnums, context, hints, fileObject);
        }
    }

    private void addHints(Collection<? extends TypeScope> allClasses, PHPRuleContext context, List<Hint> hints, FileObject fileObject) {
        for (FixInfo fixInfo : this.checkHints(allClasses, context)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            String className = fixInfo.anonymousClass ? Bundle.ImplementAbstractMethodsHintError_class_anonymous() : fixInfo.className;
            hints.add(new Hint((Rule)this, Bundle.ImplementAbstractMethodsHintDesc(className, fixInfo.lastMethodDeclaration, fixInfo.lastMethodOwnerName), fileObject, fixInfo.classNameRange, this.createHintFixes(context.doc, fixInfo), 500));
        }
    }

    protected PhpVersion getPhpVersion(@NullAllowed FileObject file) {
        if (file == null) {
            return PhpVersion.getDefault();
        }
        return CodeUtils.getPhpVersion(file);
    }

    private List<HintFix> createHintFixes(BaseDocument doc, FixInfo fixInfo) {
        ArrayList<Object> hintFixes = new ArrayList<Object>();
        hintFixes.add(new ImplementAllFix(doc, fixInfo));
        if (!fixInfo.anonymousClass && !fixInfo.isEnum) {
            hintFixes.add(new AbstractClassFix(doc, fixInfo));
        }
        return Collections.unmodifiableList(hintFixes);
    }

    private Collection<FixInfo> checkHints(Collection<? extends TypeScope> allTypes, PHPRuleContext context) {
        ArrayList<FixInfo> retval = new ArrayList<FixInfo>();
        PhpVersion phpVersion = this.getPhpVersion(context.parserResult.getSnapshot().getSource().getFileObject());
        for (TypeScope typeScope : allTypes) {
            int classDeclarationOffset;
            int newMethodsOffset;
            if (CancelSupport.getDefault().isCancelled()) {
                return Collections.emptyList();
            }
            if (this.isAbstract(typeScope)) continue;
            ElementQuery.Index index = context.getIndex();
            HashSet<String> allValidMethods = new HashSet<String>();
            allValidMethods.addAll(ImplementAbstractMethodsHintError.toNames(this.getValidInheritedMethods(this.getInheritedMethods(typeScope, index))));
            allValidMethods.addAll(ImplementAbstractMethodsHintError.toNames(index.getDeclaredMethods(typeScope)));
            ElementFilter declaredMethods = ElementFilter.forExcludedNames(allValidMethods, PhpElementKind.METHOD);
            ArrayList<MethodElement> accessibleMethods = new ArrayList<MethodElement>(declaredMethods.filter(index.getAccessibleMethods(typeScope, typeScope)));
            accessibleMethods.sort((m1, m2) -> {
                int result = m1.getFilenameUrl().compareTo(m2.getFilenameUrl());
                if (result == 0) {
                    return Integer.compare(m1.getOffset(), m2.getOffset());
                }
                return result;
            });
            LinkedHashSet<String> methodSkeletons = new LinkedHashSet<String>();
            MethodElement lastMethodElement = null;
            FileObject lastFileObject = null;
            FileScope fileScope = null;
            for (MethodElement methodElement : accessibleMethods) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                TypeElement type = methodElement.getType();
                if (!type.isInterface() && !methodElement.isAbstract() || methodElement.isFinal()) continue;
                FileObject fileObject = methodElement.getFileObject();
                if (lastFileObject != fileObject && fileObject != null) {
                    lastFileObject = fileObject;
                    fileScope = this.getFileScope(fileObject);
                }
                if (fileScope == null) continue;
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(fileScope, methodElement.getOffset());
                ArrayList<TypeNameResolver> typeNameResolvers = new ArrayList<TypeNameResolver>();
                if (phpVersion == PhpVersion.PHP_5) {
                    typeNameResolvers.add(TypeNameResolverImpl.forUnqualifiedName());
                } else {
                    typeNameResolvers.add(TypeNameResolverImpl.forFullyQualifiedName(namespaceScope, methodElement.getOffset()));
                    typeNameResolvers.add(TypeNameResolverImpl.forSmartName(typeScope, typeScope.getOffset()));
                }
                TypeNameResolver typeNameResolver = TypeNameResolverImpl.forChainOf(typeNameResolvers);
                String skeleton = methodElement.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody, typeNameResolver, phpVersion);
                if (phpVersion.hasOverrideAttribute()) {
                    skeleton = PredefinedSymbols.Attributes.OVERRIDE.asAttributeExpression() + "\n" + skeleton;
                }
                skeleton = skeleton.replace(ABSTRACT_PREFIX, "");
                methodSkeletons.add(skeleton);
                lastMethodElement = methodElement;
            }
            if (methodSkeletons.isEmpty() || lastMethodElement == null || (newMethodsOffset = ImplementAbstractMethodsHintError.getNewMethodsOffset(typeScope, context.doc, classDeclarationOffset = ImplementAbstractMethodsHintError.getClassDeclarationOffset(context.parserResult.getSnapshot().getTokenHierarchy(), typeScope.getOffset()))) == -1 || classDeclarationOffset == -1) continue;
            retval.add(new FixInfo(typeScope, methodSkeletons, lastMethodElement, newMethodsOffset, classDeclarationOffset, this.isAnonymous(typeScope)));
        }
        return retval;
    }

    private boolean isAbstract(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).isAbstract();
        }
        return false;
    }

    private boolean isAnonymous(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).isAnonymous();
        }
        return false;
    }

    private FileScope getFileScope(FileObject fileObject) {
        final FileScope[] fileScope = new FileScope[1];
        try {
            ParserManager.parse(Collections.singletonList(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    PHPParseResult phpResult = (PHPParseResult)parserResult;
                    fileScope[0] = phpResult.getModel().getFileScope();
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return fileScope[0];
    }

    private Set<MethodElement> getInheritedMethods(TypeScope typeScope, ElementQuery.Index index) {
        HashSet<MethodElement> inheritedMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> declaredSuperMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> accessibleSuperMethods = new HashSet<MethodElement>();
        Collection<? extends ClassScope> superClasses = this.getSuperClasses(typeScope);
        for (ClassScope classScope : superClasses) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(classScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(classScope, typeScope));
        }
        Collection<? extends InterfaceScope> superInterface = typeScope.getSuperInterfaceScopes();
        for (InterfaceScope interfaceScope : superInterface) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(interfaceScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(interfaceScope, typeScope));
        }
        Collection<? extends TraitScope> collection = this.getTraits(typeScope);
        for (TraitScope traitScope : collection) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(traitScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(traitScope, typeScope));
        }
        inheritedMethods.addAll(declaredSuperMethods);
        inheritedMethods.addAll(accessibleSuperMethods);
        return inheritedMethods;
    }

    private Collection<? extends ClassScope> getSuperClasses(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).getSuperClasses();
        }
        return Collections.emptyList();
    }

    private Collection<? extends TraitScope> getTraits(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).getTraits();
        }
        if (typeScope instanceof EnumScope) {
            return ((EnumScope)typeScope).getTraits();
        }
        return Collections.emptyList();
    }

    private Set<MethodElement> getValidInheritedMethods(Set<MethodElement> inheritedMethods) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (MethodElement methodElement : inheritedMethods) {
            if (methodElement.isAbstract()) continue;
            retval.add(methodElement);
        }
        return retval;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            String name = phpElement.getName();
            if (StringUtils.isEmpty((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    private static int getClassDeclarationOffset(TokenHierarchy<?> th, int classNameOffset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(th, classNameOffset);
        ts.move(classNameOffset);
        ts.movePrevious();
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, Collections.singletonList(PHPTokenId.PHP_CLASS));
        return previousToken.offset(th);
    }

    private static int getNewMethodsOffset(TypeScope typeScope, BaseDocument doc, int classDeclarationOffset) {
        int offset = -1;
        Collection<? extends MethodScope> declaredMethods = typeScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            OffsetRange blockRange = methodScope.getBlockRange();
            if (blockRange == null || blockRange.getEnd() <= offset) continue;
            offset = blockRange.getEnd();
        }
        if (offset == -1 && typeScope.getBlockRange() != null) {
            try {
                int rowStartOfClassEnd = LineDocumentUtils.getLineStart((LineDocument)doc, (int)typeScope.getBlockRange().getEnd());
                int n = rowStartOfClassEnd - 1;
                int rowStartOfPreviousRow = LineDocumentUtils.getLineStart((LineDocument)doc, (int)n);
                int newMethodPossibleOffset = rowStartOfPreviousRow < n ? rowStartOfClassEnd : rowStartOfPreviousRow;
                int newMethodLineOffset = LineDocumentUtils.getLineIndex((LineDocument)doc, (int)newMethodPossibleOffset);
                int classDeclarationLineOffset = LineDocumentUtils.getLineIndex((LineDocument)doc, (int)classDeclarationOffset);
                offset = newMethodLineOffset == classDeclarationLineOffset ? n : newMethodPossibleOffset;
            }
            catch (BadLocationException ex) {
                offset = -1;
            }
        }
        return offset;
    }

    private static class FixInfo {
        private List<String> methodSkeletons;
        private String className;
        private int newMethodsOffset;
        private OffsetRange classNameRange;
        private final String lastMethodDeclaration;
        private final String lastMethodOwnerName;
        private final int classDeclarationOffset;
        private final boolean anonymousClass;
        private final boolean isEnum;

        FixInfo(TypeScope typeScope, Set<String> methodSkeletons, MethodElement lastMethodElement, int newMethodsOffset, int classDeclarationOffset, boolean anonymousClass) {
            this.methodSkeletons = new ArrayList<String>(methodSkeletons);
            this.className = typeScope.getFullyQualifiedName().toString();
            Collections.sort(this.methodSkeletons);
            this.classNameRange = typeScope.getNameRange();
            this.classDeclarationOffset = classDeclarationOffset;
            this.newMethodsOffset = newMethodsOffset;
            this.lastMethodDeclaration = lastMethodElement.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration);
            this.lastMethodOwnerName = lastMethodElement.getType().getFullyQualifiedName().toString();
            this.anonymousClass = anonymousClass;
            this.isEnum = typeScope instanceof EnumScope;
        }
    }

    private static class ImplementAllFix
    implements HintFix {
        private final BaseDocument doc;
        private final FixInfo fixInfo;

        ImplementAllFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.ImplementAbstractMethodsDesc();
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.setFormatAll(true);
            for (String methodScope : this.fixInfo.methodSkeletons) {
                edits.replace(this.fixInfo.newMethodsOffset, 0, methodScope, true, 0);
            }
            return edits;
        }
    }

    private static class AbstractClassFix
    implements HintFix {
        private final BaseDocument doc;
        private final FixInfo fixInfo;

        public AbstractClassFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.AbstractClassFixDesc();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.fixInfo.classDeclarationOffset, 0, ImplementAbstractMethodsHintError.ABSTRACT_PREFIX, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

