/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ReturnTypeHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.ReturnTypeHintErrorDisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null && this.appliesTo(this.fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            Map<ASTNode, Set<ReturnStatement>> returnStatements = checkVisitor.getReturnStatements();
            this.checkReturnType(returnStatements, hints);
        }
    }

    protected PhpVersion getPhpVersion(@NullAllowed FileObject file) {
        if (file == null) {
            return PhpVersion.getDefault();
        }
        return CodeUtils.getPhpVersion(file);
    }

    private boolean appliesTo(FileObject file) {
        return this.getPhpVersion(file).compareTo((Enum)PhpVersion.PHP_71) >= 0;
    }

    private void checkReturnType(Map<ASTNode, Set<ReturnStatement>> returnStatements, List<Hint> hints) {
        for (Map.Entry<ASTNode, Set<ReturnStatement>> entry : returnStatements.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ASTNode node = entry.getKey();
            Expression returnType = null;
            if (node instanceof FunctionDeclaration) {
                returnType = ((FunctionDeclaration)node).getReturnType();
            } else if (node instanceof LambdaFunctionDeclaration) {
                returnType = ((LambdaFunctionDeclaration)node).getReturnType();
            }
            if (returnType == null) continue;
            Set<ReturnStatement> statements = entry.getValue();
            if (returnType instanceof NamespaceName) {
                NamespaceName namespaceName = (NamespaceName)returnType;
                String name = CodeUtils.extractUnqualifiedName(namespaceName);
                this.checkVoidAndNeverReturnStatements(statements, name, hints);
                this.checkReturnStatementsWithoutValue(statements, name, hints);
                continue;
            }
            if (returnType instanceof NullableType) {
                Expression type = ((NullableType)returnType).getType();
                if (type instanceof NamespaceName) {
                    NamespaceName namespaceName = (NamespaceName)type;
                    String name = CodeUtils.extractUnqualifiedName(namespaceName);
                    this.checkInvalidVoidAndNeverReturnType(type, name, hints);
                }
                this.checkReturnStatementsWithoutValue(statements, "", hints);
                continue;
            }
            if (!(returnType instanceof UnionType) && !(returnType instanceof IntersectionType)) continue;
            this.checkReturnStatementsWithoutValue(statements, "", hints);
        }
    }

    private void checkVoidAndNeverReturnStatements(Set<ReturnStatement> statements, String name, List<Hint> hints) {
        if (this.isVoidType(name) || this.isNeverType(name)) {
            for (ReturnStatement statement : statements) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                Expression expression = statement.getExpression();
                if (expression == null && !this.isNeverType(name)) continue;
                this.addHint(statement, Bundle.ReturnTypeHintErrorVoidDesc(name), hints);
            }
        }
    }

    private void checkInvalidVoidAndNeverReturnType(Expression returnType, String name, List<Hint> hints) {
        if (this.isVoidType(name) || this.isNeverType(name)) {
            this.addHint(returnType, Bundle.ReturnTypeHintErrorInvalidVoidDesc(name), hints);
        }
    }

    private void checkReturnStatementsWithoutValue(Set<ReturnStatement> statements, String name, List<Hint> hints) {
        if (!this.isVoidType(name) && !this.isNeverType(name)) {
            for (ReturnStatement statement : statements) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                Expression expression = statement.getExpression();
                if (expression != null) continue;
                this.addHint(statement, Bundle.ReturnStatementWithoutValueHintErrorDesc(), hints);
            }
        }
    }

    private boolean isNeverType(String name) {
        return "never".equals(name) && this.getPhpVersion(this.fileObject).hasNeverType();
    }

    private boolean isVoidType(String name) {
        return "void".equals(name) && this.getPhpVersion(this.fileObject).hasVoidReturnType();
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), Collections.emptyList(), 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Map<ASTNode, Set<ReturnStatement>> returnStatements = new HashMap<ASTNode, Set<ReturnStatement>>();
        private final LinkedList<ASTNode> path = new LinkedList();

        private CheckVisitor() {
        }

        public Map<ASTNode, Set<ReturnStatement>> getReturnStatements() {
            return Collections.unmodifiableMap(this.returnStatements);
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.path.addFirst(node);
            super.visit(node);
            this.addReturnStatement(node, null);
            this.path.removeFirst();
        }

        @Override
        public void visit(LambdaFunctionDeclaration declaration) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.path.addFirst(declaration);
            super.visit(declaration);
            this.addReturnStatement(declaration, null);
            this.path.removeFirst();
        }

        @Override
        public void visit(ReturnStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!this.path.isEmpty()) {
                this.addReturnStatement(this.path.get(0), node);
            }
        }

        private void addReturnStatement(ASTNode node, ReturnStatement returnStatement) {
            if (node != null) {
                Set<ReturnStatement> returns = this.returnStatements.get(node);
                if (returns == null) {
                    returns = new HashSet<ReturnStatement>();
                    this.returnStatements.put(node, returns);
                }
                if (returnStatement != null) {
                    returns.add(returnStatement);
                }
            }
        }
    }
}

