/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.modules.cloud.oracle.policy.PolicyGenerator;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class CreatePoliciesCommand
implements CommandProvider {
    private static final String COMMAND_CREATE_POLICIES = "nbls.cloud.assets.policy.create.local";
    private static final String COMMAND_CREATE_CONFIG = "nbls.cloud.assets.config.create.local";
    private static final String COMMAND_CLOUD_ASSETS_REFRESH = "nbls.cloud.assets.refresh";
    private static final RequestProcessor RP = new RequestProcessor("PoliciesCommand");
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.policy.create.local", "nbls.cloud.assets.config.create.local", "nbls.cloud.assets.refresh"));

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        if (COMMAND_CREATE_POLICIES.equals(command)) {
            RP.post(() -> {
                try {
                    String policies = PolicyGenerator.createPolicies(CloudAssets.getDefault().getItems());
                    future.complete(policies);
                }
                catch (IllegalStateException e) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)e.getMessage());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                    future.completeExceptionally(e);
                }
            });
            return future;
        }
        if (COMMAND_CREATE_CONFIG.equals(command)) {
            StringWriter writer = new StringWriter();
            Properties dbProps = new Properties();
            PropertiesGenerator propGen = new PropertiesGenerator(false);
            dbProps.putAll(propGen.getApplication());
            dbProps.putAll(propGen.getBootstrap());
            try {
                dbProps.store(writer, "Generated application.properties\nUncomment following line when running inside Oracle Cloud\noci.config.instance-principal.enabled=true");
                future.complete(writer.toString());
            }
            catch (IOException ex) {
                future.completeExceptionally(ex);
            }
        } else if (COMMAND_CLOUD_ASSETS_REFRESH.equals(command)) {
            CloudAssets.getDefault().update();
        }
        return future;
    }
}

