/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.compartment;

import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class CompartmentNode
extends OCINode {
    private static final String COMPARTMENT_ICON = "org/netbeans/modules/cloud/oracle/resources/compartment.svg";

    public CompartmentNode(CompartmentItem compartment) {
        super(compartment);
        this.setDisplayName(compartment.getName());
        this.setIconBaseWithExtension(COMPARTMENT_ICON);
    }

    public CompartmentNode(OCISessionInitiator session, CompartmentItem compartment) {
        super((OCIItem)compartment, session);
        this.setDisplayName(compartment.getName());
        this.setIconBaseWithExtension(COMPARTMENT_ICON);
    }

    public static NodeProvider<CompartmentItem> createNode() {
        return CompartmentNode::new;
    }

    public static ChildrenProvider.SessionAware<OCIItem, CompartmentItem> getCompartments() {
        return (parent, session) -> {
            ListCompartmentsResponse response;
            Identity identityClient = session.newClient(IdentityClient.class);
            ArrayList compartments = new ArrayList();
            String nextPageToken = null;
            do {
                response = identityClient.listCompartments(ListCompartmentsRequest.builder().limit(30).compartmentId(parent.getKey().getValue()).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).page(nextPageToken).build());
                response.getItems().stream().map(c -> new CompartmentItem(OCID.of(c.getId(), "Compartment"), parent.getKey().getValue(), c.getName())).collect(Collectors.toCollection(() -> compartments));
            } while ((nextPageToken = response.getOpcNextPage()) != null);
            return compartments;
        };
    }
}

