/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.artifacts.ArtifactsClient;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.developer.Bundle;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class ContainerTagNode
extends OCINode {
    private static final String CONTAINER_TAG_ICON = "org/netbeans/modules/cloud/oracle/resources/containertag.svg";

    public ContainerTagNode(ContainerTagItem tag) {
        super((OCIItem)tag, Children.LEAF);
        this.setName(tag.getName());
        this.setDisplayName(tag.getName());
        this.setIconBaseWithExtension(CONTAINER_TAG_ICON);
        this.setShortDescription(Bundle.ContainerTagDesc(tag.getUrl(), tag.getVersion(), tag.getDigest()));
    }

    public static NodeProvider<ContainerTagItem> createNode() {
        return ContainerTagNode::new;
    }

    public static ChildrenProvider.SessionAware<ContainerRepositoryItem, ContainerTagItem> getContainerTags() {
        return (containerRepository, session) -> {
            ArtifactsClient client = session.newClient(ArtifactsClient.class);
            ListContainerImagesRequest listContainerImagesRequest = ListContainerImagesRequest.builder().compartmentId(containerRepository.getCompartmentId()).repositoryId(containerRepository.getKey().getValue()).build();
            return client.listContainerImages(listContainerImagesRequest).getContainerImageCollection().getItems().stream().map(d -> new ContainerTagItem(OCID.of(d.getId(), "ContainerTag"), containerRepository.getCompartmentId(), containerRepository.getName(), containerRepository.getRegionCode(), containerRepository.getNamespace(), d.getVersion(), d.getDigest().trim())).collect(Collectors.toList());
        };
    }
}

