/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.devops.BuildPipelineItem;
import org.netbeans.modules.cloud.oracle.devops.Bundle;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class BuildPipelineNode
extends OCINode {
    private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/build_pipeline.svg";

    public BuildPipelineNode(OCIItem item) {
        super(item, Children.LEAF);
        this.setIconBaseWithExtension(ICON);
    }

    public static NodeProvider<OCIItem> createNode() {
        return BuildPipelineNode::new;
    }

    public static ChildrenProvider.SessionAware<DevopsProjectItem, BuildPipelineItem.BuildPipelineFolder> listDevopsPipelines() {
        return (project, session) -> {
            try (DevopsClient client = session.newClient(DevopsClient.class);){
                ListBuildPipelinesRequest request = ListBuildPipelinesRequest.builder().projectId(project.getKey().getValue()).build();
                ListBuildPipelinesResponse response = client.listBuildPipelines(request);
                List projects = response.getBuildPipelineCollection().getItems();
                List<BuildPipelineItem.BuildPipelineFolder> list = Collections.singletonList(new BuildPipelineItem.BuildPipelineFolder(OCID.of(project.getKey().getValue(), "BuildPipelineFolder"), project.getCompartmentId(), Bundle.BuildPipelines(), projects.stream().map(p -> new BuildPipelineItem(OCID.of(p.getId(), "BuildPipeline"), project.getCompartmentId(), p.getDisplayName())).collect(Collectors.toList())));
                return list;
            }
        };
    }

    public static NodeProvider<BuildPipelineItem.BuildPipelineFolder> createFolderNode() {
        return BuildPipelineFolderNode::new;
    }

    public static ChildrenProvider<BuildPipelineItem.BuildPipelineFolder, BuildPipelineItem> expandRepositories() {
        return repositories -> repositories.getPipelines();
    }

    public static class BuildPipelineFolderNode
    extends OCINode {
        private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/build_pipeline_folder.svg";

        public BuildPipelineFolderNode(BuildPipelineItem.BuildPipelineFolder folder) {
            super(folder);
            this.setIconBaseWithExtension(ICON);
        }

        @Override
        public void refresh() {
            ((OCINode)this.getParentNode()).refresh();
        }
    }
}

