/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.objectstorage.model.ObjectVersionSummary;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectVersionCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="items")
    private final List<ObjectVersionSummary> items;
    @JsonProperty(value="prefixes")
    private final List<String> prefixes;

    @Deprecated
    @ConstructorProperties(value={"items", "prefixes"})
    public ObjectVersionCollection(List<ObjectVersionSummary> items, List<String> prefixes) {
        this.items = items;
        this.prefixes = prefixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ObjectVersionSummary> getItems() {
        return this.items;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectVersionCollection(");
        sb.append("super=").append(super.toString());
        sb.append("items=").append(String.valueOf(this.items));
        sb.append(", prefixes=").append(String.valueOf(this.prefixes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectVersionCollection)) {
            return false;
        }
        ObjectVersionCollection other = (ObjectVersionCollection)((Object)o);
        return Objects.equals(this.items, other.items) && Objects.equals(this.prefixes, other.prefixes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.prefixes == null ? 43 : this.prefixes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="items")
        private List<ObjectVersionSummary> items;
        @JsonProperty(value="prefixes")
        private List<String> prefixes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder items(List<ObjectVersionSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder prefixes(List<String> prefixes) {
            this.prefixes = prefixes;
            this.__explicitlySet__.add("prefixes");
            return this;
        }

        public ObjectVersionCollection build() {
            ObjectVersionCollection model = new ObjectVersionCollection(this.items, this.prefixes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectVersionCollection model) {
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("prefixes")) {
                this.prefixes(model.getPrefixes());
            }
            return this;
        }
    }
}

