/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.SimpleObjCache;

public class PacUtils {
    public static final int PRECOMPILED_GLOB_CACHE_MAX_ITEMS = 10;
    private static final SimpleObjCache<String, Pattern> PRECOMPILED_GLOB_CACHE = new SimpleObjCache(10);

    public static Pattern createRegexPatternFromGlob(String glob) {
        Pattern pattern = PRECOMPILED_GLOB_CACHE.get(glob);
        if (pattern != null) {
            return pattern;
        }
        StringBuilder out = new StringBuilder();
        out.append("^");
        block7: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*?");
                    continue block7;
                }
                case '?': {
                    out.append(".{1}");
                    continue block7;
                }
                case '.': {
                    out.append("\\.");
                    continue block7;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                case '!': {
                    if (i > 0 && glob.charAt(i - 1) == '[') {
                        out.append('^');
                        continue block7;
                    }
                    out.append(c);
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append("$");
        pattern = Pattern.compile(out.toString());
        PRECOMPILED_GLOB_CACHE.put(glob, pattern);
        return pattern;
    }

    public static <T> String toSemiColonList(List<T> list, Function<T, String> fn) {
        return list.stream().map(i -> (String)fn.apply(i)).collect(Collectors.joining(";"));
    }

    public static <T> String toSemiColonList(List<T> list) {
        return PacUtils.toSemiColonList(list, Object::toString);
    }

    public static String toSemiColonListInetAddress(InetAddress[] addresses) {
        return PacUtils.toSemiColonList(Arrays.asList(addresses), InetAddress::getHostAddress);
    }

    public static String toSemiColonListInetAddress(List<InetAddress> addresses) {
        return PacUtils.toSemiColonList(addresses, InetAddress::getHostAddress);
    }

    public static boolean ipPrefixMatch(InetAddress ipAddress, String ipPrefix) {
        String ipPatternStrC;
        if (ipPrefix.indexOf(47) == -1) {
            return false;
        }
        String[] parts = ipPrefix.trim().split("\\/");
        int bitField = 0;
        try {
            bitField = Integer.parseInt(parts[1].trim());
            if (bitField < 0 || bitField > 128) {
                return false;
            }
            if (ipAddress instanceof Inet4Address && bitField > 32) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        String ipPatternStr = parts[0].trim();
        InetAddress ipPattern = null;
        if (ipAddress instanceof Inet4Address && IpAddressUtils.looksLikeIpv4Literal(ipPatternStr)) {
            try {
                ipPattern = InetAddress.getByName(ipPatternStr);
            }
            catch (UnknownHostException ex) {
                return false;
            }
        }
        if (ipAddress instanceof Inet6Address && IpAddressUtils.looksLikeIpv6Literal(ipPatternStrC = PacUtils.correctIPv6Str(ipPatternStr))) {
            try {
                ipPattern = InetAddress.getByName(ipPatternStrC);
            }
            catch (UnknownHostException ex) {
                return false;
            }
        }
        if (ipPattern == null) {
            return false;
        }
        if (!ipAddress.getClass().equals(ipPattern.getClass())) {
            return false;
        }
        BigInteger mask = BigInteger.valueOf(-1L).shiftLeft(ipPattern.getAddress().length * 8 - bitField);
        BigInteger subnetMask = new BigInteger(ipPattern.getAddress()).and(mask);
        return new BigInteger(ipAddress.getAddress()).and(mask).equals(subnetMask);
    }

    private static String correctIPv6Str(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ':') continue;
            ++counter;
            if (i <= 0 || s.charAt(i - 1) != ':') continue;
            return s;
        }
        if (counter != 7) {
            return s + "::";
        }
        return s;
    }

    public static String toStrippedURLStr(URI uri) {
        String portStr = uri.getPort() == -1 ? "" : ":" + uri.getPort();
        return uri.getScheme() + "://" + uri.getHost() + portStr + "/";
    }
}

