/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.spi.options.OptionsPanelController;
import org.netbeans.swing.laf.flatlaf.FlatLFCustoms;
import org.netbeans.swing.laf.flatlaf.FlatLafOptionsPanel;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class FlatLafOptionsPanelController
extends OptionsPanelController {
    private FlatLafOptionsPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private boolean changed;

    public void update() {
        this.getPanel().load();
        this.changed = false;
    }

    public void applyChanges() {
        if (!this.changed) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            boolean oldUseWindowDecorations = FlatLafPrefs.isUseWindowDecorations();
            boolean oldUnifiedTitleBar = FlatLafPrefs.isUnifiedTitleBar();
            boolean oldMenuBarEmbedded = FlatLafPrefs.isMenuBarEmbedded();
            boolean oldUnderlineMenuSelection = FlatLafPrefs.isUnderlineMenuSelection();
            boolean oldAlwaysShowMnemonics = FlatLafPrefs.isAlwaysShowMnemonics();
            this.getPanel().store();
            this.changed = false;
            UIDefaults defaults = UIManager.getDefaults();
            defaults.put("TitlePane.unifiedBackground", (Object)FlatLafPrefs.isUnifiedTitleBar());
            defaults.put("TitlePane.menuBarEmbedded", (Object)FlatLafPrefs.isMenuBarEmbedded());
            defaults.put("MenuItem.selectionType", FlatLafPrefs.isUnderlineMenuSelection() ? "underline" : null);
            defaults.put("Component.hideMnemonics", (Object)(!FlatLafPrefs.isAlwaysShowMnemonics() ? 1 : 0));
            defaults.put("FileChooser.favorites.enabled", (Object)FlatLafPrefs.isShowFileChooserFavorites());
            FlatLFCustoms.updateUnifiedBackground();
            if (oldUseWindowDecorations != FlatLafPrefs.isUseWindowDecorations()) {
                FlatLaf.setUseNativeWindowDecorations((boolean)FlatLafPrefs.isUseWindowDecorations());
            }
            if (oldMenuBarEmbedded != FlatLafPrefs.isMenuBarEmbedded()) {
                FlatLaf.revalidateAndRepaintAllFramesAndDialogs();
            } else if (oldUnifiedTitleBar != FlatLafPrefs.isUnifiedTitleBar() || oldUnderlineMenuSelection != FlatLafPrefs.isUnderlineMenuSelection() || oldAlwaysShowMnemonics != FlatLafPrefs.isAlwaysShowMnemonics()) {
                FlatLaf.repaintAllFramesAndDialogs();
            }
        });
    }

    public void cancel() {
    }

    public boolean isValid() {
        return this.getPanel().valid();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected FlatLafOptionsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new FlatLafOptionsPanel(this);
        }
        return this.panel;
    }

    protected void changed(boolean isChanged) {
        if (!this.changed) {
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.changed = isChanged;
        this.pcs.firePropertyChange("valid", null, null);
    }
}

