/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.Bundle;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.HistoryRegistry;
import org.netbeans.modules.git.VersionsCache;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.history.HistoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class HistoryProvider
implements VCSHistoryProvider {
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private static final Logger LOG = Logger.getLogger(HistoryProvider.class.getName());
    private Action[] actions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public synchronized VCSHistoryProvider.HistoryEntry[] getHistory(File[] files, Date fromDate) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Set<File> repositories = HistoryProvider.getRepositoryRoots(files);
        if (repositories == null) {
            return null;
        }
        LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
        HashMap<String, HashSet<File>> rev2FileMap = new HashMap<String, HashSet<File>>();
        LinkedHashMap<String, GitRevisionInfo> rev2LMMap = new LinkedHashMap<String, GitRevisionInfo>();
        File repositoryRoot = repositories.iterator().next();
        for (File file : files) {
            FileInformation info = Git.getInstance().getFileStatusCache().getStatus(file);
            if (!info.containsStatus(FileInformation.STATUS_MANAGED)) continue;
            try {
                GitRevisionInfo[] history;
                for (GitRevisionInfo h : history = HistoryRegistry.getInstance().getLogs(repositoryRoot, files, fromDate, null, GitUtils.NULL_PROGRESS_MONITOR)) {
                    String r = h.getRevision();
                    rev2LMMap.put(r, h);
                    HashSet<File> s = (HashSet<File>)rev2FileMap.get(r);
                    if (s == null) {
                        s = new HashSet<File>();
                        rev2FileMap.put(r, s);
                    }
                    s.add(file);
                }
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        for (GitRevisionInfo h : rev2LMMap.values()) {
            Set s = (Set)rev2FileMap.get(h.getRevision());
            File[] involvedFiles = s.toArray(new File[0]);
            VCSHistoryProvider.HistoryEntry e = this.createHistoryEntry(h, involvedFiles, repositoryRoot);
            ret.add(e);
        }
        return ret.toArray(new VCSHistoryProvider.HistoryEntry[0]);
    }

    private VCSHistoryProvider.HistoryEntry createHistoryEntry(GitRevisionInfo h, File[] involvedFiles, File repositoryRoot) {
        GitUser user = h.getAuthor();
        if (user == null) {
            user = h.getCommitter();
        }
        String username = user.getName();
        String author = user.toString();
        String message = h.getFullMessage();
        assert (message != null);
        VCSHistoryProvider.HistoryEntry e = new VCSHistoryProvider.HistoryEntry(involvedFiles, new Date(h.getCommitTime()), message == null ? "" : message, author, username, h.getRevision(), h.getRevision().length() > 7 ? h.getRevision().substring(0, 7) : h.getRevision(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(h.getRevision()), null, (VCSHistoryProvider.ParentProvider)new ParentProviderImpl(h, involvedFiles, repositoryRoot));
        return e;
    }

    public Action createShowHistoryAction(File[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final File[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[0]);
        }
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HistoryProvider.this, files));
                }
            }
        });
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new HistoryAction(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_View")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
                    HistoryProvider.this.view(entry.getRevision(), false, files);
                }
            }, new HistoryAction(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_ShowAnnotations")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
                    HistoryProvider.this.view(entry.getRevision(), true, files);
                }
            }, new HistoryAction(){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
                    File root = Git.getInstance().getRepositoryRoot(files.iterator().next());
                    ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).revertFiles(root, files.toArray(new File[0]), this.getRevisionShort(), Bundle.HistoryProvider_action_RevertTo_progress());
                }

                protected boolean isMultipleHistory() {
                    return false;
                }

                public String getName() {
                    String rev = this.getRevisionShort();
                    if (rev == null) {
                        rev = "";
                    }
                    return Bundle.HistoryProvider_action_RevertTo(rev);
                }

                public boolean isEnabled() {
                    return null != this.getRevisionShort();
                }
            }};
        }
        return this.actions;
    }

    private void view(final String revision, final boolean showAnnotations, final Set<File> files) {
        final File root = Git.getInstance().getRepositoryRoot(files.iterator().next());
        new GitProgressSupport(){

            @Override
            protected void perform() {
                for (File f : files) {
                    File original = HistoryRegistry.getInstance().getHistoryFile(root, f, revision, true);
                    if (original != null) {
                        f = original;
                    }
                    try {
                        GitUtils.openInRevision(f, -1, revision, showAnnotations, this.getProgressMonitor());
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        }.start(Git.getInstance().getRequestProcessor(), root, NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
    }

    private static Set<File> getRepositoryRoots(File ... files) {
        Set<File> repositories = GitUtils.getRepositoryRoots(new HashSet<File>(Arrays.asList(files)));
        if (repositories.size() != 1) {
            LOG.log(Level.WARNING, "History requested for {0} repositories", repositories.size());
            return null;
        }
        return repositories;
    }

    private class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private String revision;

        public RevisionProviderImpl(String revision) {
            this.revision = revision;
        }

        public void getRevisionFile(File originalFile, File revisionFile) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
            try {
                File file;
                Set<File> repositories;
                FileInformation info = Git.getInstance().getFileStatusCache().getStatus(originalFile);
                if (info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX) && info.getOldFile() != null) {
                    originalFile = info.getOldFile();
                }
                if ((repositories = HistoryProvider.getRepositoryRoots(originalFile)) == null || repositories.isEmpty()) {
                    LOG.log(Level.WARNING, "Repository root not found for file {0}", originalFile);
                    return;
                }
                File repository = repositories.iterator().next();
                File historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.revision, true);
                if (historyFile != null) {
                    originalFile = historyFile;
                }
                if ((file = VersionsCache.getInstance().getFileRevision(originalFile, this.revision, GitUtils.NULL_PROGRESS_MONITOR)) != null) {
                    FileUtils.copyFile((File)file, (File)revisionFile);
                } else if (historyFile == null) {
                    LOG.log(Level.WARNING, "File {0} not found in revision {1}. Will make a guess ...", new Object[]{originalFile, this.revision});
                    historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.revision, false);
                    if (historyFile != null && (file = VersionsCache.getInstance().getFileRevision(historyFile, this.revision, GitUtils.NULL_PROGRESS_MONITOR)) != null) {
                        FileUtils.copyFile((File)file, (File)revisionFile);
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
    }

    private class ParentProviderImpl
    implements VCSHistoryProvider.ParentProvider {
        private GitRevisionInfo info;
        private File[] files;
        private File repository;
        private Map<File, VCSHistoryProvider.HistoryEntry> commonAncestors;

        public ParentProviderImpl(GitRevisionInfo info, File[] files, File repository) {
            this.info = info;
            this.files = files;
            this.repository = repository;
            this.commonAncestors = new HashMap<File, VCSHistoryProvider.HistoryEntry>(files.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VCSHistoryProvider.HistoryEntry getParentEntry(File file) {
            VCSHistoryProvider.HistoryEntry ancestorEntry = this.commonAncestors.get(file);
            if (ancestorEntry == null && !this.commonAncestors.containsKey(file)) {
                GitRevisionInfo parent = null;
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(this.repository);
                    if (this.info.getParents().length == 1) {
                        File historyFile;
                        File file2 = historyFile = this.info.getModifiedFiles().containsKey(file) ? file : HistoryRegistry.getInstance().getHistoryFile(this.repository, file, this.info.getRevision(), false);
                        if (historyFile != null) {
                            parent = client.getPreviousRevision(historyFile, this.info.getRevision(), GitUtils.NULL_PROGRESS_MONITOR);
                        }
                    } else if (this.info.getParents().length > 1) {
                        parent = client.getCommonAncestor(this.info.getParents(), GitUtils.NULL_PROGRESS_MONITOR);
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                ancestorEntry = parent == null ? null : HistoryProvider.this.createHistoryEntry(parent, this.files, this.repository);
                this.commonAncestors.put(file, ancestorEntry);
            }
            return ancestorEntry;
        }
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final File[] files;

        public OpenHistoryAction(File[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        private void openHistory(File[] files) {
            if (files == null || files.length == 0) {
                return;
            }
            Set<File> repositories = HistoryProvider.getRepositoryRoots(files);
            if (repositories == null || repositories.isEmpty()) {
                return;
            }
            ArrayList<1> nodes = new ArrayList<1>(files.length);
            for (File f : files) {
                nodes.add(new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{f})){

                    public String getDisplayName() {
                        return ((File)this.getLookup().lookup(File.class)).getName();
                    }
                });
            }
            SearchHistoryAction.openSearch(repositories.iterator().next(), files, Utils.getContextDisplayName((VCSContext)VCSContext.forNodes((Node[])nodes.toArray(new Node[0]))));
        }
    }
}

