/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.CData;
import org.netbeans.modules.xml.xdm.nodes.Comment;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;

public class XMLSyntaxParser {
    public Document parse(BaseDocument basedoc) throws IOException, BadLocationException {
        try {
            basedoc.readLock();
            Stack<NodeImpl> stack = new Stack<NodeImpl>();
            Document doc = new Document();
            stack.push(doc);
            NodeImpl currentNode = doc;
            ArrayList<Token> currentTokens = new ArrayList<Token>();
            TokenHierarchy th = TokenHierarchy.get((javax.swing.text.Document)basedoc);
            TokenSequence tokenSequence = th.tokenSequence();
            org.netbeans.api.lexer.Token token = tokenSequence.token();
            if (token != null && token.id() == XMLTokenId.TEXT) {
                currentTokens.add(Token.create(token.text().toString(), TokenType.TOKEN_CHARACTER_DATA));
                if (tokenSequence.moveNext()) {
                    token = tokenSequence.token();
                }
                if (token.id() != XMLTokenId.PI_START) {
                    currentNode.setTokens(new ArrayList<Token>(currentTokens));
                    currentTokens.clear();
                }
            }
            block19: while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                XMLTokenId tokenId = (XMLTokenId)token.id();
                String image = token.text().toString();
                TokenType tokenType = TokenType.TOKEN_WHITESPACE;
                switch (tokenId) {
                    case PI_START: {
                        tokenType = TokenType.TOKEN_PI_START_TAG;
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case PI_TARGET: {
                        tokenType = TokenType.TOKEN_PI_NAME;
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case PI_CONTENT: {
                        tokenType = TokenType.TOKEN_PI_VAL;
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case PI_END: {
                        tokenType = TokenType.TOKEN_PI_END_TAG;
                        currentTokens.add(Token.create(image, tokenType));
                        if (currentNode instanceof Document) {
                            if (tokenSequence.moveNext()) {
                                org.netbeans.api.lexer.Token t = tokenSequence.token();
                                if (t.id() == XMLTokenId.TEXT) {
                                    currentTokens.add(Token.create(t.text().toString(), TokenType.TOKEN_CHARACTER_DATA));
                                } else {
                                    tokenSequence.movePrevious();
                                }
                            }
                            if (stack.peek() != currentNode) {
                                stack.push(currentNode);
                            }
                        }
                        ArrayList<Token> list = new ArrayList<Token>(currentNode.getTokens());
                        list.addAll(currentTokens);
                        currentNode.setTokens(list);
                        currentTokens.clear();
                        continue block19;
                    }
                    case TAG: {
                        int len = image.length();
                        if (image.charAt(len - 1) == '>') {
                            Token endToken = Token.create(image, TokenType.TOKEN_ELEMENT_END_TAG);
                            if (len == 2) {
                                currentNode = (NodeImpl)stack.pop();
                                endToken = Token.create(image, TokenType.TOKEN_ELEMENT_END_TAG);
                            } else if (!(currentNode instanceof Element)) {
                                currentNode = (NodeImpl)stack.peek();
                            }
                            currentTokens.add(endToken);
                            currentNode.getTokensForWrite().addAll(currentTokens);
                            currentTokens.clear();
                            continue block19;
                        }
                        tokenType = TokenType.TOKEN_ELEMENT_START_TAG;
                        if (image.startsWith("</")) {
                            currentNode = (NodeImpl)stack.pop();
                            if (currentNode.getTokens().isEmpty() || !currentNode.getTokens().get(0).getValue().substring(1).equals(image.substring(2))) {
                                throw new IOException("Invalid token '" + image + "' found in document: Please use the text editor to resolve the issues...");
                            }
                            String saveTokenImage = image;
                            currentTokens.add(Token.create(image, tokenType));
                            tokenSequence.moveNext();
                            org.netbeans.api.lexer.Token t = tokenSequence.token();
                            while (t != null) {
                                if (t.id() != XMLTokenId.WS) {
                                    tokenSequence.movePrevious();
                                    break;
                                }
                                tokenType = TokenType.TOKEN_WHITESPACE;
                                currentTokens.add(Token.create(t.text().toString(), tokenType));
                                if (!tokenSequence.moveNext()) break;
                                t = tokenSequence.token();
                            }
                            if (t != null && t.text().toString().equals(">")) continue block19;
                            throw new IOException("Invalid token '" + saveTokenImage + "' does not end with '>': Please use the text editor to resolve the issues...");
                        }
                        currentNode = new Element();
                        Node parent = (Node)stack.peek();
                        if (parent instanceof Document && ((Document)parent).getDocumentElement() != null) {
                            throw new IOException("Invalid XML document: Cannot have multiple root elements.");
                        }
                        parent.appendChild(currentNode);
                        stack.push(currentNode);
                        currentTokens.add(Token.create(image, tokenType));
                        currentNode.setTokens(new ArrayList<Token>(currentTokens));
                        currentTokens.clear();
                        continue block19;
                    }
                    case ARGUMENT: {
                        tokenType = TokenType.TOKEN_ATTR_NAME;
                        currentNode = new Attribute();
                        Element parent = (Element)stack.peek();
                        parent.appendAttribute((Attribute)currentNode);
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case VALUE: {
                        tokenType = TokenType.TOKEN_ATTR_VAL;
                        while (tokenSequence.moveNext()) {
                            org.netbeans.api.lexer.Token t = tokenSequence.token();
                            if (t.id() != XMLTokenId.VALUE && t.id() != XMLTokenId.CHARACTER) {
                                tokenSequence.movePrevious();
                                break;
                            }
                            image = image.concat(t.text().toString());
                        }
                        currentTokens.add(Token.create(image, tokenType));
                        currentNode.setTokens(new ArrayList<Token>(currentTokens));
                        currentTokens.clear();
                        continue block19;
                    }
                    case BLOCK_COMMENT: {
                        tokenType = TokenType.TOKEN_COMMENT;
                        Node parent = (Node)stack.peek();
                        currentTokens.add(Token.create(image, tokenType));
                        if (!image.endsWith(Token.COMMENT_END.getValue())) continue block19;
                        String combinedString = this.combineString(currentTokens);
                        Comment comment = new Comment(combinedString);
                        if (parent instanceof Element) {
                            ((Element)parent).appendChild(comment, false);
                        } else {
                            if (token.id() != XMLTokenId.BLOCK_COMMENT && token.text().toString().trim().length() > 0) {
                                throw new IOException("Invalid token '" + token.text() + "' found in document: Please use the text editor to resolve the issues...");
                            }
                            parent.appendChild(comment);
                        }
                        currentTokens.clear();
                        continue block19;
                    }
                    case TEXT: 
                    case CHARACTER: {
                        tokenType = TokenType.TOKEN_CHARACTER_DATA;
                        currentNode = new Text();
                        currentTokens.add(Token.create(image, tokenType));
                        if (token.id() == XMLTokenId.TEXT) {
                            while (tokenSequence.moveNext()) {
                                org.netbeans.api.lexer.Token t = tokenSequence.token();
                                if (t.id() != XMLTokenId.TEXT && t.id() != XMLTokenId.CHARACTER) {
                                    tokenSequence.movePrevious();
                                    break;
                                }
                                currentTokens.add(Token.create(t.text().toString(), tokenType));
                            }
                        }
                        currentNode.setTokens(new ArrayList<Token>(currentTokens));
                        Node parent = (Node)stack.peek();
                        if (parent instanceof Element) {
                            ((Element)parent).appendChild(currentNode, false);
                        } else {
                            if (token.id() != XMLTokenId.BLOCK_COMMENT && token.text().toString().trim().length() > 0) {
                                throw new IOException("Invalid token '" + token.text() + "' found in document: Please use the text editor to resolve the issues...");
                            }
                            parent.appendChild(currentNode);
                        }
                        currentTokens.clear();
                        continue block19;
                    }
                    case WS: {
                        tokenType = TokenType.TOKEN_WHITESPACE;
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case OPERATOR: {
                        tokenType = TokenType.TOKEN_ATTR_EQUAL;
                        currentTokens.add(Token.create(image, tokenType));
                        continue block19;
                    }
                    case DECLARATION: {
                        tokenType = TokenType.TOKEN_DTD_VAL;
                        currentTokens.add(Token.create(image, tokenType));
                        while (tokenSequence.moveNext()) {
                            org.netbeans.api.lexer.Token t = tokenSequence.token();
                            XMLTokenId id = (XMLTokenId)t.id();
                            if (id != XMLTokenId.DECLARATION && id != XMLTokenId.VALUE) {
                                tokenSequence.movePrevious();
                                continue block19;
                            }
                            currentTokens.add(Token.create(t.text().toString(), tokenType));
                        }
                        continue block19;
                    }
                    case CDATA_SECTION: {
                        Node parent = (Node)stack.peek();
                        CData cdata = new CData(image);
                        if (!(parent instanceof Element)) {
                            throw new IOException("CDATA is not valid as direct child of documentPlease use the text editor to resolve the issues...");
                        }
                        ((Element)parent).appendChild(cdata, false);
                        tokenType = TokenType.TOKEN_CDATA_VAL;
                        continue block19;
                    }
                }
                throw new IOException("Invalid token found in document: Please use the text editor to resolve the issues...");
            }
            Node result = (Node)stack.pop();
            if (result instanceof Document) {
                Document document = (Document)result;
                return document;
            }
            throw new IOException("Document not well formed/Invalid: Please use the text editor to resolve the issues...");
        }
        finally {
            basedoc.readUnlock();
        }
    }

    private String combineString(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token t : tokens) {
            sb.append(t.getValue());
        }
        return sb.toString();
    }
}

