/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.spi;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssCompletion;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssValueElement;
import org.netbeans.modules.css.lib.api.CssColor;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.css.lib.api.properties.ValueGrammarElement;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.ui.api.WebUIUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class CssCompletionItem
extends DefaultCompletionProposal {
    private int anchorOffset;
    private String value;
    private ElementHandle element;
    protected boolean addSemicolon;
    protected static final int SORT_PRIORITY = 300;

    public static CssCompletionItem createValueCompletionItem(CssValueElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ValueCompletionItem(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createValueCompletionItem(CssValueElement element, ValueGrammarElement value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ValueCompletionItem(element, value.getValue(), origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createValueCompletionItem(CssValueElement element, GrammarElement value, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ValueCompletionItem(element, value.toString(), value.getVisibleOrigin(), anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createColorValueCompletionItem(CssValueElement element, GrammarElement value, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
        return new ColorCompletionItem(element, value.toString(), value.getVisibleOrigin(), anchorOffset, addSemicolon, addSpaceBeforeItem);
    }

    public static CssCompletionItem createPropertyCompletionItem(CssElement element, PropertyDefinition property, String propertyInsertPrefix, int anchorOffset, boolean addSemicolon) {
        return new PropertyCompletionItem(element, property, propertyInsertPrefix, anchorOffset, addSemicolon);
    }

    public static CssCompletionItem createRAWCompletionItem(CssElement element, String value, ElementKind kind, int anchorOffset, boolean addSemicolon) {
        return new RAWCompletionItem(element, kind, value, anchorOffset, addSemicolon);
    }

    public static CssCompletionItem createHashColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem, boolean usedInCurrentFile) {
        return new HashColorCompletionItem(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem, usedInCurrentFile);
    }

    public static CompletionProposal createColorChooserCompletionItem(int anchor, String origin, boolean addSemicolon) {
        return new ColorChooserItem(anchor, origin, addSemicolon);
    }

    public static CssCompletionItem createSelectorCompletionItem(CssElement element, String value, int anchorOffset, boolean related) {
        return CssCompletionItem.createSelectorCompletionItem(element, value, anchorOffset, related, false);
    }

    public static CssCompletionItem createSelectorCompletionItem(CssElement element, String value, int anchorOffset, boolean related, boolean escape) {
        return new SelectorCompletionItem(element, value, anchorOffset, related, escape);
    }

    public static CssCompletionItem createFileCompletionItem(CssElement element, String value, int anchorOffset, Color color, ImageIcon icon, boolean addQuotes, boolean addSemicolon) {
        return new FileCompletionItem(element, value, anchorOffset, color, icon, addQuotes, addSemicolon);
    }

    public static CompletionProposal createUnitCompletionItem(UnitGrammarElement element) {
        return new UnitItem(element);
    }

    private CssCompletionItem() {
    }

    protected CssCompletionItem(ElementHandle element, String value, int anchorOffset, boolean addSemicolon) {
        this.anchorOffset = anchorOffset;
        this.value = value;
        this.element = element;
        this.addSemicolon = addSemicolon;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public String getName() {
        return this.value;
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.appendText(this.getName());
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSmart() {
        return false;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public int getSortPrioOverride() {
        return 300;
    }

    static class ValueCompletionItem
    extends CssCompletionItem {
        private String origin;
        private boolean addSpaceBeforeItem;

        private ValueCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
            super(element, value, anchorOffset, addSemicolon);
            this.origin = origin;
            this.addSpaceBeforeItem = addSpaceBeforeItem;
        }

        public ElementKind getKind() {
            return ElementKind.GLOBAL;
        }

        @Override
        public String getInsertPrefix() {
            return (this.addSpaceBeforeItem && this.textsStartsWith(this.getName()) ? " " : "") + this.getName() + (this.addSemicolon ? ";" : "");
        }

        private boolean textsStartsWith(String text) {
            char ch = text.charAt(0);
            return Character.isLetterOrDigit(ch);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return "<font color=999999>" + (this.origin == null ? "" : this.origin) + "</font>";
        }
    }

    static class ColorCompletionItem
    extends ValueCompletionItem {
        private ColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem) {
            super(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
        }

        @Override
        public ImageIcon getIcon() {
            CssColor color = CssColor.getColor((String)this.getName());
            return WebUIUtils.createColorIcon((String)(color == null ? null : color.colorCode()));
        }
    }

    static class PropertyCompletionItem
    extends CssCompletionItem {
        private String propertyInsertPrefix;
        private PropertyDefinition property;
        private boolean vendorProperty;

        private PropertyCompletionItem(CssElement element, PropertyDefinition property, String propertyInsertPrefix, int anchorOffset, boolean addSemicolon) {
            super(element, property.getName(), anchorOffset, addSemicolon);
            this.property = property;
            this.propertyInsertPrefix = propertyInsertPrefix;
            this.vendorProperty = Css3Utils.isVendorSpecificProperty(property.getName());
        }

        @Override
        public int getSortPrioOverride() {
            return this.vendorProperty ? super.getSortPrioOverride() + 50 : super.getSortPrioOverride();
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.vendorProperty) {
                formatter.appendHtml("<i>");
                formatter.appendText(this.getName());
                formatter.appendHtml("</i>");
                return formatter.getText();
            }
            return super.getLhsHtml(formatter);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.appendHtml("<font color=999999>");
            formatter.appendText(this.property.getPropertyCategory().getDisplayName());
            formatter.appendHtml("</font>");
            return formatter.getText();
        }

        @Override
        public String getInsertPrefix() {
            return this.propertyInsertPrefix + ": ";
        }
    }

    static class RAWCompletionItem
    extends CssCompletionItem {
        private ElementKind kind;

        public RAWCompletionItem(CssElement element, ElementKind kind, String value, int anchorOffset, boolean addSemicolon) {
            super(element, value, anchorOffset, addSemicolon);
            this.kind = kind;
        }

        public ElementKind getKind() {
            return this.kind;
        }
    }

    static class HashColorCompletionItem
    extends ColorCompletionItem {
        private static final int HASH_COLOR_SORT_PRIORITY = 290;
        private boolean usedInCurrentFile;

        private HashColorCompletionItem(CssElement element, String value, String origin, int anchorOffset, boolean addSemicolon, boolean addSpaceBeforeItem, boolean usedInCurrentFile) {
            super(element, value, origin, anchorOffset, addSemicolon, addSpaceBeforeItem);
            this.usedInCurrentFile = usedInCurrentFile;
        }

        @Override
        public ImageIcon getIcon() {
            return WebUIUtils.createColorIcon((String)this.getName().substring(1));
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            return (this.usedInCurrentFile ? "" : "<font color=999999>") + this.getName() + (this.usedInCurrentFile ? "" : "</font>");
        }

        @Override
        public int getSortPrioOverride() {
            return 290 - (this.usedInCurrentFile ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            HashColorCompletionItem other = (HashColorCompletionItem)((Object)obj);
            return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            return hash;
        }
    }

    static class ColorChooserItem
    extends DefaultCompletionProposal {
        private static JColorChooser COLOR_CHOOSER;
        private Color color;
        private boolean addSemicolon;
        private String origin;

        private ColorChooserItem(int anchor, String origin, boolean addSemicolon) {
            this.anchorOffset = anchor;
            this.addSemicolon = addSemicolon;
            this.origin = origin;
        }

        private static synchronized JColorChooser getColorChooser() {
            if (COLOR_CHOOSER == null) {
                COLOR_CHOOSER = new JColorChooser();
            }
            return COLOR_CHOOSER;
        }

        public boolean beforeDefaultAction() {
            final JColorChooser colorChooser = ColorChooserItem.getColorChooser();
            JDialog dialog = JColorChooser.createDialog(EditorRegistry.lastFocusedComponent(), NbBundle.getMessage(CssCompletion.class, (String)"MSG_Choose_Color"), true, colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    color = colorChooser.getColor();
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    color = null;
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
            return this.color == null;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return new CssElement(null);
        }

        public ElementKind getKind() {
            return this.getElement().getKind();
        }

        public ImageIcon getIcon() {
            Color c = ColorChooserItem.getColorChooser().getColor();
            String colorCode = c == null ? "ffffff" : WebUIUtils.toHexCode((Color)c).substring(1);
            return WebUIUtils.createColorIcon((String)colorCode);
        }

        public String getName() {
            return this.color == null ? "$color_chooser" : WebUIUtils.toHexCode((Color)this.color) + (this.addSemicolon ? ";" : "");
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            return "<b>" + NbBundle.getMessage(CssCompletion.class, (String)"MSG_OpenColorChooser") + "</b>";
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return "<font color=999999>" + this.origin + "</font>";
        }

        public boolean isSmart() {
            return true;
        }
    }

    static class SelectorCompletionItem
    extends CssCompletionItem {
        private static final String RELATED_SELECTOR_COLOR = "007c00";
        private static final String GRAY_COLOR_CODE = Integer.toHexString(Color.GRAY.getRGB()).substring(2);
        private final boolean related;
        private final String displayName;

        private SelectorCompletionItem(CssElement element, String value, int anchorOffset, boolean related, boolean escape) {
            super(element, escape ? SelectorCompletionItem.escape(value) : value, anchorOffset, false);
            this.displayName = value;
            this.related = related;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            StringBuilder buf = new StringBuilder();
            if (this.related) {
                buf.append("<b><font color=#");
                buf.append(RELATED_SELECTOR_COLOR);
            } else {
                buf.append("<font color=#");
                buf.append(GRAY_COLOR_CODE);
            }
            buf.append(">");
            buf.append(this.displayName);
            buf.append("</font>");
            if (this.related) {
                buf.append("</b>");
            }
            formatter.appendHtml(buf.toString());
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        @Override
        public int getSortPrioOverride() {
            return super.getSortPrioOverride() - (this.related ? 1 : 0);
        }

        static String escape(String input) {
            if (input == null) {
                return null;
            }
            StringBuilder result = new StringBuilder(input.length());
            boolean limitedSet = true;
            for (int offset = 0; offset < input.length(); offset += Character.charCount(input.codePointAt(offset))) {
                int entry = input.codePointAt(offset);
                boolean mustBeEscaped = false;
                if (limitedSet) {
                    if (!(entry == 95 || entry >= 97 && entry <= 122 || entry >= 65 && entry <= 90 || entry == 45)) {
                        mustBeEscaped = true;
                    }
                    limitedSet = offset == 0 || entry == 45;
                } else if (!(entry == 95 || entry >= 97 && entry <= 122 || entry >= 65 && entry <= 90 || entry >= 48 && entry <= 57 || entry == 45)) {
                    mustBeEscaped = true;
                }
                if (mustBeEscaped) {
                    result.append("\\");
                    if (entry > 127 || Character.isWhitespace(entry) || Character.isISOControl(entry)) {
                        result.append(String.format("%06x", entry));
                        continue;
                    }
                    result.appendCodePoint(entry);
                    continue;
                }
                result.appendCodePoint(entry);
            }
            return result.toString();
        }
    }

    private static class FileCompletionItem
    extends CssCompletionItem {
        private final ImageIcon icon;
        private final String colorCode;
        private final boolean addQuotes;

        private FileCompletionItem(CssElement element, String value, int anchorOffset, Color color, ImageIcon icon, boolean addQuotes, boolean addSemicolon) {
            super(element, value, anchorOffset, false);
            this.icon = icon;
            this.colorCode = color == null ? null : WebUIUtils.toHexCode((Color)color).substring(1);
            this.addQuotes = addQuotes;
            this.addSemicolon = addSemicolon;
        }

        public boolean beforeDefaultAction() {
            FileObject file = this.getElement().getFileObject();
            if (file != null && file.isFolder()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ParserManager.parse((String)"text/css", (UserTask)new UserTask(){

                                public void run(ResultIterator ri) {
                                    Completion.get().showCompletion();
                                }
                            });
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, 200);
            }
            return false;
        }

        @Override
        public ImageIcon getIcon() {
            return this.icon;
        }

        public ElementKind getKind() {
            return ElementKind.FILE;
        }

        @Override
        public String getInsertPrefix() {
            StringBuilder b = new StringBuilder();
            if (this.addQuotes) {
                b.append('\"');
            }
            b.append(this.getName());
            FileObject file = this.getElement().getFileObject();
            if (file != null && file.isFolder()) {
                b.append(Css3Utils.FILE_SEPARATOR);
            }
            if (this.addQuotes) {
                b.append('\"');
            }
            if (this.addSemicolon) {
                b.append(';');
            }
            return b.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.colorCode != null) {
                formatter.appendHtml(String.format("<font color=\"%s\">", this.colorCode));
            }
            formatter.appendText(this.getName());
            if (this.colorCode != null) {
                formatter.appendHtml("</font>");
            }
            return formatter.getText();
        }
    }

    static class UnitItem
    extends DefaultCompletionProposal {
        private UnitGrammarElement element;

        private UnitItem(UnitGrammarElement element) {
            this.element = element;
        }

        public boolean beforeDefaultAction() {
            return true;
        }

        public ElementHandle getElement() {
            return new CssElement(null);
        }

        public ElementKind getKind() {
            return ElementKind.FIELD;
        }

        public String getName() {
            return this.element.getValue().toString();
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            return "<font color=#aaaaaa>" + this.element.getTokenAcceptorId() + "</font>";
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return "<font color=999999>" + this.element.getVisibleOrigin() + "</font>";
        }

        public boolean isSmart() {
            return false;
        }
    }
}

