/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.refactoring.dependency.Bundle;
import org.netbeans.modules.maven.refactoring.dependency.RewriteContext;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;

public class DependencyAdder {
    private final Project project;
    private final DependencyChange request;
    private final RewriteContext rewrite;
    private List<Dependency> accepted = new ArrayList<Dependency>();
    protected Map<Dependency, Dependency> offending = new HashMap<Dependency, Dependency>();
    DependencyResult current;

    public DependencyAdder(Project project, DependencyChange request, RewriteContext rewrite) {
        this.project = project;
        this.request = request;
        this.rewrite = rewrite;
    }

    protected void throwDependencyConflicts() throws DependencyChangeException {
        if (!this.offending.isEmpty()) {
            throw new DependencyChangeException(this.request, DependencyChangeException.Reason.CONFLICT, this.offending);
        }
    }

    protected void throwUnknownScope(Dependency d) throws DependencyChangeException {
        throw new DependencyChangeException(this.request, d, DependencyChangeException.Reason.MALFORMED);
    }

    protected void recordConflict(Dependency requested, Dependency existing) {
        if (!this.request.getOptions().contains(DependencyChange.Options.skipConflicts)) {
            this.offending.putIfAbsent(requested, existing);
        }
    }

    protected boolean checkDependencyConflicts(Dependency existing, Dependency d) throws DependencyChangeException {
        String existingScope;
        ArtifactSpec existingA = existing.getArtifact();
        ArtifactSpec toAdd = d.getArtifact();
        if (!existingA.getGroupId().equals(toAdd.getGroupId()) || !existingA.getArtifactId().equals(toAdd.getArtifactId())) {
            return true;
        }
        String existingC = existingA.getClassifier();
        if (existingA != null && !Objects.equals(existingC, toAdd.getClassifier())) {
            return true;
        }
        String mavenScope = this.rewrite.mavenScope(d);
        if (!mavenScope.equals(existingScope = this.rewrite.mavenScope(existing))) {
            return true;
        }
        this.recordConflict(d, existing);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws DependencyChangeException {
        this.current = ProjectDependencies.findDependencies((Project)this.project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.DECLARED}));
        try {
            POMModel mutableModel = this.rewrite.getWriteModel();
            for (Dependency d : this.request.getDependencies()) {
                boolean toAccept = true;
                for (Dependency c : this.current.getRoot().getChildren()) {
                    if (this.checkDependencyConflicts(c, d)) continue;
                    toAccept = false;
                    break;
                }
                if (!toAccept) continue;
                this.accepted.add(d);
            }
            this.throwDependencyConflicts();
            mutableModel.sync();
            mutableModel.startTransaction();
            boolean ok = false;
            try {
                for (Dependency d : this.accepted) {
                    String scope;
                    ArtifactSpec a = d.getArtifact();
                    org.netbeans.modules.maven.model.pom.Dependency mavenDep = mutableModel.getFactory().createDependency();
                    mavenDep.setGroupId(a.getGroupId());
                    mavenDep.setArtifactId(a.getArtifactId());
                    if (a.getVersionSpec() != null && !a.getVersionSpec().isEmpty()) {
                        mavenDep.setVersion(a.getVersionSpec());
                    }
                    if (a.getClassifier() != null) {
                        mavenDep.setClassifier(a.getClassifier());
                    }
                    if (!"compile".equals(scope = this.rewrite.mavenScope(d))) {
                        mavenDep.setScope(scope);
                    }
                    mutableModel.getProject().addDependency(mavenDep);
                }
                mutableModel.endTransaction();
                ok = true;
            }
            finally {
                if (!ok) {
                    mutableModel.rollbackTransaction();
                }
            }
        }
        catch (IOException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNSUPPORTED, Bundle.ERR_CannotModifyProject(this.rewrite.getPomFile()));
        }
        catch (IllegalArgumentException | IllegalStateException | UnsupportedOperationException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_AddingDependency(), (Throwable)ex);
        }
    }
}

