/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.Bundle;
import org.netbeans.modules.maven.graph.GraphConstructor;
import org.netbeans.modules.maven.graph.MavenActionsProvider;
import org.netbeans.modules.maven.graph.MavenDependencyNode;
import org.netbeans.modules.maven.graph.ScopesVisitor;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class DependencyGraphTopComponent
extends TopComponent
implements LookupListener,
MultiViewElement {
    private static final String ZOOM_IN_ICON = "org/netbeans/modules/maven/graph/zoomin.gif";
    private static final String ZOOM_OUT_ICON = "org/netbeans/modules/maven/graph/zoomout.gif";
    private static final int COMPLEXITY_LIMIT = 30;
    private static final Logger LOG = Logger.getLogger(DependencyGraphTopComponent.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DependencyGraphTopComponent.class);
    private boolean everDisplayed;
    private boolean needsRefresh;
    private final RequestProcessor.Task task_reload = RP.create(new Runnable(){

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MavenProject prj;
                    Iterator it2 = DependencyGraphTopComponent.this.result2.allInstances().iterator();
                    MavenProject mavenProject = prj = it2.hasNext() ? (MavenProject)it2.next() : null;
                    if (prj != null && NbMavenProject.isErrorPlaceholder((MavenProject)prj)) {
                        DependencyGraphTopComponent.this.setPaneText(Bundle.Err_CannotLoad(), false);
                        return;
                    }
                    if (prj != null) {
                        if (DependencyGraphTopComponent.this.isVisible() || prj.getArtifacts().size() < 30) {
                            DependencyGraphTopComponent.this.btnGraphActionPerformed(null);
                            return;
                        }
                        DependencyGraphTopComponent.this.needsRefresh = true;
                    }
                }
            });
        }
    });
    private final Map<Artifact, Icon> projectIcons;
    private Lookup.Result<DependencyNode> result;
    private Lookup.Result<MavenProject> result2;
    private Lookup.Result<POMModel> result3;
    private DependencyGraphScene<MavenDependencyNode> scene;
    private MultiViewElementCallback callback;
    final JScrollPane pane = new JScrollPane();
    private Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DependencyGraphTopComponent.this.checkFindValue();
        }
    });
    private JToolBar toolbar;
    private JButton btnBigger;
    private JButton btnGraph;
    private JButton btnSmaller;
    private JComboBox comScopes;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JLabel lblFind;
    private JLabel lblPath;
    private JLabel lblScopes;
    private JSpinner maxPathSpinner;
    private JTextField txtFind;
    private boolean expectingChanges;

    public static MultiViewElement forPOM(Lookup editor) {
        class L
        extends ProxyLookup
        implements PropertyChangeListener {
            Project p;
            final /* synthetic */ Lookup val$editor;

            L(Lookup lookup) {
                this.val$editor = lookup;
                FileObject pom = (FileObject)this.val$editor.lookup(FileObject.class);
                if (pom != null) {
                    this.p = FileOwnerQuery.getOwner((FileObject)pom);
                    if (this.p != null) {
                        NbMavenProject nbmp = (NbMavenProject)this.p.getLookup().lookup(NbMavenProject.class);
                        if (nbmp != null) {
                            nbmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nbmp));
                            this.reset();
                        } else {
                            LOG.log(Level.WARNING, "not a Maven project: {0}", this.p);
                        }
                    } else {
                        LOG.log(Level.WARNING, "no owner of {0}", pom);
                    }
                } else {
                    LOG.log(Level.WARNING, "no FileObject in {0}", this.val$editor);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    this.reset();
                }
            }

            private void reset() {
                ArtifactViewerFactory avf = (ArtifactViewerFactory)Lookup.getDefault().lookup(ArtifactViewerFactory.class);
                if (avf != null) {
                    Lookup l = null;
                    try {
                        l = avf.createLookup(this.p);
                    }
                    catch (InvalidArtifactRTException e) {
                        LOG.log(Level.WARNING, "problems while creating lookup for {" + this.p + "} : " + e.getMessage(), e);
                    }
                    if (l != null) {
                        this.setLookups(new Lookup[]{l});
                    } else {
                        LOG.log(Level.WARNING, "no artifact lookup for {0}", this.p);
                    }
                } else {
                    LOG.warning("no ArtifactViewerFactory found");
                }
            }
        }
        return new DependencyGraphTopComponent((Lookup)new L(editor));
    }

    public DependencyGraphTopComponent(Lookup lookup) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, ((Object)((Object)this)).hashCode() + " created: " + lookup, new Exception());
        }
        this.projectIcons = this.getIconsForOpenProjects();
        this.associateLookup(lookup);
        this.initComponents();
        this.timer.setDelay(500);
        this.timer.setRepeats(false);
        this.txtFind.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                DependencyGraphTopComponent.this.timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                DependencyGraphTopComponent.this.timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                DependencyGraphTopComponent.this.timer.restart();
            }
        });
        this.comScopes.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                int scopesSize = ((List)value).size();
                String msg = scopesSize == 0 ? Bundle.LBL_Scope_All() : (scopesSize == 2 ? Bundle.LBL_Scope_Compile() : (scopesSize == 3 ? Bundle.LBL_Scope_Runtime() : Bundle.LBL_Scope_Test()));
                return super.getListCellRendererComponent((JList<?>)list, msg, index, isSelected, cellHasFocus);
            }
        });
        DefaultComboBoxModel<List<String>> mdl = new DefaultComboBoxModel<List<String>>();
        mdl.addElement(Arrays.asList(new String[0]));
        mdl.addElement(Arrays.asList("provided", "compile"));
        mdl.addElement(Arrays.asList("provided", "compile", "runtime"));
        mdl.addElement(Arrays.asList("provided", "compile", "runtime", "test"));
        this.comScopes.setModel(mdl);
        this.comScopes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DependencyGraphTopComponent.this.scene != null) {
                    List selected = (List)DependencyGraphTopComponent.this.comScopes.getSelectedItem();
                    ScopesVisitor vis = new ScopesVisitor(DependencyGraphTopComponent.this.scene, selected);
                    vis.accept((MavenDependencyNode)DependencyGraphTopComponent.this.scene.getRootGraphNode().getImpl());
                    DependencyGraphTopComponent.this.scene.validate();
                    DependencyGraphTopComponent.this.scene.repaint();
                    DependencyGraphTopComponent.this.revalidate();
                    DependencyGraphTopComponent.this.repaint();
                }
            }
        });
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private void checkFindValue() {
        String val = this.txtFind.getText().trim();
        if ("".equals(val)) {
            val = null;
        }
        this.scene.setSearchString(val);
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        super.componentOpened();
        this.pane.setWheelScrollingEnabled(true);
        this.add(this.pane, "Center");
        this.result = this.getLookup().lookupResult(DependencyNode.class);
        this.result.addLookupListener((LookupListener)this);
        this.result2 = this.getLookup().lookupResult(MavenProject.class);
        this.result2.addLookupListener((LookupListener)this);
        this.result3 = this.getLookup().lookupResult(POMModel.class);
        this.result3.addLookupListener((LookupListener)this);
        this.waitForApproval();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.btnGraphActionPerformed(null);
        }
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.btnGraph = new JButton();
        this.btnBigger = new JButton();
        this.btnSmaller = new JButton();
        this.lblFind = new JLabel();
        this.txtFind = new JTextField();
        this.lblPath = new JLabel();
        this.maxPathSpinner = new JSpinner();
        this.lblScopes = new JLabel();
        this.comScopes = new JComboBox();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btnGraph, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.btnGraph.text"));
        this.btnGraph.setFocusable(false);
        this.btnGraph.setHorizontalTextPosition(0);
        this.btnGraph.setVerticalTextPosition(3);
        this.btnGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependencyGraphTopComponent.this.btnGraphActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnGraph);
        this.btnBigger.setIcon(ImageUtilities.loadImageIcon((String)ZOOM_IN_ICON, (boolean)true));
        this.btnBigger.setFocusable(false);
        this.btnBigger.setHorizontalTextPosition(0);
        this.btnBigger.setVerticalTextPosition(3);
        this.btnBigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependencyGraphTopComponent.this.btnBiggerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnBigger);
        this.btnSmaller.setIcon(ImageUtilities.loadImageIcon((String)ZOOM_OUT_ICON, (boolean)true));
        this.btnSmaller.setFocusable(false);
        this.btnSmaller.setHorizontalTextPosition(0);
        this.btnSmaller.setVerticalTextPosition(3);
        this.btnSmaller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependencyGraphTopComponent.this.btnSmallerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSmaller);
        Mnemonics.setLocalizedText((JLabel)this.lblFind, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblFind.text"));
        this.jToolBar1.add(this.lblFind);
        this.txtFind.setMaximumSize(new Dimension(200, 22));
        this.txtFind.setMinimumSize(new Dimension(50, 19));
        this.txtFind.setPreferredSize(new Dimension(150, 22));
        this.txtFind.setFont(new Font("Arial", 0, 11));
        this.jToolBar1.add(this.txtFind);
        this.jPanel1.add(this.jToolBar1);
        this.lblPath.setLabelFor(this.maxPathSpinner);
        Mnemonics.setLocalizedText((JLabel)this.lblPath, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblPath.text"));
        this.lblPath.setToolTipText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.maxPathSpinner.toolTipText"));
        this.jPanel1.add(this.lblPath);
        this.maxPathSpinner.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.maxPathSpinner.setToolTipText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.maxPathSpinner.toolTipText"));
        this.maxPathSpinner.setRequestFocusEnabled(false);
        this.maxPathSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DependencyGraphTopComponent.this.maxPathSpinnerStateChanged(evt);
            }
        });
        this.jPanel1.add(this.maxPathSpinner);
        Mnemonics.setLocalizedText((JLabel)this.lblScopes, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblScopes.text"));
        this.jPanel1.add(this.lblScopes);
        this.jPanel1.add(this.comScopes);
        this.add(this.jPanel1, "North");
    }

    private void btnSmallerActionPerformed(ActionEvent evt) {
        this.scene.setMyZoomFactor(this.scene.getZoomFactor() * 0.8);
        this.scene.validate();
        this.scene.repaint();
        if (!this.pane.getHorizontalScrollBar().isVisible() && !this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void btnBiggerActionPerformed(ActionEvent evt) {
        this.scene.setMyZoomFactor(this.scene.getZoomFactor() * 1.2);
        this.scene.validate();
        this.scene.repaint();
        if (this.pane.getHorizontalScrollBar().isVisible() || this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void maxPathSpinnerStateChanged(ChangeEvent evt) {
        this.scene.highlightDepth(this.getSelectedDepth());
    }

    private void btnGraphActionPerformed(ActionEvent evt) {
        this.btnGraph.setEnabled(false);
        this.createScene();
    }

    private int getSelectedDepth() {
        return ((SpinnerNumberModel)this.maxPathSpinner.getModel()).getNumber().intValue();
    }

    void saveChanges(POMModel model) throws IOException {
        LOG.log(Level.FINE, "{0} saveChanges...", ((Object)((Object)this)).hashCode());
        assert (!this.expectingChanges);
        this.expectingChanges = true;
        try {
            Utilities.saveChanges((AbstractDocumentModel)model);
        }
        finally {
            this.expectingChanges = false;
            LOG.log(Level.FINE, "{0} saveChanges...done", ((Object)((Object)this)).hashCode());
        }
    }

    public void resultChanged(LookupEvent ev) {
        if (this.expectingChanges) {
            LOG.log(Level.FINE, "{0} expecting change", ((Object)((Object)this)).hashCode());
            return;
        }
        LOG.log(Level.FINE, ((Object)((Object)this)).hashCode() + " not expecting change", new Exception());
        this.task_reload.schedule(200);
    }

    JScrollPane getScrollPane() {
        return this.pane;
    }

    private void waitForApproval() {
        this.setPaneText(this.everDisplayed ? Bundle.LBL_waiting_for_approval_dirty() : Bundle.LBL_waiting_for_approval_first_time(), false);
        this.btnGraph.setEnabled(true);
        this.maxPathSpinner.setEnabled(false);
        this.maxPathSpinner.setVisible(false);
        this.lblPath.setVisible(false);
        this.txtFind.setEnabled(false);
        this.btnBigger.setEnabled(false);
        this.btnSmaller.setEnabled(false);
        this.comScopes.setEnabled(false);
    }

    private void createScene() {
        MavenProject prj;
        Iterator it1 = this.result.allInstances().iterator();
        Iterator it2 = this.result2.allInstances().iterator();
        Iterator it3 = this.result3.allInstances().iterator();
        MavenProject mavenProject = prj = it2.hasNext() ? (MavenProject)it2.next() : null;
        if (prj != null && NbMavenProject.isErrorPlaceholder((MavenProject)prj)) {
            this.setPaneText(Bundle.Err_CannotLoad(), false);
            return;
        }
        Optional.ofNullable(this.scene).ifPresent(s -> s.resetHighlight());
        this.everDisplayed = true;
        this.setPaneText(Bundle.LBL_Loading(), true);
        final Project nbProj = (Project)this.getLookup().lookup(Project.class);
        if (prj != null && it1.hasNext()) {
            final MavenDependencyNode root = new MavenDependencyNode((DependencyNode)it1.next());
            final POMModel model = it3.hasNext() ? (POMModel)it3.next() : null;
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DependencyGraphScene.VersionProvider<MavenDependencyNode> versionProvider = new DependencyGraphScene.VersionProvider<MavenDependencyNode>(){

                        public String getVersion(MavenDependencyNode dependencyNode) {
                            return dependencyNode.getVersion();
                        }

                        public int compareVersions(MavenDependencyNode dependencyNode1, MavenDependencyNode dependencyNode2) {
                            return dependencyNode1.compareVersions(dependencyNode2);
                        }

                        public boolean isOmmitedForConflict(MavenDependencyNode dependencyNode) {
                            return dependencyNode.getState() == 2;
                        }

                        public boolean isIncluded(MavenDependencyNode dependencyNode) {
                            return dependencyNode.getState() == 0;
                        }
                    };
                    DependencyGraphScene.PaintingProvider<MavenDependencyNode> pp = new DependencyGraphScene.PaintingProvider<MavenDependencyNode>(){

                        public Icon getIcon(MavenDependencyNode node) {
                            return DependencyGraphTopComponent.this.getIcon(node);
                        }

                        public boolean isVisible(MavenDependencyNode node) {
                            return true;
                        }

                        public boolean isVisible(MavenDependencyNode source, MavenDependencyNode target) {
                            return true;
                        }

                        public Color getColor(MavenDependencyNode node) {
                            return node.getScopeColor();
                        }

                        public Stroke getStroke(MavenDependencyNode source, MavenDependencyNode target) {
                            return null;
                        }
                    };
                    GraphConstructor constr = new GraphConstructor(prj);
                    constr.accept(root);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ DependencyGraphScene.VersionProvider val$versionProvider;
                        final /* synthetic */ DependencyGraphScene.PaintingProvider val$pp;
                        final /* synthetic */ GraphConstructor val$constr;
                        {
                            this.val$versionProvider = versionProvider;
                            this.val$pp = paintingProvider;
                            this.val$constr = graphConstructor;
                        }

                        @Override
                        public void run() {
                            DependencyGraphScene scene2 = new DependencyGraphScene((DependencyGraphScene.ActionsProvider)new MavenActionsProvider(DependencyGraphTopComponent.this, nbProj, model), () -> DependencyGraphTopComponent.this.getSelectedDepth(), this.val$versionProvider, this.val$pp);
                            this.val$constr.updateScene(scene2);
                            DependencyGraphTopComponent.this.scene = scene2;
                            JComponent sceneView = DependencyGraphTopComponent.this.scene.getView();
                            if (sceneView == null) {
                                sceneView = DependencyGraphTopComponent.this.scene.createView();
                                sceneView.putClientProperty("print.printable", true);
                            }
                            DependencyGraphTopComponent.this.pane.setViewportView(sceneView);
                            DependencyGraphTopComponent.this.scene.setSurroundingScrollPane(DependencyGraphTopComponent.this.pane);
                            DependencyGraphTopComponent.this.scene.initialLayout();
                            DependencyGraphTopComponent.this.scene.setSelectedObjects(Collections.singleton(DependencyGraphTopComponent.this.scene.getRootGraphNode()));
                            DependencyGraphTopComponent.this.txtFind.setEnabled(true);
                            DependencyGraphTopComponent.this.btnBigger.setEnabled(true);
                            DependencyGraphTopComponent.this.btnSmaller.setEnabled(true);
                            DependencyGraphTopComponent.this.comScopes.setEnabled(true);
                            if (DependencyGraphTopComponent.this.scene.getMaxNodeDepth() > 1) {
                                DependencyGraphTopComponent.this.lblPath.setVisible(true);
                                ((SpinnerNumberModel)DependencyGraphTopComponent.this.maxPathSpinner.getModel()).setMaximum(Integer.valueOf(DependencyGraphTopComponent.this.scene.getMaxNodeDepth()));
                                DependencyGraphTopComponent.this.maxPathSpinner.setEnabled(true);
                                DependencyGraphTopComponent.this.maxPathSpinner.setVisible(true);
                            }
                            DependencyGraphTopComponent.this.scene.highlightDepth(DependencyGraphTopComponent.this.getSelectedDepth());
                        }
                    });
                }
            });
        } else {
            LOG.log(Level.WARNING, "{0} missing DependencyNode and/or Project", ((Object)((Object)this)).hashCode());
        }
    }

    public JComponent getVisualRepresentation() {
        this.jPanel1.removeAll();
        this.jToolBar1.removeAll();
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new EditorToolbar();
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.addSeparator();
            Dimension space = new Dimension(3, 0);
            this.toolbar.add(this.btnGraph);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.btnBigger);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.btnSmaller);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.lblFind);
            this.toolbar.add(this.txtFind);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.lblPath);
            this.toolbar.add(this.maxPathSpinner);
            this.toolbar.addSeparator(space);
            this.toolbar.add(this.lblScopes);
            this.toolbar.add(this.comScopes);
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void setPaneText(String text, boolean progress) {
        JComponent vView;
        if (progress) {
            JPanel panel = new JPanel();
            JProgressBar pb = new JProgressBar();
            JLabel lbl = new JLabel();
            panel.setLayout(new GridBagLayout());
            panel.setOpaque(false);
            pb.setIndeterminate(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            panel.add((Component)pb, gridBagConstraints);
            Mnemonics.setLocalizedText((JLabel)lbl, (String)text);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            panel.add((Component)lbl, gridBagConstraints);
            vView = panel;
        } else {
            JLabel lbl = new JLabel(text);
            lbl.setHorizontalAlignment(0);
            lbl.setVerticalAlignment(0);
            vView = lbl;
        }
        this.pane.setViewportView(vView);
    }

    public Icon getIcon(MavenDependencyNode n) {
        return this.projectIcons.get(n.getArtifact());
    }

    private Map<Artifact, Icon> getIconsForOpenProjects() {
        Project[] openProjects;
        HashMap<Artifact, Icon> result = new HashMap<Artifact, Icon>();
        for (Project project : openProjects = OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProject mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (null == mavenProject) continue;
            Artifact artifact = mavenProject.getMavenProject().getArtifact();
            Icon icon = ProjectUtils.getInformation((Project)project).getIcon();
            if (null == icon) continue;
            result.put(artifact, icon);
        }
        return result;
    }

    public static class EditorToolbar
    extends Toolbar {
        public EditorToolbar() {
            Border b = UIManager.getBorder("Nb.Editor.Toolbar.border");
            this.setBorder(b);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
        }

        public String getUIClassID() {
            if (UIManager.get("Nb.Toolbar.ui") != null) {
                return "Nb.Toolbar.ui";
            }
            return super.getUIClassID();
        }

        public String getName() {
            return "editorToolbar";
        }
    }
}

