/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.netbeans.modules.php.phing.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class PhingOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(PhingOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel hintLabel;
    private JLabel installationLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton phingBrowseButton;
    private JLabel phingLabel;
    private JButton phingSearchButton;
    private JTextField phingTextField;

    public PhingOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        Object[] names = PhingExecutable.PHING_NAMES;
        assert (names.length == 3) : Arrays.toString(names);
        this.hintLabel.setText(Bundle.PhingOptionsPanel_phing_hint(names[0], names[1], names[2]));
        this.phingTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getPhing() {
        return this.phingTextField.getText();
    }

    public void setPhing(String phing) {
        this.phingTextField.setText(phing);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.phingLabel = new JLabel();
        this.phingTextField = new JTextField();
        this.phingBrowseButton = new JButton();
        this.phingSearchButton = new JButton();
        this.hintLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.installationLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.phingLabel.setLabelFor(this.phingTextField);
        Mnemonics.setLocalizedText((JLabel)this.phingLabel, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.phingLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phingBrowseButton, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.phingBrowseButton.text"));
        this.phingBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhingOptionsPanel.this.phingBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phingSearchButton, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.phingSearchButton.text"));
        this.phingSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhingOptionsPanel.this.phingSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationLabel, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.installationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(PhingOptionsPanel.class, (String)"PhingOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PhingOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhingOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.phingTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phingBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phingSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationLabel).addComponent(this.learnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phingLabel).addComponent(this.phingTextField, -2, -1, -2).addComponent(this.phingBrowseButton).addComponent(this.phingSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.phing.info/"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void phingBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(PhingOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.PhingOptionsPanel_phing_browse_title()).showOpenDialog();
        if (file != null) {
            this.phingTextField.setText(file.getAbsolutePath());
        }
    }

    private void phingSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        String phing = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])PhingExecutable.PHING_NAMES);
            }

            public String getWindowTitle() {
                return Bundle.PhingOptionsPanel_search_scripts_title();
            }

            public String getListTitle() {
                return Bundle.PhingOptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.PhingOptionsPanel_search_scripts_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.PhingOptionsPanel_search_scripts_notFound();
            }
        });
        if (phing != null) {
            this.phingTextField.setText(phing);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhingOptionsPanel.this.fireChange();
        }
    }
}

